/*
 * Decompiled with CFR 0.152.
 */
package ec.rule.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.rule.RuleDefaults;
import ec.rule.RuleIndividual;
import ec.rule.RuleInitializer;
import ec.rule.RuleSet;
import ec.util.IntBag;
import ec.util.Parameter;
import java.util.ArrayList;
import java.util.HashMap;

public class RuleCrossoverPipeline
extends BreedingPipeline {
    public static final String P_TOSS = "toss";
    public static final String P_CROSSOVER = "xover";
    public static final String P_CROSSOVERPROB = "crossover-prob";
    public static final int INDS_PRODUCED = 2;
    public static final int NUM_SOURCES = 2;
    public static final String KEY_PARENTS = "parents";
    public boolean tossSecondParent;
    public double ruleCrossProbability;
    ArrayList<Individual> parents = new ArrayList();

    @Override
    public Parameter defaultBase() {
        return RuleDefaults.base().push(P_CROSSOVER);
    }

    @Override
    public int numSources() {
        return 2;
    }

    @Override
    public Object clone() {
        RuleCrossoverPipeline c = (RuleCrossoverPipeline)super.clone();
        c.parents = new ArrayList<Individual>(this.parents);
        return c;
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.tossSecondParent = state.parameters.getBoolean(base.push(P_TOSS), def.push(P_TOSS), false);
        this.ruleCrossProbability = state.parameters.getDoubleWithDefault(base.push(P_CROSSOVERPROB), def.push(P_CROSSOVERPROB), 0.5);
        if (this.ruleCrossProbability > 1.0 || this.ruleCrossProbability < 0.0) {
            state.output.fatal("Rule cross probability must be between 0 and 1", base.push(P_CROSSOVERPROB), def.push(P_CROSSOVERPROB));
        }
    }

    @Override
    public int typicalIndsProduced() {
        return this.tossSecondParent ? 1 : 2;
    }

    @Override
    public int produce(int min, int max, int subpopulation, ArrayList<Individual> inds, EvolutionState state, int thread, HashMap<String, Object> misc) {
        int n;
        int start = inds.size();
        int n2 = n = this.tossSecondParent ? 1 : 2;
        if (n < min) {
            n = min;
        }
        if (n > max) {
            n = max;
        }
        if (!state.random[thread].nextBoolean(this.likelihood)) {
            this.sources[0].produce(n, n, subpopulation, inds, state, thread, misc);
            return n;
        }
        IntBag[] parentparents = null;
        IntBag[] preserveParents = null;
        if (misc != null && misc.get(KEY_PARENTS) != null) {
            preserveParents = (IntBag[])misc.get(KEY_PARENTS);
            parentparents = new IntBag[2];
            misc.put(KEY_PARENTS, parentparents);
        }
        RuleInitializer initializer = (RuleInitializer)state.initializer;
        int q = start;
        while (q < n + start) {
            this.parents.clear();
            if (this.sources[0] == this.sources[1]) {
                this.sources[0].produce(2, 2, subpopulation, this.parents, state, thread, misc);
            } else {
                this.sources[0].produce(1, 1, subpopulation, this.parents, state, thread, misc);
                this.sources[1].produce(1, 1, subpopulation, this.parents, state, thread, misc);
            }
            ((RuleIndividual)this.parents.get(0)).preprocessIndividual(state, thread);
            ((RuleIndividual)this.parents.get(1)).preprocessIndividual(state, thread);
            if (((RuleIndividual)this.parents.get((int)0)).rulesets.length != ((RuleIndividual)this.parents.get((int)1)).rulesets.length) {
                state.output.fatal("The number of rule sets should be identical in both parents ( " + ((RuleIndividual)this.parents.get((int)0)).rulesets.length + " : " + ((RuleIndividual)this.parents.get((int)1)).rulesets.length + " ).");
            }
            for (int x = 0; x < ((RuleIndividual)this.parents.get((int)0)).rulesets.length; ++x) {
                RuleSet[] temp = new RuleSet[2];
                while (true) {
                    for (int i = 0; i < 2; ++i) {
                        temp[i] = new RuleSet();
                    }
                    temp = ((RuleIndividual)this.parents.get((int)0)).rulesets[x].splitIntoTwo(state, thread, temp, this.ruleCrossProbability);
                    temp = ((RuleIndividual)this.parents.get((int)1)).rulesets[x].splitIntoTwo(state, thread, temp, 1.0 - this.ruleCrossProbability);
                    if (temp[0].numRules >= ((RuleIndividual)this.parents.get((int)0)).rulesets[x].constraints((RuleInitializer)initializer).minSize && temp[0].numRules <= ((RuleIndividual)this.parents.get((int)0)).rulesets[x].constraints((RuleInitializer)initializer).maxSize && temp[1].numRules >= ((RuleIndividual)this.parents.get((int)1)).rulesets[x].constraints((RuleInitializer)initializer).minSize && temp[1].numRules <= ((RuleIndividual)this.parents.get((int)1)).rulesets[x].constraints((RuleInitializer)initializer).maxSize) break;
                    temp = new RuleSet[2];
                }
                ((RuleIndividual)this.parents.get((int)0)).rulesets[x].copyNoClone(temp[1]);
                ((RuleIndividual)this.parents.get((int)1)).rulesets[x].copyNoClone(temp[0]);
            }
            ((RuleIndividual)this.parents.get(0)).postprocessIndividual(state, thread);
            ((RuleIndividual)this.parents.get(1)).postprocessIndividual(state, thread);
            ((RuleIndividual)this.parents.get((int)0)).evaluated = false;
            ((RuleIndividual)this.parents.get((int)1)).evaluated = false;
            inds.add(this.parents.get(0));
            if (preserveParents != null) {
                parentparents[0].addAll(parentparents[1]);
                preserveParents[q] = parentparents[0];
            }
            if (++q >= n + start || this.tossSecondParent) continue;
            inds.add(this.parents.get(1));
            if (preserveParents != null) {
                parentparents[0].addAll(parentparents[1]);
                preserveParents[q] = parentparents[0];
            }
            ++q;
        }
        return n;
    }
}

