/*
 * Decompiled with CFR 0.152.
 */
package ec.select;

import ec.EvolutionState;
import ec.Individual;
import ec.SelectionMethod;
import ec.select.SelectDefaults;
import ec.util.Parameter;
import java.util.ArrayList;

public class AnnealedSelection
extends SelectionMethod {
    private static final long serialVersionUID = 1L;
    public static final String P_ANNEALED = "annealed";
    public static final String P_CACHE = "cache";
    public static final String P_TEMPERATURE = "temperature";
    public static final String P_CUTDOWN = "cutdown";
    public static final double V_CUTDOWN = 0.95;
    boolean cache;
    int best;
    double temperature;
    double t;
    double cutdown;

    @Override
    public Parameter defaultBase() {
        return SelectDefaults.base().push(P_ANNEALED);
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.cache = state.parameters.getBoolean(base.push(P_CACHE), def.push(P_CACHE), false);
        this.temperature = state.parameters.getDoubleWithDefault(base.push(P_TEMPERATURE), def.push(P_TEMPERATURE), 0.0);
        if (this.temperature < 0.0) {
            state.output.fatal("TopSelection temperature, if defined, must be >= 0", base.push(P_TEMPERATURE), def.push(P_TEMPERATURE));
        }
        this.cutdown = state.parameters.getDoubleWithDefault(base.push(P_CUTDOWN), def.push(P_CUTDOWN), 0.95);
        if (this.cutdown < 0.0 || this.cutdown > 1.0) {
            state.output.fatal("TopSelection cutdown, if defined, must be between 0 and 1.  Default is 0.95.", base.push(P_TEMPERATURE), def.push(P_TEMPERATURE));
        }
    }

    @Override
    public void prepareToProduce(EvolutionState s, int subpopulation, int thread) {
        super.prepareToProduce(s, subpopulation, thread);
        if (this.cache) {
            this.best = -1;
        }
    }

    public void cacheBest(int subpopulation, EvolutionState state, int thread) {
        ArrayList<Individual> oldinds = state.population.subpops.get((int)subpopulation).individuals;
        int len = oldinds.size();
        if (len == 1) {
            this.best = 0;
        } else {
            int candidate = state.random[thread].nextInt(len - 1) + 1;
            Individual first = oldinds.get(0);
            Individual next = oldinds.get(candidate);
            this.best = next.fitness.betterThan(first.fitness) ? candidate : (next.fitness.equivalentTo(first.fitness) && state.random[thread].nextBoolean() ? candidate : (state.random[thread].nextBoolean(Math.exp((next.fitness.fitness() - first.fitness.fitness()) / this.t)) ? candidate : 0));
        }
        this.t = this.temperature * Math.pow(this.cutdown, state.generation);
    }

    @Override
    public int produce(int subpopulation, EvolutionState state, int thread) {
        if (!this.cache || this.best < 0) {
            this.cacheBest(subpopulation, state, thread);
        }
        return this.best;
    }
}

