/*
 * Decompiled with CFR 0.152.
 */
package ec.select;

import ec.EvolutionState;
import ec.Individual;
import ec.SelectionMethod;
import ec.select.SelectDefaults;
import ec.util.MersenneTwisterFast;
import ec.util.Parameter;
import ec.util.QuickSort;
import ec.util.SortComparatorL;
import java.util.ArrayList;

public class BestSelection
extends SelectionMethod {
    private static final long serialVersionUID = 1L;
    public static final String P_BEST = "best";
    public static final String P_N = "n";
    public static final String P_N_FRACTION = "n-fraction";
    public static final String P_PICKWORST = "pick-worst";
    public static final String P_SIZE = "size";
    public int size;
    public double probabilityOfPickingSizePlusOne;
    public boolean pickWorst;
    public int[] sortedPop;
    public static final int NOT_SET = -1;
    public int bestn = -1;
    public double bestnFrac = -1.0;

    @Override
    public Parameter defaultBase() {
        return SelectDefaults.base().push(P_BEST);
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        if (state.parameters.exists(base.push(P_N), def.push(P_N))) {
            this.bestn = state.parameters.getInt(base.push(P_N), def.push(P_N), 1);
            if (this.bestn == 0) {
                state.output.fatal("n must be an integer greater than 0", base.push(P_N), def.push(P_N));
            }
        } else if (state.parameters.exists(base.push(P_N_FRACTION), def.push(P_N_FRACTION))) {
            if (state.parameters.exists(base.push(P_N), def.push(P_N))) {
                state.output.fatal("Both n and n-fraction specified for BestSelection.", base.push(P_N), def.push(P_N));
            }
            this.bestnFrac = state.parameters.getDoubleWithMax(base.push(P_N_FRACTION), def.push(P_N_FRACTION), 0.0, 1.0);
            if (this.bestnFrac <= 0.0) {
                state.output.fatal("n-fraction must be a double floating-point value greater than 0.0 and <= 1.0", base.push(P_N_FRACTION), def.push(P_N_FRACTION));
            }
        } else {
            state.output.fatal("Either n or n-fraction must be defined for BestSelection.", base.push(P_N), def.push(P_N));
        }
        this.pickWorst = state.parameters.getBoolean(base.push(P_PICKWORST), def.push(P_PICKWORST), false);
        double val = state.parameters.getDouble(base.push(P_SIZE), def.push(P_SIZE), 1.0);
        if (val < 1.0) {
            state.output.fatal("Tournament size must be >= 1.", base.push(P_SIZE), def.push(P_SIZE));
        } else if (val == (double)((int)val)) {
            this.size = (int)val;
            this.probabilityOfPickingSizePlusOne = 0.0;
        } else {
            this.size = (int)Math.floor(val);
            this.probabilityOfPickingSizePlusOne = val - (double)this.size;
        }
    }

    @Override
    public void prepareToProduce(EvolutionState s, int subpopulation, int thread) {
        int x;
        super.prepareToProduce(s, subpopulation, thread);
        final ArrayList<Individual> i = s.population.subpops.get((int)subpopulation).individuals;
        this.sortedPop = new int[i.size()];
        for (x = 0; x < this.sortedPop.length; ++x) {
            this.sortedPop[x] = x;
        }
        QuickSort.qsort(this.sortedPop, new SortComparatorL(){

            @Override
            public boolean lt(long a, long b) {
                return ((Individual)i.get((int)((int)b))).fitness.betterThan(((Individual)i.get((int)((int)a))).fitness);
            }

            @Override
            public boolean gt(long a, long b) {
                return ((Individual)i.get((int)((int)a))).fitness.betterThan(((Individual)i.get((int)((int)b))).fitness);
            }
        });
        if (!this.pickWorst) {
            for (x = 0; x < this.sortedPop.length / 2; ++x) {
                int p = this.sortedPop[x];
                this.sortedPop[x] = this.sortedPop[this.sortedPop.length - x - 1];
                this.sortedPop[this.sortedPop.length - x - 1] = p;
            }
        }
        if (this.bestnFrac != -1.0) {
            this.bestn = (int)Math.max(Math.floor((double)s.population.subpops.get((int)subpopulation).individuals.size() * this.bestnFrac), 1.0);
        }
    }

    int getTournamentSizeToUse(MersenneTwisterFast random) {
        double p = this.probabilityOfPickingSizePlusOne;
        if (p == 0.0) {
            return this.size;
        }
        return this.size + (random.nextBoolean(p) ? 1 : 0);
    }

    @Override
    public int produce(int subpopulation, EvolutionState state, int thread) {
        ArrayList<Individual> oldinds = state.population.subpops.get((int)subpopulation).individuals;
        int best = state.random[thread].nextInt(this.bestn);
        int s = this.getTournamentSizeToUse(state.random[thread]);
        if (this.pickWorst) {
            for (int x = 1; x < s; ++x) {
                int j = state.random[thread].nextInt(this.bestn);
                if (oldinds.get((int)this.sortedPop[j]).fitness.betterThan(oldinds.get((int)this.sortedPop[best]).fitness)) continue;
                best = j;
            }
        } else {
            for (int x = 1; x < s; ++x) {
                int j = state.random[thread].nextInt(this.bestn);
                if (!oldinds.get((int)this.sortedPop[j]).fitness.betterThan(oldinds.get((int)this.sortedPop[best]).fitness)) continue;
                best = j;
            }
        }
        return this.sortedPop[best];
    }

    @Override
    public void finishProducing(EvolutionState s, int subpopulation, int thread) {
        super.finishProducing(s, subpopulation, thread);
        this.sortedPop = null;
    }
}

