/*
 * Decompiled with CFR 0.152.
 */
package ec.select;

import ec.EvolutionState;
import ec.select.FitProportionateSelection;
import ec.select.SelectDefaults;
import ec.util.Parameter;
import ec.util.RandomChoice;

public class BoltzmannSelection
extends FitProportionateSelection {
    private static final long serialVersionUID = 1L;
    public static final String P_BOLTZMANN = "boltzmann";
    public static final String P_STARTING_TEMPERATURE = "starting-temperature";
    public static final String P_COOLING_RATE = "cooling-rate";
    private double startingTemperature;
    private double coolingRate;

    @Override
    public Parameter defaultBase() {
        return SelectDefaults.base().push(P_BOLTZMANN);
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        int total_generations;
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.coolingRate = state.parameters.getDouble(base.push(P_COOLING_RATE), def.push(P_COOLING_RATE));
        this.startingTemperature = state.parameters.getDouble(base.push(P_STARTING_TEMPERATURE), def.push(P_STARTING_TEMPERATURE));
        if (this.coolingRate <= 0.0) {
            state.output.fatal("Cooling rate should be a positive value.", base.push(P_COOLING_RATE), def.push(P_COOLING_RATE));
        }
        if (this.startingTemperature - this.coolingRate <= 0.0) {
            state.output.fatal("For best results, try to set your temperature to cool to 0 a more slowly. This can be acheived by increasing your starting-temperature and/or decreasing your cooling rate.\nstarting-temperatire/cooling-rate: " + this.startingTemperature + " / " + this.coolingRate);
        }
        if ((total_generations = state.numGenerations) == 0) {
            state.output.fatal("Hey now, we gotta load the total_generations from the param DB");
        }
        if (this.startingTemperature - this.coolingRate * (double)total_generations > 0.0) {
            state.output.warning("If you want BoltzmannnSelection to be effective, your temperature should cool to 0 before all generations have passed. Make sure that (starting-temperature - (cooling-rate * generations)) <= 0.");
        }
    }

    @Override
    public void prepareToProduce(EvolutionState s, int subpopulation, int thread) {
        super.prepareToProduce(s, subpopulation, thread);
        this.fitnesses = new double[s.population.subpops.get((int)subpopulation).individuals.size()];
        for (int x = 0; x < this.fitnesses.length; ++x) {
            this.fitnesses[x] = this.boltzmannExpectedValue(s.population.subpops.get((int)subpopulation).individuals.get((int)x).fitness.fitness(), s);
            if (!(this.fitnesses[x] < 0.0)) continue;
            s.output.fatal("Discovered a negative fitness value.  BoltzmannnSelection requires that all fitness values be non-negative(offending subpopulation #" + subpopulation + ")");
        }
        RandomChoice.organizeDistribution(this.fitnesses, true);
    }

    double boltzmannExpectedValue(double fitness, EvolutionState s) {
        double current_temperature = this.startingTemperature - this.coolingRate * (double)s.generation;
        if (current_temperature < 1.0) {
            return fitness;
        }
        return Math.exp(fitness / current_temperature);
    }
}

