/*
 * Decompiled with CFR 0.152.
 */
package ec.select;

import ec.EvolutionState;
import ec.SelectionMethod;
import ec.select.SelectDefaults;
import ec.util.Parameter;
import ec.util.RandomChoice;

public class FitProportionateSelection
extends SelectionMethod {
    private static final long serialVersionUID = 1L;
    public static final String P_FITNESSPROPORTIONATE = "fitness-proportionate";
    public double[] fitnesses;

    @Override
    public Parameter defaultBase() {
        return SelectDefaults.base().push(P_FITNESSPROPORTIONATE);
    }

    @Override
    public void prepareToProduce(EvolutionState s, int subpopulation, int thread) {
        super.prepareToProduce(s, subpopulation, thread);
        this.fitnesses = new double[s.population.subpops.get((int)subpopulation).individuals.size()];
        for (int x = 0; x < this.fitnesses.length; ++x) {
            this.fitnesses[x] = s.population.subpops.get((int)subpopulation).individuals.get((int)x).fitness.fitness();
            if (!(this.fitnesses[x] < 0.0)) continue;
            s.output.fatal("Discovered a negative fitness value.  FitProportionateSelection requires that all fitness values be non-negative(offending subpopulation #" + subpopulation + ")");
        }
        RandomChoice.organizeDistribution(this.fitnesses, true);
    }

    @Override
    public int produce(int subpopulation, EvolutionState state, int thread) {
        return RandomChoice.pickFromDistribution(this.fitnesses, state.random[thread].nextDouble());
    }

    @Override
    public void finishProducing(EvolutionState s, int subpopulation, int thread) {
        super.finishProducing(s, subpopulation, thread);
        this.fitnesses = null;
    }
}

