/*
 * Decompiled with CFR 0.152.
 */
package ec.select;

import ec.EvolutionState;
import ec.Fitness;
import ec.Individual;
import ec.SelectionMethod;
import ec.select.SelectDefaults;
import ec.util.MersenneTwisterFast;
import ec.util.Parameter;
import java.util.ArrayList;
import java.util.Iterator;

public class LexicaseSelection
extends SelectionMethod {
    private static final long serialVersionUID = 1L;
    public static final String P_LEXICASESELECT = "lexicaseselect";

    @Override
    public Parameter defaultBase() {
        return SelectDefaults.base().push(P_LEXICASESELECT);
    }

    @Override
    public int produce(int subpopulation, EvolutionState state, int thread) {
        int i;
        assert (state != null);
        assert (subpopulation >= 0);
        assert (subpopulation < state.population.subpops.size());
        assert (state.population.subpops.get(subpopulation) != null);
        assert (state.population.subpops.get((int)subpopulation).individuals.size() > 0);
        ArrayList<Individual> pop = state.population.subpops.get((int)subpopulation).individuals;
        ArrayList<Integer> candidates = new ArrayList<Integer>();
        for (int i2 = 0; i2 < pop.size(); ++i2) {
            candidates.add(i2);
        }
        assert (pop.get((int)((Integer)candidates.get((int)0)).intValue()).fitness.trials != null);
        int numCases = pop.get((int)0).fitness.trials.size();
        if (numCases == 0) {
            state.output.fatal(String.format("Attempted to use %s on an individual with an empty list of trials.", this.getClass().getSimpleName()));
        }
        int[] caseOrder = new int[numCases];
        for (i = 0; i < numCases; ++i) {
            caseOrder[i] = i;
        }
        this.shuffle(state, caseOrder);
        for (i = 0; i < caseOrder.length; ++i) {
            Fitness caseFitness;
            int currentCase = caseOrder[i];
            Fitness best = (Fitness)pop.get((int)((Integer)candidates.get((int)0)).intValue()).fitness.trials.get(currentCase);
            for (int j = 1; j < candidates.size(); ++j) {
                assert (pop.get((int)((Integer)candidates.get((int)j)).intValue()).fitness.trials != null);
                assert (pop.get((int)((Integer)candidates.get((int)j)).intValue()).fitness.trials.size() == numCases);
                caseFitness = (Fitness)pop.get((int)((Integer)candidates.get((int)j)).intValue()).fitness.trials.get(currentCase);
                if (!caseFitness.betterThan(best)) continue;
                best = caseFitness;
            }
            Iterator it = candidates.iterator();
            while (it.hasNext()) {
                caseFitness = (Fitness)pop.get((int)((Integer)it.next()).intValue()).fitness.trials.get(currentCase);
                if (caseFitness.compareTo(best) <= 0) continue;
                it.remove();
            }
            if (candidates.size() == 1) {
                return (Integer)candidates.get(0);
            }
            if (i != caseOrder.length - 1) continue;
            return (Integer)candidates.get(state.random[0].nextInt(candidates.size()));
        }
        throw new IllegalStateException();
    }

    private void shuffle(EvolutionState state, int[] a) {
        MersenneTwisterFast mtf = state.random[0];
        for (int x = a.length - 1; x >= 1; --x) {
            int rand = mtf.nextInt(x + 1);
            int obj = a[x];
            a[x] = a[rand];
            a[rand] = obj;
        }
    }
}

