/*
 * Decompiled with CFR 0.152.
 */
package ec.select;

import ec.BreedingSource;
import ec.EvolutionState;
import ec.Population;
import ec.SelectionMethod;
import ec.select.SelectDefaults;
import ec.util.Parameter;

public class MultiSelection
extends SelectionMethod {
    private static final long serialVersionUID = 1L;
    public static final String P_NUMSELECTS = "num-selects";
    public static final String P_SELECT = "select";
    public static final String P_MULTISELECT = "multiselect";
    public SelectionMethod[] selects;

    @Override
    public Parameter defaultBase() {
        return SelectDefaults.base().push(P_MULTISELECT);
    }

    @Override
    public Object clone() {
        MultiSelection c = (MultiSelection)super.clone();
        c.selects = new SelectionMethod[this.selects.length];
        for (int x = 0; x < this.selects.length; ++x) {
            c.selects[x] = (SelectionMethod)this.selects[x].clone();
        }
        return c;
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        int x;
        super.setup(state, base);
        Parameter def = this.defaultBase();
        int numSelects = state.parameters.getInt(base.push(P_NUMSELECTS), def.push(P_NUMSELECTS), 1);
        if (numSelects == 0) {
            state.output.fatal("The number of MultiSelection sub-selection methods must be >= 1).", base.push(P_NUMSELECTS), def.push(P_NUMSELECTS));
        }
        this.selects = new SelectionMethod[numSelects];
        double total = 0.0;
        for (x = 0; x < numSelects; ++x) {
            Parameter p = base.push(P_SELECT).push("" + x);
            Parameter d = def.push(P_SELECT).push("" + x);
            this.selects[x] = (SelectionMethod)state.parameters.getInstanceForParameter(p, d, SelectionMethod.class);
            this.selects[x].setup(state, p);
            if (this.selects[x].probability < 0.0) {
                state.output.error("MultiSelection select #" + x + " must have a probability >= 0.0", p.push("prob"), d.push("prob"));
                continue;
            }
            total += this.selects[x].probability;
        }
        state.output.exitIfErrors();
        if (total <= 0.0) {
            state.output.fatal("MultiSelection selects do not sum to a positive probability", base);
        }
        if (total != 1.0) {
            state.output.message("Must normalize probabilities for " + String.valueOf(base));
            for (x = 0; x < numSelects; ++x) {
                this.selects[x].probability /= total;
            }
        }
        double tmp = 0.0;
        for (int x2 = 0; x2 < numSelects - 1; ++x2) {
            this.selects[x2].probability = tmp += this.selects[x2].probability;
        }
        this.selects[numSelects - 1].probability = 1.0;
    }

    @Override
    public boolean produces(EvolutionState state, Population newpop, int subpopulation, int thread) {
        if (!super.produces(state, newpop, subpopulation, thread)) {
            return false;
        }
        for (int x = 0; x < this.selects.length; ++x) {
            if (this.selects[x].produces(state, newpop, subpopulation, thread)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void prepareToProduce(EvolutionState s, int subpopulation, int thread) {
        super.prepareToProduce(s, subpopulation, thread);
        for (int x = 0; x < this.selects.length; ++x) {
            this.selects[x].prepareToProduce(s, subpopulation, thread);
        }
    }

    @Override
    public int produce(int subpopulation, EvolutionState state, int thread) {
        return this.selects[BreedingSource.pickRandom(this.selects, state.random[thread].nextDouble())].produce(subpopulation, state, thread);
    }

    @Override
    public void preparePipeline(Object hook) {
        for (int x = 0; x < this.selects.length; ++x) {
            this.selects[x].preparePipeline(hook);
        }
    }
}

