/*
 * Decompiled with CFR 0.152.
 */
package ec.select;

import ec.EvolutionState;
import ec.SelectionMethod;
import ec.select.SelectDefaults;
import ec.util.MersenneTwisterFast;
import ec.util.Parameter;
import ec.util.RandomChoice;

public class SUSSelection
extends SelectionMethod {
    private static final long serialVersionUID = 1L;
    public static final String P_SUS = "sus";
    public static final String P_SHUFFLE = "shuffle";
    public int[] indices;
    public double[] fitnesses;
    public boolean shuffle = true;
    public double offset = 0.0;
    public int lastIndex;
    public int steps;

    @Override
    public Parameter defaultBase() {
        return SelectDefaults.base().push(P_SUS);
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.shuffle = state.parameters.getBoolean(base.push(P_SHUFFLE), def.push(P_SHUFFLE), true);
    }

    void shuffle(MersenneTwisterFast random, double[] fitnesses, int[] indices) {
        int numObjs = fitnesses.length;
        for (int x = numObjs - 1; x >= 1; --x) {
            int rand = random.nextInt(x + 1);
            double f = fitnesses[x];
            fitnesses[x] = fitnesses[rand];
            fitnesses[rand] = f;
            int i = indices[x];
            indices[x] = indices[rand];
            indices[rand] = i;
        }
    }

    @Override
    public void prepareToProduce(EvolutionState s, int subpopulation, int thread) {
        super.prepareToProduce(s, subpopulation, thread);
        this.lastIndex = 0;
        this.steps = 0;
        this.fitnesses = new double[s.population.subpops.get((int)subpopulation).individuals.size()];
        this.offset = s.random[thread].nextDouble() / (double)this.fitnesses.length;
        for (int x = 0; x < this.fitnesses.length; ++x) {
            this.fitnesses[x] = s.population.subpops.get((int)subpopulation).individuals.get((int)x).fitness.fitness();
            if (!(this.fitnesses[x] < 0.0)) continue;
            s.output.fatal("Discovered a negative fitness value.  SUSSelection requires that all fitness values be non-negative(offending subpopulation #" + subpopulation + ")");
        }
        this.indices = new int[s.population.subpops.get((int)subpopulation).individuals.size()];
        for (int i = 0; i < this.indices.length; ++i) {
            this.indices[i] = i;
        }
        if (this.shuffle) {
            this.shuffle(s.random[thread], this.fitnesses, this.indices);
        }
        RandomChoice.organizeDistribution(this.fitnesses, true);
    }

    @Override
    public int produce(int subpopulation, EvolutionState state, int thread) {
        if (this.steps >= this.fitnesses.length) {
            state.output.warning("SUSSelection was asked for too many individuals, so we're re-shuffling.  This will give you proper results, but it might suggest an error in your code.");
            boolean s = this.shuffle;
            this.shuffle = true;
            this.prepareToProduce(state, subpopulation, thread);
            this.shuffle = s;
        }
        while (this.lastIndex < this.fitnesses.length - 1 && (this.lastIndex != 0 && !(this.offset >= this.fitnesses[this.lastIndex - 1]) || !(this.offset < this.fitnesses[this.lastIndex]))) {
            ++this.lastIndex;
        }
        this.offset += 1.0 / (double)this.fitnesses.length;
        ++this.steps;
        return this.indices[this.lastIndex];
    }
}

