/*
 * Decompiled with CFR 0.152.
 */
package ec.select;

import ec.EvolutionState;
import ec.Individual;
import ec.SelectionMethod;
import ec.select.SelectDefaults;
import ec.steadystate.SteadyStateBSourceForm;
import ec.steadystate.SteadyStateEvolutionState;
import ec.util.MersenneTwisterFast;
import ec.util.Parameter;
import java.util.ArrayList;

public class TournamentSelection
extends SelectionMethod
implements SteadyStateBSourceForm {
    private static final long serialVersionUID = 1L;
    public static final String P_TOURNAMENT = "tournament";
    public static final String P_PICKWORST = "pick-worst";
    public static final String P_SIZE = "size";
    public int size;
    public double probabilityOfPickingSizePlusOne;
    public boolean pickWorst;

    @Override
    public Parameter defaultBase() {
        return SelectDefaults.base().push(P_TOURNAMENT);
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        double val = state.parameters.getDouble(base.push(P_SIZE), def.push(P_SIZE), 1.0);
        if (val < 1.0) {
            state.output.fatal("Tournament size must be >= 1.", base.push(P_SIZE), def.push(P_SIZE));
        } else if (val == (double)((int)val)) {
            this.size = (int)val;
            this.probabilityOfPickingSizePlusOne = 0.0;
        } else {
            this.size = (int)Math.floor(val);
            this.probabilityOfPickingSizePlusOne = val - (double)this.size;
        }
        this.pickWorst = state.parameters.getBoolean(base.push(P_PICKWORST), def.push(P_PICKWORST), false);
    }

    public int getTournamentSizeToUse(MersenneTwisterFast random) {
        double p = this.probabilityOfPickingSizePlusOne;
        if (p == 0.0) {
            return this.size;
        }
        return this.size + (random.nextBoolean(p) ? 1 : 0);
    }

    public int getRandomIndividual(int number, int subpopulation, EvolutionState state, int thread) {
        ArrayList<Individual> oldinds = state.population.subpops.get((int)subpopulation).individuals;
        return state.random[thread].nextInt(oldinds.size());
    }

    public boolean betterThan(Individual first, Individual second, int subpopulation, EvolutionState state, int thread) {
        return first.fitness.betterThan(second.fitness);
    }

    @Override
    public int produce(int subpopulation, EvolutionState state, int thread) {
        ArrayList<Individual> oldinds = state.population.subpops.get((int)subpopulation).individuals;
        int best = this.getRandomIndividual(0, subpopulation, state, thread);
        int s = this.getTournamentSizeToUse(state.random[thread]);
        if (this.pickWorst) {
            for (int x = 1; x < s; ++x) {
                int j = this.getRandomIndividual(x, subpopulation, state, thread);
                if (this.betterThan(oldinds.get(j), oldinds.get(best), subpopulation, state, thread)) continue;
                best = j;
            }
        } else {
            for (int x = 1; x < s; ++x) {
                int j = this.getRandomIndividual(x, subpopulation, state, thread);
                if (!this.betterThan(oldinds.get(j), oldinds.get(best), subpopulation, state, thread)) continue;
                best = j;
            }
        }
        return best;
    }

    @Override
    public void individualReplaced(SteadyStateEvolutionState state, int subpopulation, int thread, int individual) {
    }

    @Override
    public void sourcesAreProperForm(SteadyStateEvolutionState state) {
    }
}

