/*
 * Decompiled with CFR 0.152.
 */
package ec.simple;

import ec.Breeder;
import ec.BreedingSource;
import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.simple.SimpleBreederThread;
import ec.util.Parameter;
import ec.util.QuickSort;
import ec.util.SortComparatorL;
import ec.util.ThreadPool;
import java.util.ArrayList;

public class SimpleBreeder
extends Breeder {
    private static final long serialVersionUID = 1L;
    public static final String P_ELITE = "elite";
    public static final String P_ELITE_FRAC = "elite-fraction";
    public static final String P_REEVALUATE_ELITES = "reevaluate-elites";
    public static final String P_SEQUENTIAL_BREEDING = "sequential";
    public static final String P_CLONE_PIPELINE_AND_POPULATION = "clone-pipeline-and-population";
    public int[] elite;
    public double[] eliteFrac;
    public boolean[] reevaluateElites;
    public boolean clonePipelineAndPopulation;
    public Population backupPopulation = null;
    public ArrayList<Individual>[][] newIndividuals;
    public static final int NOT_SET = -1;
    public ThreadPool pool = new ThreadPool();

    public boolean usingElitism(int subpopulation) {
        return this.elite[subpopulation] > 0 || this.eliteFrac[subpopulation] > 0.0;
    }

    public int numElites(EvolutionState state, int subpopulation) {
        if (this.elite[subpopulation] != -1) {
            return this.elite[subpopulation];
        }
        if (this.eliteFrac[subpopulation] == 0.0) {
            return 0;
        }
        if (this.eliteFrac[subpopulation] != -1.0) {
            return (int)Math.max(Math.floor((double)state.population.subpops.get((int)subpopulation).individuals.size() * this.eliteFrac[subpopulation]), 1.0);
        }
        state.output.warnOnce("Elitism error (SimpleBreeder).  This shouldn't be able to happen.  Please report.");
        return 0;
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        Parameter p = new Parameter("pop").push("subpops");
        int size = state.parameters.getInt(p, null, 1);
        this.eliteFrac = new double[size];
        this.elite = new int[size];
        for (int i = 0; i < size; ++i) {
            this.elite[i] = -1;
            this.eliteFrac[i] = -1;
        }
        this.reevaluateElites = new boolean[size];
        this.sequentialBreeding = state.parameters.getBoolean(base.push(P_SEQUENTIAL_BREEDING), null, false);
        if (this.sequentialBreeding && size == 1) {
            state.output.fatal("The Breeder is breeding sequentially, but you have only one population.", base.push(P_SEQUENTIAL_BREEDING));
        }
        this.clonePipelineAndPopulation = state.parameters.getBoolean(base.push(P_CLONE_PIPELINE_AND_POPULATION), null, true);
        if (!this.clonePipelineAndPopulation && state.breedthreads > 1) {
            state.output.fatal("The Breeder is not cloning its pipeline and population, but you have more than one thread.", base.push(P_CLONE_PIPELINE_AND_POPULATION));
        }
        int defaultSubpop = state.parameters.getInt(new Parameter("pop").push("default-subpop"), null, 0);
        for (int x = 0; x < size; ++x) {
            if (state.parameters.exists(base.push(P_ELITE).push("" + x), null)) {
                if (state.parameters.exists(base.push(P_ELITE_FRAC).push("" + x), null)) {
                    state.output.error("Both elite and elite-frac specified for subpouplation " + x + ".", base.push(P_ELITE_FRAC).push("" + x), base.push(P_ELITE_FRAC).push("" + x));
                } else {
                    this.elite[x] = state.parameters.getIntWithDefault(base.push(P_ELITE).push("" + x), null, 0);
                    if (this.elite[x] < 0) {
                        state.output.error("Elites for subpopulation " + x + " must be an integer >= 0", base.push(P_ELITE).push("" + x));
                    }
                }
            } else if (state.parameters.exists(base.push(P_ELITE_FRAC).push("" + x), null)) {
                this.eliteFrac[x] = state.parameters.getDoubleWithMax(base.push(P_ELITE_FRAC).push("" + x), null, 0.0, 1.0);
                if (this.eliteFrac[x] < 0.0) {
                    state.output.error("Elite Fraction of subpopulation " + x + " must be a real value between 0.0 and 1.0 inclusive", base.push(P_ELITE_FRAC).push("" + x));
                }
            } else if (defaultSubpop >= 0) {
                if (state.parameters.exists(base.push(P_ELITE).push("" + defaultSubpop), null)) {
                    this.elite[x] = state.parameters.getIntWithDefault(base.push(P_ELITE).push("" + defaultSubpop), null, 0);
                    if (this.elite[x] < 0) {
                        state.output.warning("Invalid default subpopulation elite value.");
                    }
                } else if (state.parameters.exists(base.push(P_ELITE_FRAC).push("" + defaultSubpop), null)) {
                    this.eliteFrac[x] = state.parameters.getDoubleWithMax(base.push(P_ELITE_FRAC).push("" + defaultSubpop), null, 0.0, 1.0);
                    if (this.eliteFrac[x] < 0.0) {
                        state.output.warning("Invalid default subpopulation elite-frac value.");
                    }
                } else {
                    this.elite[x] = 0;
                }
            } else {
                this.elite[x] = 0;
            }
            if (defaultSubpop >= 0 && !state.parameters.exists(base.push(P_REEVALUATE_ELITES).push("" + x), null)) {
                this.reevaluateElites[x] = state.parameters.getBoolean(base.push(P_REEVALUATE_ELITES).push("" + defaultSubpop), null, false);
                if (!this.reevaluateElites[x]) continue;
                state.output.warning("Elite reevaluation not specified for subpopulation " + x + ".  Using values for default subpopulation " + defaultSubpop + ": " + this.reevaluateElites[x]);
                continue;
            }
            this.reevaluateElites[x] = state.parameters.getBoolean(base.push(P_REEVALUATE_ELITES).push("" + x), null, false);
        }
        state.output.exitIfErrors();
    }

    protected int nextSubpopulationSize(EvolutionState state, int subpop) {
        return state.population.subpops.get((int)subpop).individuals.size();
    }

    @Override
    public Population breedPopulation(EvolutionState state) {
        Population newpop = null;
        if (this.clonePipelineAndPopulation) {
            newpop = state.population.emptyClone();
        } else {
            if (this.backupPopulation == null) {
                this.backupPopulation = state.population.emptyClone();
            }
            newpop = this.backupPopulation;
            newpop.clear();
            this.backupPopulation = state.population;
        }
        int[] newSubpopSize = new int[state.population.subpops.size()];
        for (int i = 0; i < newSubpopSize.length; ++i) {
            newSubpopSize[i] = this.nextSubpopulationSize(state, i);
        }
        this.loadElites(state, newpop);
        int numThreads = 0;
        for (int x = 0; x < newpop.subpops.size(); ++x) {
            numThreads = Math.max(numThreads, newSubpopSize[x]);
        }
        if ((numThreads = Math.min(numThreads, state.breedthreads)) < state.breedthreads) {
            state.output.warnOnce("Largest subpopulation size (" + numThreads + ") is smaller than number of breedthreads (" + state.breedthreads + "), so fewer breedthreads will be created.");
        }
        this.newIndividuals = new ArrayList[state.population.subpops.size()][numThreads];
        for (int subpop = 0; subpop < state.population.subpops.size(); ++subpop) {
            for (int thread = 0; thread < numThreads; ++thread) {
                this.newIndividuals[subpop][thread] = new ArrayList();
            }
        }
        int[][] numinds = new int[numThreads][newpop.subpops.size()];
        int[][] from = new int[numThreads][newpop.subpops.size()];
        for (int x = 0; x < newpop.subpops.size(); ++x) {
            this.newIndividuals[x] = new ArrayList[numThreads];
            for (int i = 0; i < numThreads; ++i) {
                this.newIndividuals[x][i] = new ArrayList();
            }
            if (!this.shouldBreedSubpop(state, x, 0)) {
                newpop.subpops.get((int)x).individuals.clear();
                newpop.subpops.get((int)x).individuals.addAll(state.population.subpops.get((int)x).individuals);
                continue;
            }
            int numElites = this.numElites(state, x);
            int length = newSubpopSize[x] - numElites;
            int individualsPerThread = length / numThreads;
            int slop = length - numThreads * individualsPerThread;
            int currentFrom = 0;
            for (int y = 0; y < numThreads; ++y) {
                if (slop > 0) {
                    numinds[y][x] = individualsPerThread + 1;
                    --slop;
                } else {
                    numinds[y][x] = individualsPerThread;
                }
                from[y][x] = currentFrom;
                currentFrom += numinds[y][x];
                if (numinds[y][x] != 0) continue;
                state.output.warnOnce("More threads exist than can be used to breed some subpopulations (first example: subpopulation " + x + ")");
            }
        }
        if (numThreads == 1) {
            this.breedPopChunk(newpop, state, numinds[0], from[0], 0);
        } else {
            for (int y = 0; y < numThreads; ++y) {
                SimpleBreederThread r = new SimpleBreederThread();
                r.threadnum = y;
                r.newpop = newpop;
                r.from = from[y];
                r.numinds = numinds[y];
                r.me = this;
                r.state = state;
                this.pool.start((Runnable)r, "ECJ Breeding Thread " + y);
            }
            this.pool.joinAll();
        }
        for (int subpop = 0; subpop < newpop.subpops.size(); ++subpop) {
            ArrayList<Individual> newpopindividuals = newpop.subpops.get((int)subpop).individuals;
            for (int thread = 0; thread < numThreads; ++thread) {
                newpopindividuals.addAll(this.newIndividuals[subpop][thread]);
            }
        }
        this.postProcess(state);
        return newpop;
    }

    public void postProcess(EvolutionState state) {
    }

    @Override
    public boolean shouldBreedSubpop(EvolutionState state, int subpop, int threadnum) {
        return !this.sequentialBreeding || state.generation % state.population.subpops.size() == subpop;
    }

    protected void breedPopChunk(Population newpop, EvolutionState state, int[] numinds, int[] from, int threadnum) {
        for (int subpop = 0; subpop < newpop.subpops.size(); ++subpop) {
            int x;
            ArrayList<Individual> putHere = this.newIndividuals[subpop][threadnum];
            BreedingSource bp = null;
            bp = this.clonePipelineAndPopulation ? (BreedingSource)newpop.subpops.get((int)subpop).species.pipe_prototype.clone() : newpop.subpops.get((int)subpop).species.pipe_prototype;
            bp.fillStubs(state, null);
            if (!bp.produces(state, newpop, subpop, threadnum)) {
                state.output.fatal("The Breeding Source of subpopulation " + subpop + " does not produce individuals of the expected species " + newpop.subpops.get((int)subpop).species.getClass().getName() + " or fitness " + String.valueOf(newpop.subpops.get((int)subpop).species.f_prototype));
            }
            bp.prepareToProduce(state, subpop, threadnum);
            for (x = 0; x < numinds[subpop]; x += bp.produce(1, numinds[subpop] - x, subpop, putHere, state, threadnum, newpop.subpops.get((int)subpop).species.buildMisc(state, subpop, threadnum))) {
            }
            if (x > numinds[subpop]) {
                state.output.fatal("Whoa!  A breeding source overwrote the space of another source in subpopulation " + subpop + ".  You need to check your breeding pipeline code (in produce() ).");
            }
            bp.finishProducing(state, subpop, threadnum);
        }
    }

    protected void breedPopChunkProduce(int position) {
    }

    protected void unmarkElitesEvaluated(EvolutionState state, Population newpop) {
        for (int sub = 0; sub < newpop.subpops.size(); ++sub) {
            if (!this.shouldBreedSubpop(state, sub, 0)) continue;
            for (int e = 0; e < this.numElites(state, sub); ++e) {
                int len = newpop.subpops.get((int)sub).individuals.size();
                if (!this.reevaluateElites[sub]) continue;
                newpop.subpops.get((int)sub).individuals.get((int)(len - e - 1)).evaluated = false;
            }
        }
    }

    protected void loadElites(EvolutionState state, Population newpop) {
        for (int x = 0; x < state.population.subpops.size(); ++x) {
            if (this.numElites(state, x) > state.population.subpops.get((int)x).individuals.size()) {
                state.output.error("The number of elites for subpopulation " + x + " exceeds the actual size of the subpopulation", new Parameter("breed").push(P_ELITE).push("" + x));
            }
            if (this.numElites(state, x) != state.population.subpops.get((int)x).individuals.size()) continue;
            state.output.warning("The number of elites for subpopulation " + x + " is the actual size of the subpopulation", new Parameter("breed").push(P_ELITE).push("" + x));
        }
        state.output.exitIfErrors();
        for (int sub = 0; sub < state.population.subpops.size(); ++sub) {
            if (!this.shouldBreedSubpop(state, sub, 0)) continue;
            if (this.numElites(state, sub) == 1) {
                int best = 0;
                ArrayList<Individual> oldinds = state.population.subpops.get((int)sub).individuals;
                for (int x = 1; x < oldinds.size(); ++x) {
                    if (!oldinds.get((int)x).fitness.betterThan(oldinds.get((int)best).fitness)) continue;
                    best = x;
                }
                ArrayList<Individual> inds = newpop.subpops.get((int)sub).individuals;
                inds.add((Individual)oldinds.get(best).clone());
                continue;
            }
            if (this.numElites(state, sub) <= 0) continue;
            int[] orderedPop = new int[state.population.subpops.get((int)sub).individuals.size()];
            for (int x = 0; x < state.population.subpops.get((int)sub).individuals.size(); ++x) {
                orderedPop[x] = x;
            }
            QuickSort.qsort(orderedPop, (SortComparatorL)new EliteComparator(state.population.subpops.get((int)sub).individuals));
            ArrayList<Individual> inds = newpop.subpops.get((int)sub).individuals;
            ArrayList<Individual> oldinds = state.population.subpops.get((int)sub).individuals;
            for (int x = oldinds.size() - this.numElites(state, sub); x < oldinds.size(); ++x) {
                inds.add((Individual)oldinds.get(orderedPop[x]).clone());
            }
        }
        this.unmarkElitesEvaluated(state, newpop);
    }

    static class EliteComparator
    implements SortComparatorL {
        ArrayList<Individual> inds;

        public EliteComparator(ArrayList<Individual> inds) {
            this.inds = inds;
        }

        @Override
        public boolean lt(long a, long b) {
            return this.inds.get((int)((int)b)).fitness.betterThan(this.inds.get((int)((int)a)).fitness);
        }

        @Override
        public boolean gt(long a, long b) {
            return this.inds.get((int)((int)a)).fitness.betterThan(this.inds.get((int)((int)b)).fitness);
        }
    }
}

