/*
 * Decompiled with CFR 0.152.
 */
package ec.simple;

import ec.EvolutionState;
import ec.Individual;
import ec.Subpopulation;
import ec.util.Checkpoint;

public class SimpleEvolutionState
extends EvolutionState {
    private static final long serialVersionUID = 1L;

    @Override
    public void startFresh() {
        this.output.message("Setting up");
        this.setup(this, null);
        this.output.message("Initializing Generation 0");
        this.statistics.preInitializationStatistics(this);
        this.population = this.initializer.initialPopulation(this, 0);
        this.statistics.postInitializationStatistics(this);
        this.exchanger.initializeContacts(this);
        this.evaluator.initializeContacts(this);
    }

    @Override
    public int evolve() {
        if (this.generation > 0) {
            this.output.message("Generation " + this.generation + "\tEvaluations So Far " + this.evaluations);
        }
        this.statistics.preEvaluationStatistics(this);
        this.evaluator.evaluatePopulation(this);
        for (int i = 0; i < this.population.subpops.size(); ++i) {
            Subpopulation subpop = this.population.subpops.get(i);
            for (Individual ind : subpop.individuals) {
                this.evaluator.postEvaluationLocalUpdate(this, ind, i);
            }
        }
        this.statistics.postEvaluationStatistics(this);
        String runCompleteMessage = this.evaluator.runComplete(this);
        if (runCompleteMessage != null && this.quitOnRunComplete) {
            this.output.message(runCompleteMessage);
            return 0;
        }
        if (this.numGenerations != 0 && this.generation >= this.numGenerations - 1 || this.numEvaluations != 0L && (long)this.evaluations >= this.numEvaluations) {
            return 1;
        }
        ++this.generation;
        this.statistics.prePreBreedingExchangeStatistics(this);
        this.population = this.exchanger.preBreedingExchangePopulation(this);
        this.statistics.postPreBreedingExchangeStatistics(this);
        String exchangerWantsToShutdown = this.exchanger.runComplete(this);
        if (exchangerWantsToShutdown != null) {
            this.output.message(exchangerWantsToShutdown);
            return 0;
        }
        this.evaluator.postEvaluationGlobalUpdate(this);
        this.statistics.preBreedingStatistics(this);
        this.population = this.breeder.breedPopulation(this);
        this.statistics.postBreedingStatistics(this);
        this.statistics.prePostBreedingExchangeStatistics(this);
        this.population = this.exchanger.postBreedingExchangePopulation(this);
        this.statistics.postPostBreedingExchangeStatistics(this);
        if (this.checkpoint && (this.generation - 1) % this.checkpointModulo == 0) {
            this.output.message("Checkpointing");
            this.statistics.preCheckpointStatistics(this);
            Checkpoint.setCheckpoint(this);
            this.statistics.postCheckpointStatistics(this);
        }
        return 2;
    }

    @Override
    public void finish(int result) {
        this.output.message("Total Evaluations " + this.evaluations);
        this.statistics.finalStatistics(this, result);
        this.finisher.finishPopulation(this, result);
        this.exchanger.closeContacts(this, result);
        this.evaluator.closeContacts(this, result);
    }
}

