/*
 * Decompiled with CFR 0.152.
 */
package ec.simple;

import ec.EvolutionState;
import ec.Fitness;
import ec.simple.SimpleDefaults;
import ec.util.Code;
import ec.util.Parameter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.LineNumberReader;

public class SimpleFitness
extends Fitness {
    private static final long serialVersionUID = 1L;
    private double fitness;
    protected boolean isIdeal;

    @Override
    public Parameter defaultBase() {
        return SimpleDefaults.base().push("fitness");
    }

    public void setFitness(EvolutionState state, double _f) {
        this.setFitness(state, _f, false);
    }

    public void setFitness(EvolutionState state, double _f, boolean _isIdeal) {
        if (_f >= Double.POSITIVE_INFINITY || _f <= Double.NEGATIVE_INFINITY || Double.isNaN(_f)) {
            state.output.warning("Bad fitness: " + _f + ", setting to 0.");
            this.fitness = 0.0;
        } else {
            this.fitness = _f;
        }
        this.isIdeal = _isIdeal;
    }

    @Override
    public double fitness() {
        return this.fitness;
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
    }

    @Override
    public boolean isIdealFitness() {
        return this.isIdeal;
    }

    @Override
    public boolean equivalentTo(Fitness _fitness) {
        return ((SimpleFitness)_fitness).fitness() == this.fitness();
    }

    @Override
    public boolean betterThan(Fitness _fitness) {
        return ((SimpleFitness)_fitness).fitness() < this.fitness();
    }

    @Override
    public String fitnessToString() {
        return "Fitness: " + Code.encode(this.fitness());
    }

    @Override
    public String fitnessToStringForHumans() {
        return "Fitness: " + this.fitness();
    }

    @Override
    public void readFitness(EvolutionState state, LineNumberReader reader) throws IOException {
        this.setFitness(state, Code.readDoubleWithPreamble("Fitness: ", state, reader));
    }

    @Override
    public void writeFitness(EvolutionState state, DataOutput dataOutput) throws IOException {
        dataOutput.writeDouble(this.fitness);
        dataOutput.writeBoolean(this.isIdeal);
        this.writeTrials(state, dataOutput);
    }

    @Override
    public void readFitness(EvolutionState state, DataInput dataInput) throws IOException {
        this.fitness = dataInput.readDouble();
        this.isIdeal = dataInput.readBoolean();
        this.readTrials(state, dataInput);
    }

    @Override
    public void setToMeanOf(EvolutionState state, Fitness[] fitnesses) {
        double f = 0.0;
        boolean ideal = true;
        for (int i = 0; i < fitnesses.length; ++i) {
            SimpleFitness fit = (SimpleFitness)fitnesses[i];
            f += fit.fitness;
            ideal = ideal && fit.isIdeal;
        }
        this.fitness = f /= (double)fitnesses.length;
        this.isIdeal = ideal;
    }
}

