/*
 * Decompiled with CFR 0.152.
 */
package ec.simple;

import ec.EvolutionState;
import ec.Individual;
import ec.Problem;
import ec.Subpopulation;
import ec.coevolve.GroupedProblemForm;
import ec.simple.SimpleEvaluator;
import java.util.ArrayList;

public class SimpleGroupedEvaluator
extends SimpleEvaluator {
    private static final long serialVersionUID = 1L;

    @Override
    protected void evalPopChunk(EvolutionState state, int[] numinds, int[] from, int threadnum, Problem p) {
        p.prepareToEvaluate(state, threadnum);
        if (!p.isGroupedProblem()) {
            state.output.fatal(String.valueOf(this.getClass()) + " used, but the Problem is not of GroupedProblemForm");
        }
        ArrayList<Subpopulation> subpops = state.population.subpops;
        int len = subpops.size();
        int pop = 0;
        while (pop < len) {
            int fp = from[pop];
            int upperbound = fp + numinds[pop];
            ArrayList<Individual> inds = new ArrayList<Individual>(subpops.get((int)pop).individuals.subList(fp, upperbound));
            ((GroupedProblemForm)((Object)p)).evaluate(state, SimpleGroupedEvaluator.toArray(inds), this.repeat(true, inds.size()), false, new int[]{pop++}, threadnum);
            state.incrementEvaluations(upperbound - fp);
        }
        p.finishEvaluating(state, threadnum);
    }

    private static Individual[] toArray(ArrayList<Individual> inds) {
        Individual[] result = new Individual[inds.size()];
        for (int i = 0; i < inds.size(); ++i) {
            result[i] = inds.get(i);
        }
        return result;
    }

    private boolean[] repeat(boolean value, int length) {
        boolean[] array = new boolean[length];
        for (int i = 0; i < length; ++i) {
            array[i] = value;
        }
        return array;
    }
}

