/*
 * Decompiled with CFR 0.152.
 */
package ec.singlestate;

import ec.Breeder;
import ec.BreedingSource;
import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.Subpopulation;
import ec.util.Parameter;
import java.util.ArrayList;

public class SingleStateBreeder
extends Breeder {
    private static final long serialVersionUID = 1L;
    public static final String P_ELITE = "elite";
    public static final String P_EXPANDED_SUBPOP_SIZE = "expanded-subpop-size";
    public static final int V_SUBPOP_NOT_RESIZED = -1;
    public boolean[] elite;
    public int[] expandedSubpopSize;
    public boolean[] stubsFilled;

    @Override
    public Population breedPopulation(EvolutionState state) {
        Population pop = state.population;
        for (int x = 0; x < pop.subpops.size(); ++x) {
            this.breedSubpop(state, pop.subpops.get(x), x);
        }
        return pop;
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        int x;
        Parameter p = new Parameter("pop").push("subpops");
        int size = state.parameters.getInt(p, null, 1);
        int defaultSubpop = state.parameters.getInt(new Parameter("pop").push("default-subpop"), null, 0);
        this.elite = new boolean[size];
        for (x = 0; x < size; ++x) {
            if (state.parameters.exists(base.push(P_ELITE).push("" + x), null)) {
                this.elite[x] = state.parameters.getBoolean(base.push(P_ELITE).push("" + x), null, false);
                continue;
            }
            if (defaultSubpop >= 0 && state.parameters.exists(base.push(P_ELITE).push("" + defaultSubpop), null)) {
                this.elite[x] = state.parameters.getBoolean(base.push(P_ELITE).push("" + defaultSubpop), null, false);
                continue;
            }
            state.output.warning("Elites not defined for subpopulation " + x + ".  Assuming false.");
            this.elite[x] = false;
        }
        this.expandedSubpopSize = new int[size];
        for (x = 0; x < size; ++x) {
            if (state.parameters.exists(base.push(P_EXPANDED_SUBPOP_SIZE).push("" + x), null)) {
                this.expandedSubpopSize[x] = state.parameters.getInt(base.push(P_EXPANDED_SUBPOP_SIZE).push("" + x), null, 1);
                continue;
            }
            if (defaultSubpop >= 0 && state.parameters.exists(base.push(P_EXPANDED_SUBPOP_SIZE).push("" + defaultSubpop), null)) {
                this.expandedSubpopSize[x] = state.parameters.getInt(base.push(P_EXPANDED_SUBPOP_SIZE).push("" + defaultSubpop), null, 1);
                continue;
            }
            state.output.warning("Expanded subpopulation size not defined for subpopulation " + x + ".  Assuming populations are not changed.");
            this.expandedSubpopSize[x] = -1;
        }
        this.stubsFilled = new boolean[size];
    }

    public void breedSubpop(EvolutionState state, Subpopulation subpop, int index) {
        BreedingSource bp = subpop.species.pipe_prototype;
        if (!this.stubsFilled[index]) {
            bp.fillStubs(state, null);
        }
        this.stubsFilled[index] = true;
        bp.prepareToProduce(state, index, 0);
        ArrayList<Individual> newIndividuals = null;
        int newlen = subpop.individuals.size();
        if (this.expandedSubpopSize[index] != -1) {
            newlen = this.expandedSubpopSize[index];
        }
        newIndividuals = new ArrayList<Individual>();
        ArrayList<Individual> individuals = subpop.individuals;
        int len = individuals.size();
        if (this.elite[index]) {
            Individual best = individuals.get(0);
            for (int i = 1; i < len; ++i) {
                Individual ind = individuals.get(i);
                if (!ind.fitness.betterThan(best.fitness)) continue;
                best = ind;
            }
            newIndividuals.add(best);
        }
        while (newIndividuals.size() < newlen) {
            bp.produce(1, newlen - newIndividuals.size(), index, newIndividuals, state, 0, null);
        }
        subpop.individuals = newIndividuals;
        bp.finishProducing(state, index, 0);
    }
}

