/*
 * Decompiled with CFR 0.152.
 */
package ec.singlestate;

import ec.EvolutionState;
import ec.util.Checkpoint;
import ec.util.Parameter;

public class SingleStateEvolutionState
extends EvolutionState {
    private static final long serialVersionUID = 1L;
    public int statisticsModulo = 1;
    public int exchangeModulo = 1;
    public static final String P_STATISTICS_MODULO = "stats-modulo";
    public static final String P_EXCHANGE_MODULO = "exchange-modulo";

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter p = new Parameter(P_STATISTICS_MODULO);
        this.statisticsModulo = this.parameters.getInt(p, null, 1);
        if (this.statisticsModulo == 0) {
            this.output.fatal("The statistics modulo must be an integer > 0.", p);
        }
        p = new Parameter(P_EXCHANGE_MODULO);
        this.exchangeModulo = this.parameters.getInt(p, null, 1);
        if (this.exchangeModulo == 0) {
            this.output.fatal("The exchange modulo must be an integer > 0.", p);
        }
        if (this.statisticsModulo > this.exchangeModulo || this.exchangeModulo % this.statisticsModulo != 0) {
            this.output.fatal("The exchange modulo should to be a multiple of the statistics modulo.", p);
        }
        p = new Parameter(P_EXCHANGE_MODULO);
        if (this.statisticsModulo > this.checkpointModulo || this.checkpointModulo % this.statisticsModulo != 0) {
            this.output.fatal("The checkpoint modulo should to be a multiple of the statistics modulo.", p);
        }
    }

    @Override
    public void startFresh() {
        this.output.message("Setting up");
        this.setup(this, null);
        this.output.message("Initializing Generation 0");
        this.statistics.preInitializationStatistics(this);
        this.population = this.initializer.initialPopulation(this, 0);
        this.statistics.postInitializationStatistics(this);
        if (this.numEvaluations > 0L) {
            int generationSize = 0;
            for (int sub = 0; sub < this.population.subpops.size(); ++sub) {
                generationSize += this.population.subpops.get((int)sub).individuals.size();
            }
            if (this.numEvaluations < (long)generationSize) {
                this.numEvaluations = generationSize;
                this.numGenerations = 1;
                this.output.warning("Using evaluations, but evaluations is less than the initial total population size (" + generationSize + ").  Setting to the populatiion size.");
            } else {
                if (this.numEvaluations % (long)generationSize != 0L) {
                    this.output.warning("Using evaluations, but initial total population size does not divide evenly into it.  Modifying evaluations to a smaller value (" + this.numEvaluations / (long)generationSize * (long)generationSize + ") which divides evenly.");
                }
                this.numGenerations = (int)(this.numEvaluations / (long)generationSize);
                this.numEvaluations = this.numGenerations * generationSize;
            }
            this.output.message("Generations will be " + this.numGenerations);
        }
        this.exchanger.initializeContacts(this);
        this.evaluator.initializeContacts(this);
    }

    @Override
    public int evolve() {
        String runCompleteMessage;
        boolean isStatisticsBorder;
        boolean isExchangeBorder = false;
        boolean bl = isStatisticsBorder = this.generation % this.statisticsModulo == 0;
        if (isStatisticsBorder) {
            boolean bl2 = isExchangeBorder = this.generation % this.exchangeModulo == 0;
        }
        if (isStatisticsBorder) {
            this.output.message("Generation " + this.generation + "\tEvaluations So Far " + this.evaluations);
        }
        if (isStatisticsBorder) {
            this.statistics.preEvaluationStatistics(this);
        }
        this.evaluator.evaluatePopulation(this);
        if (isStatisticsBorder) {
            this.statistics.postEvaluationStatistics(this);
        }
        if ((runCompleteMessage = this.evaluator.runComplete(this)) != null && this.quitOnRunComplete) {
            this.output.message(runCompleteMessage);
            return 0;
        }
        if (this.numGenerations != 0 && this.generation >= this.numGenerations - 1 || this.numEvaluations != 0L && (long)this.evaluations >= this.numEvaluations) {
            return 1;
        }
        ++this.generation;
        if (isExchangeBorder) {
            this.statistics.prePreBreedingExchangeStatistics(this);
            this.population = this.exchanger.preBreedingExchangePopulation(this);
            this.statistics.postPreBreedingExchangeStatistics(this);
            String exchangerWantsToShutdown = this.exchanger.runComplete(this);
            if (exchangerWantsToShutdown != null) {
                this.output.message(exchangerWantsToShutdown);
                return 0;
            }
        }
        if (isStatisticsBorder) {
            this.statistics.preBreedingStatistics(this);
        }
        this.population = this.breeder.breedPopulation(this);
        if (isStatisticsBorder) {
            this.statistics.postBreedingStatistics(this);
        }
        if (isExchangeBorder) {
            this.statistics.prePostBreedingExchangeStatistics(this);
            this.population = this.exchanger.postBreedingExchangePopulation(this);
            this.statistics.postPostBreedingExchangeStatistics(this);
        }
        if (isStatisticsBorder && this.checkpoint && (this.generation - 1) % this.checkpointModulo == 0) {
            this.output.message("Checkpointing");
            this.statistics.preCheckpointStatistics(this);
            Checkpoint.setCheckpoint(this);
            this.statistics.postCheckpointStatistics(this);
        }
        return 2;
    }

    @Override
    public void finish(int result) {
        this.output.message("Total Evaluations " + this.evaluations);
        this.statistics.finalStatistics(this, result);
        this.finisher.finishPopulation(this, result);
        this.exchanger.closeContacts(this, result);
        this.evaluator.closeContacts(this, result);
    }
}

