/*
 * Decompiled with CFR 0.152.
 */
package ec.spatial;

import ec.EvolutionState;
import ec.Subpopulation;
import ec.spatial.Space;
import ec.util.Parameter;

public class Spatial1DSubpopulation
extends Subpopulation
implements Space {
    private static final long serialVersionUID = 1L;
    public static final String P_TOROIDAL = "toroidal";
    public boolean toroidal;
    int[] indexes;

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        this.toroidal = state.parameters.getBoolean(base.push(P_TOROIDAL), null, true);
    }

    @Override
    public void setIndex(int threadnum, int index) {
        if (this.indexes == null) {
            this.indexes = new int[threadnum + 1];
        }
        if (threadnum >= this.indexes.length) {
            int currentSize = this.indexes.length;
            int[] temp = new int[threadnum * 2 + 1];
            System.arraycopy(this.indexes, 0, temp, 0, currentSize);
            this.indexes = temp;
        }
        this.indexes[threadnum] = index;
    }

    @Override
    public int getIndex(int threadnum) {
        if (this.indexes == null || threadnum > this.indexes.length) {
            return -1;
        }
        return this.indexes[threadnum];
    }

    @Override
    public int getIndexRandomNeighbor(EvolutionState state, int threadnum, int distance) {
        int index = this.indexes[threadnum];
        int size = this.individuals.size();
        if (size == 0) {
            return index;
        }
        if (this.toroidal) {
            int max = 2 * distance + 1 > size ? size : 2 * distance + 1;
            int rand = state.random[threadnum].nextInt(max);
            int val = index + rand - distance;
            if (val >= 0 && val < size) {
                return val;
            }
            if ((val %= size) >= 0) {
                return val;
            }
            return val + size;
        }
        int min = index - distance < 0 ? 0 : index - distance;
        int max = index + distance >= size ? size : index + distance;
        int val = min + state.random[threadnum].nextInt(max - min + 1);
        return val;
    }
}

