/*
 * Decompiled with CFR 0.152.
 */
package ec.steadystate;

import ec.EvolutionState;
import ec.Individual;
import ec.Statistics;
import ec.steadystate.SteadyStateBreeder;
import ec.steadystate.SteadyStateDefaults;
import ec.steadystate.SteadyStateEvaluator;
import ec.steadystate.SteadyStateExchangerForm;
import ec.steadystate.SteadyStateStatisticsForm;
import ec.util.Checkpoint;
import ec.util.Parameter;
import java.util.HashMap;

public class SteadyStateEvolutionState
extends EvolutionState {
    private static final long serialVersionUID = 1L;
    public static final String P_REPLACEMENT_PROBABILITY = "replacement-probability";
    public static final String P_EMPTY_AT_GEN = "empty-at-generation-boundary";
    public boolean generationBoundary;
    public int generationSize;
    public double replacementProbability;
    public boolean emptyAtGenerationBoundary;
    HashMap[] individualHash;
    int whichSubpop;
    protected boolean firstTime;

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        if (!(this.breeder instanceof SteadyStateBreeder)) {
            state.output.error("You've chosen to use Steady-State Evolution, but your breeder is not of the class SteadyStateBreeder.", base);
        }
        if (!(this.evaluator instanceof SteadyStateEvaluator)) {
            state.output.error("You've chosen to use Steady-State Evolution, but your evaluator is not of the class SteadyStateEvaluator.", base);
        }
        if (!(this.exchanger instanceof SteadyStateExchangerForm)) {
            state.output.error("You've chosen to use Steady-State Evolution, but your exchanger does not implement the SteadyStateExchangerForm.", base);
        }
        this.checkStatistics(state, this.statistics, new Parameter("stat"));
        this.emptyAtGenerationBoundary = this.parameters.getBoolean(SteadyStateDefaults.base().push(P_EMPTY_AT_GEN), null, false);
        if (this.parameters.exists(SteadyStateDefaults.base().push(P_REPLACEMENT_PROBABILITY), null)) {
            this.replacementProbability = this.parameters.getDoubleWithMax(SteadyStateDefaults.base().push(P_REPLACEMENT_PROBABILITY), null, 0.0, 1.0);
            if (this.replacementProbability < 0.0) {
                state.output.error("Replacement probability must be between 0.0 and 1.0 inclusive.", SteadyStateDefaults.base().push(P_REPLACEMENT_PROBABILITY), null);
            }
        } else {
            this.replacementProbability = 1.0;
            state.output.message("Replacement probability not defined: using 1.0 (always replace)");
        }
    }

    void checkStatistics(EvolutionState state, Statistics stat, Parameter base) {
        if (!(stat instanceof SteadyStateStatisticsForm)) {
            state.output.warning("You've chosen to use Steady-State Evolution, but your statistics does not implement the SteadyStateStatisticsForm.", base);
        }
        for (int x = 0; x < stat.children.length; ++x) {
            if (stat.children[x] == null) continue;
            this.checkStatistics(state, stat.children[x], base.push("child").push("" + x));
        }
    }

    @Override
    public void startFresh() {
        this.output.message("Setting up");
        this.setup(this, null);
        this.output.message("Initializing Generation 0");
        this.statistics.preInitializationStatistics(this);
        this.population = this.initializer.setupPopulation(this, 0);
        this.generationSize = 0;
        this.generationBoundary = false;
        this.firstTime = true;
        this.evaluations = 0;
        this.whichSubpop = -1;
        this.individualHash = new HashMap[this.population.subpops.size()];
        for (int i = 0; i < this.population.subpops.size(); ++i) {
            this.individualHash[i] = new HashMap();
        }
        for (int sub = 0; sub < this.population.subpops.size(); ++sub) {
            this.generationSize += this.population.subpops.get((int)sub).initialSize;
        }
        if (this.numEvaluations > 0L && this.numEvaluations < (long)this.generationSize) {
            this.output.fatal("Number of evaluations desired is smaller than the initial population of individuals");
        }
        this.exchanger.initializeContacts(this);
        this.evaluator.initializeContacts(this);
    }

    @Override
    public int evolve() {
        Individual ind;
        boolean partiallyFullSubpop;
        if (this.generationBoundary && this.generation > 0) {
            this.output.message("Generation " + this.generation + "\tEvaluations So Far " + this.evaluations);
            this.statistics.generationBoundaryStatistics(this);
        }
        if (this.firstTime) {
            if (this.statistics instanceof SteadyStateStatisticsForm) {
                ((SteadyStateStatisticsForm)((Object)this.statistics)).enteringInitialPopulationStatistics(this);
            }
            this.statistics.postInitializationStatistics(this);
            ((SteadyStateBreeder)this.breeder).prepareToBreed(this, 0);
            ((SteadyStateEvaluator)this.evaluator).prepareToEvaluate(this, 0);
            this.firstTime = false;
        }
        this.whichSubpop = (this.whichSubpop + 1) % this.population.subpops.size();
        boolean bl = partiallyFullSubpop = this.population.subpops.get((int)this.whichSubpop).individuals.size() < this.population.subpops.get((int)this.whichSubpop).initialSize;
        if (((SteadyStateEvaluator)this.evaluator).canEvaluate()) {
            ind = null;
            int numDuplicateRetries = this.population.subpops.get((int)this.whichSubpop).numDuplicateRetries;
            for (int tries = 0; tries <= numDuplicateRetries; ++tries) {
                Object o;
                if (partiallyFullSubpop) {
                    ind = this.population.subpops.get((int)this.whichSubpop).species.newIndividual((EvolutionState)this, 0);
                } else {
                    ind = ((SteadyStateBreeder)this.breeder).breedIndividual(this, this.whichSubpop, 0);
                    this.statistics.individualsBredStatistics(this, new Individual[]{ind});
                }
                if (numDuplicateRetries < 1 || (o = this.individualHash[this.whichSubpop].get(ind)) != null) continue;
                this.individualHash[this.whichSubpop].put(ind, ind);
                break;
            }
            ((SteadyStateEvaluator)this.evaluator).evaluateIndividual(this, ind, this.whichSubpop);
        }
        ind = ((SteadyStateEvaluator)this.evaluator).getNextEvaluatedIndividual(this);
        int whichIndIndex = -1;
        int whichSubpop = -1;
        if (ind != null) {
            int subpop;
            boolean bl2 = this.generationBoundary = this.evaluations % this.generationSize == 0;
            if (this.generationBoundary) {
                this.statistics.preEvaluationStatistics(this);
            }
            whichSubpop = subpop = ((SteadyStateEvaluator)this.evaluator).getSubpopulationOfEvaluatedIndividual();
            this.evaluator.postEvaluationLocalUpdate(this, ind, subpop);
            if (partiallyFullSubpop) {
                this.population.subpops.get((int)subpop).individuals.add(ind);
                if (this.population.subpops.get((int)subpop).individuals.size() == this.population.subpops.get((int)subpop).initialSize && this.statistics instanceof SteadyStateStatisticsForm) {
                    ((SteadyStateStatisticsForm)((Object)this.statistics)).enteringSteadyStateStatistics(subpop, this);
                }
            } else {
                int deadIndividualIndex = ((SteadyStateBreeder)this.breeder).deselectors[subpop].produce(subpop, this, 0);
                Individual deadInd = this.population.subpops.get((int)subpop).individuals.get(deadIndividualIndex);
                if (ind.fitness.betterThan(deadInd.fitness) || this.random[0].nextDouble() < this.replacementProbability) {
                    this.population.subpops.get((int)subpop).individuals.set(deadIndividualIndex, ind);
                    whichIndIndex = deadIndividualIndex;
                }
                this.individualHash[subpop].remove(deadInd);
                if (this.statistics instanceof SteadyStateStatisticsForm) {
                    ((SteadyStateStatisticsForm)((Object)this.statistics)).individualsEvaluatedStatistics(this, new Individual[]{ind}, new Individual[]{deadInd}, new int[]{subpop}, new int[]{deadIndividualIndex});
                }
            }
            if (this.generationBoundary) {
                this.statistics.postEvaluationStatistics(this);
            }
        } else {
            this.generationBoundary = false;
        }
        if (!partiallyFullSubpop && ind != null && ((SteadyStateEvaluator)this.evaluator).isIdealFitness(this, ind) && this.quitOnRunComplete) {
            this.output.message("Individual " + whichIndIndex + " of subpopulation " + whichSubpop + " has an ideal fitness.");
            this.finishEvaluationStatistics();
            return 0;
        }
        if (this.evaluator.runComplete != null) {
            this.output.message(this.evaluator.runComplete);
            this.finishEvaluationStatistics();
            return 0;
        }
        if (this.generationBoundary && this.numGenerations != 0 && this.generation >= this.numGenerations - 1 || this.numEvaluations != 0L && (long)this.evaluations >= this.numEvaluations) {
            this.finishEvaluationStatistics();
            return 1;
        }
        if (this.generationBoundary) {
            ++this.generation;
            this.statistics.prePreBreedingExchangeStatistics(this);
            this.population = this.exchanger.preBreedingExchangePopulation(this);
            this.statistics.postPreBreedingExchangeStatistics(this);
            String exchangerWantsToShutdown = this.exchanger.runComplete(this);
            if (exchangerWantsToShutdown != null) {
                this.output.message(exchangerWantsToShutdown);
                this.finishEvaluationStatistics();
                return 0;
            }
            this.evaluator.postEvaluationGlobalUpdate(this);
            this.statistics.prePostBreedingExchangeStatistics(this);
            this.population = this.exchanger.postBreedingExchangePopulation(this);
            this.statistics.postPostBreedingExchangeStatistics(this);
            this.population = this.population.emptyClone();
        }
        if (this.checkpoint && this.generationBoundary && (this.generation - 1) % this.checkpointModulo == 0) {
            this.output.message("Checkpointing");
            this.statistics.preCheckpointStatistics(this);
            Checkpoint.setCheckpoint(this);
            this.statistics.postCheckpointStatistics(this);
        }
        return 2;
    }

    public void finishEvaluationStatistics() {
        boolean generationBoundary;
        boolean bl = generationBoundary = this.evaluations % this.generationSize == 0;
        if (!generationBoundary) {
            this.statistics.postEvaluationStatistics(this);
            this.output.message("Generation " + this.generation + " Was Partial");
        }
    }

    @Override
    public void finish(int result) {
        this.output.message("Total Evaluations " + this.evaluations);
        ((SteadyStateBreeder)this.breeder).finishPipelines(this);
        this.statistics.finalStatistics(this, result);
        this.finisher.finishPopulation(this, result);
        this.exchanger.closeContacts(this, result);
        this.evaluator.closeContacts(this, result);
    }
}

