/*
 * Decompiled with CFR 0.152.
 */
package ec.util;

import ec.util.Indexed;
import ec.util.MersenneTwisterFast;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

public class IntBag
implements Serializable,
Cloneable,
Indexed {
    private static final long serialVersionUID = 1L;
    public int[] objs;
    public int numObjs;

    public IntBag(int capacity) {
        this.numObjs = 0;
        this.objs = new int[capacity];
    }

    public IntBag() {
        this.numObjs = 0;
        this.objs = new int[1];
    }

    public IntBag(IntBag other) {
        if (other == null) {
            this.numObjs = 0;
            this.objs = new int[1];
        } else {
            this.numObjs = other.numObjs;
            this.objs = new int[this.numObjs];
            System.arraycopy(other.objs, 0, this.objs, 0, this.numObjs);
        }
    }

    public IntBag(int[] other) {
        this();
        if (other != null) {
            this.addAll(other);
        }
    }

    @Override
    public int size() {
        return this.numObjs;
    }

    public boolean isEmpty() {
        return this.numObjs <= 0;
    }

    public boolean addAll(int[] other) {
        return this.addAll(this.numObjs, other);
    }

    public boolean addAll(int index, int[] other) {
        if (index > this.numObjs) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (other.length == 0) {
            return false;
        }
        if (this.numObjs + other.length > this.objs.length) {
            this.resize(this.numObjs + other.length);
        }
        if (index != this.numObjs) {
            System.arraycopy(this.objs, index, this.objs, index + other.length, this.numObjs - index);
        }
        System.arraycopy(other, 0, this.objs, index, other.length);
        this.numObjs += other.length;
        return true;
    }

    public boolean addAll(IntBag other) {
        return this.addAll(this.numObjs, other);
    }

    public boolean addAll(int index, IntBag other) {
        if (index > this.numObjs) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (other.numObjs <= 0) {
            return false;
        }
        if (this.numObjs + other.numObjs > this.objs.length) {
            this.resize(this.numObjs + other.numObjs);
        }
        if (index != this.numObjs) {
            System.arraycopy(this.objs, index, this.objs, index + other.size(), this.numObjs - index);
        }
        System.arraycopy(other.objs, 0, this.objs, index, other.numObjs);
        this.numObjs += other.numObjs;
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        IntBag b = (IntBag)super.clone();
        b.objs = (int[])this.objs.clone();
        return b;
    }

    public void resize(int toAtLeast) {
        if (this.objs.length >= toAtLeast) {
            return;
        }
        if (this.objs.length * 2 > toAtLeast) {
            toAtLeast = this.objs.length * 2;
        }
        int[] newobjs = new int[toAtLeast];
        System.arraycopy(this.objs, 0, newobjs, 0, this.numObjs);
        this.objs = newobjs;
    }

    public void shrink(int desiredLength) {
        if (desiredLength < this.numObjs) {
            desiredLength = this.numObjs;
        }
        if (desiredLength >= this.objs.length) {
            return;
        }
        int[] newobjs = new int[desiredLength];
        System.arraycopy(this.objs, 0, newobjs, 0, this.numObjs);
        this.objs = newobjs;
    }

    public int top() {
        if (this.numObjs <= 0) {
            return 0;
        }
        return this.objs[this.numObjs - 1];
    }

    public int pop() {
        int numObjs = this.numObjs;
        if (numObjs <= 0) {
            return 0;
        }
        int ret = this.objs[--numObjs];
        this.numObjs = numObjs;
        return ret;
    }

    public boolean push(int obj) {
        if (this.numObjs >= this.objs.length) {
            this.doubleCapacityPlusOne();
        }
        this.objs[this.numObjs++] = obj;
        return true;
    }

    public boolean add(int obj) {
        if (this.numObjs >= this.objs.length) {
            this.doubleCapacityPlusOne();
        }
        this.objs[this.numObjs++] = obj;
        return true;
    }

    void doubleCapacityPlusOne() {
        int[] newobjs = new int[this.numObjs * 2 + 1];
        System.arraycopy(this.objs, 0, newobjs, 0, this.numObjs);
        this.objs = newobjs;
    }

    public boolean contains(int o) {
        int numObjs = this.numObjs;
        int[] objs = this.objs;
        for (int x = 0; x < numObjs; ++x) {
            if (o != objs[x]) continue;
            return true;
        }
        return false;
    }

    public int get(int index) {
        if (index >= this.numObjs) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.objs[index];
    }

    @Override
    public Object getValue(int index) {
        return this.get(index);
    }

    public int set(int index, int element) {
        if (index >= this.numObjs) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int returnval = this.objs[index];
        this.objs[index] = element;
        return returnval;
    }

    @Override
    public Object setValue(int index, Object value) {
        Integer old = this.get(index);
        Integer newval = null;
        try {
            newval = (Integer)value;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Expected an Integer");
        }
        this.set(index, newval);
        return old;
    }

    public int removeNondestructively(int index) {
        if (index >= this.numObjs) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int ret = this.objs[index];
        if (index < this.numObjs - 1) {
            System.arraycopy(this.objs, index + 1, this.objs, index, this.numObjs - index - 1);
        }
        --this.numObjs;
        return ret;
    }

    public int remove(int index) {
        int _numObjs;
        if (index >= (_numObjs = this.numObjs--)) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int[] _objs = this.objs;
        int ret = _objs[index];
        _objs[index] = _objs[_numObjs - 1];
        return ret;
    }

    public void sort() {
        Arrays.sort(this.objs, 0, this.numObjs);
    }

    public void fill(int o) {
        int[] objs = this.objs;
        int numObjs = this.numObjs;
        for (int x = 0; x < numObjs; ++x) {
            objs[x] = o;
        }
    }

    public void shuffle(Random random) {
        int[] objs = this.objs;
        int numObjs = this.numObjs;
        for (int x = numObjs - 1; x >= 1; --x) {
            int rand = random.nextInt(x + 1);
            int obj = objs[x];
            objs[x] = objs[rand];
            objs[rand] = obj;
        }
    }

    public void shuffle(MersenneTwisterFast random) {
        int[] objs = this.objs;
        int numObjs = this.numObjs;
        for (int x = numObjs - 1; x >= 1; --x) {
            int rand = random.nextInt(x + 1);
            int obj = objs[x];
            objs[x] = objs[rand];
            objs[rand] = obj;
        }
    }

    public void reverse() {
        int[] objs = this.objs;
        int numObjs = this.numObjs;
        int l = numObjs / 2;
        for (int x = 0; x < l; ++x) {
            int obj = objs[x];
            objs[x] = objs[numObjs - x - 1];
            objs[numObjs - x - 1] = obj;
        }
    }

    public void clear() {
        this.numObjs = 0;
    }

    public void copyIntoArray(int fromStart, int[] to, int toStart, int len) {
        System.arraycopy(this.objs, fromStart, to, toStart, len);
    }

    public int[] toArray() {
        int[] o = new int[this.numObjs];
        System.arraycopy(this.objs, 0, o, 0, this.numObjs);
        return o;
    }

    public Integer[] toIntegerArray() {
        Integer[] o = new Integer[this.numObjs];
        for (int i = 0; i < this.numObjs; ++i) {
            o[i] = this.objs[i];
        }
        return o;
    }

    public Long[] toLongArray() {
        Long[] o = new Long[this.numObjs];
        for (int i = 0; i < this.numObjs; ++i) {
            o[i] = this.objs[i];
        }
        return o;
    }

    public Double[] toDoubleArray() {
        Double[] o = new Double[this.numObjs];
        for (int i = 0; i < this.numObjs; ++i) {
            o[i] = this.objs[i];
        }
        return o;
    }

    @Override
    public Class componentType() {
        return Integer.TYPE;
    }
}

