/*
 * Decompiled with CFR 0.152.
 */
package ec.util;

import ec.util.LogRestarter;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;

public class Log
implements Serializable {
    private static final long serialVersionUID = 1L;
    public boolean silent = false;
    public transient PrintWriter writer;
    public File filename;
    public boolean postAnnouncements;
    public LogRestarter restarter;
    public boolean repostAnnouncementsOnRestart;
    public boolean appendOnRestart;
    public boolean isLoggingToSystemOut;
    public static final int D_STDOUT = 0;
    public static final int D_STDERR = 1;

    public Log(File _filename, boolean _postAnnouncements, boolean _appendOnRestart) throws IOException {
        this(_filename, _postAnnouncements, _appendOnRestart, false);
    }

    public Log(File _filename, boolean _postAnnouncements, boolean _appendOnRestart, boolean gzip) throws IOException {
        this.postAnnouncements = _postAnnouncements;
        this.repostAnnouncementsOnRestart = !_appendOnRestart;
        this.appendOnRestart = _appendOnRestart;
        this.isLoggingToSystemOut = false;
        if (gzip) {
            this.filename = new File(_filename.getAbsolutePath() + ".gz");
            if (this.appendOnRestart) {
                throw new IOException("Cannot gzip and appendOnRestart at the same time: new Log(File,int,boolean,boolean,boolean)");
            }
            this.writer = new PrintWriter(new OutputStreamWriter(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(this.filename)))));
            this.restarter = new LogRestarter(){

                @Override
                public Log restart(Log l) throws IOException {
                    return this.reopen(l);
                }

                @Override
                public Log reopen(Log l) throws IOException {
                    if (l.writer != null && !l.isLoggingToSystemOut) {
                        l.writer.close();
                    }
                    l.writer = new PrintWriter(new OutputStreamWriter(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(l.filename)))));
                    return l;
                }
            };
        } else {
            this.filename = _filename;
            this.writer = new PrintWriter(new BufferedWriter(new FileWriter(this.filename)));
            this.restarter = new LogRestarter(){

                @Override
                public Log restart(Log l) throws IOException {
                    l.writer = new PrintWriter(new BufferedWriter(new FileWriter(l.filename.getPath(), l.appendOnRestart)));
                    return l;
                }

                @Override
                public Log reopen(Log l) throws IOException {
                    if (l.writer != null && !Log.this.isLoggingToSystemOut) {
                        l.writer.close();
                    }
                    l.writer = new PrintWriter(new BufferedWriter(new FileWriter(l.filename)));
                    return l;
                }
            };
        }
    }

    public Log(int descriptor, boolean _postAnnouncements) {
        this.filename = null;
        this.postAnnouncements = _postAnnouncements;
        this.repostAnnouncementsOnRestart = true;
        this.appendOnRestart = true;
        this.isLoggingToSystemOut = true;
        if (descriptor == 0) {
            this.writer = new PrintWriter(System.out);
            this.restarter = new LogRestarter(){

                @Override
                public Log restart(Log l) throws IOException {
                    l.writer = new PrintWriter(System.out);
                    return l;
                }

                @Override
                public Log reopen(Log l) throws IOException {
                    return l;
                }
            };
        } else {
            this.writer = new PrintWriter(System.err);
            this.restarter = new LogRestarter(){

                @Override
                public Log restart(Log l) throws IOException {
                    l.writer = new PrintWriter(System.err);
                    return l;
                }

                @Override
                public Log reopen(Log l) throws IOException {
                    return l;
                }
            };
        }
    }

    public Log(Writer _writer, LogRestarter _restarter, boolean _postAnnouncements, boolean _repostAnnouncementsOnRestart) {
        this.filename = null;
        this.postAnnouncements = _postAnnouncements;
        this.repostAnnouncementsOnRestart = _repostAnnouncementsOnRestart;
        this.appendOnRestart = true;
        this.isLoggingToSystemOut = false;
        this.writer = new PrintWriter(new BufferedWriter(_writer));
        this.restarter = _restarter;
    }

    public Log restart() throws IOException {
        return this.restarter.restart(this);
    }

    public Log reopen() throws IOException {
        return this.restarter.reopen(this);
    }
}

