/*
 * Decompiled with CFR 0.152.
 */
package ec.util;

import ec.util.Log;
import ec.util.LogRestarter;
import ec.util.OutputException;
import ec.util.Parameter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;

public class Output
implements Serializable {
    private static final long serialVersionUID = 1L;
    boolean errors = false;
    Vector logs = new Vector();
    Vector announcements = new Vector();
    boolean store = true;
    String filePrefix = "";
    boolean throwsErrors = false;
    public static final int V_VERBOSE = 0;
    public static final int V_NO_MESSAGES = 1000;
    public static final int V_NO_WARNINGS = 2000;
    public static final int V_NO_GENERAL = 3000;
    public static final int V_NO_ERRORS = 4000;
    public static final int V_TOTALLY_SILENT = 5000;
    public static final int ALL_MESSAGE_LOGS = -1;
    public static final int NO_LOGS = -2;
    StringBuilder error = new StringBuilder();
    HashSet oneTimeWarnings = new HashSet();

    public synchronized void setFilePrefix(String filePrefix) {
        this.filePrefix = filePrefix;
    }

    public synchronized void setThrowsErrors(boolean val) {
        this.throwsErrors = val;
    }

    public synchronized boolean getThrowsErrors() {
        return this.throwsErrors;
    }

    private static void exitWithError(Output output, String message, boolean throwException) {
        if (output != null) {
            output.close();
        }
        System.out.flush();
        System.err.flush();
        if (throwException) {
            throw new OutputExitException(message);
        }
        System.exit(1);
    }

    public synchronized void close() {
        this.flush();
        Enumeration e = this.logs.elements();
        while (e.hasMoreElements()) {
            Log log = (Log)e.nextElement();
            if (log.isLoggingToSystemOut) continue;
            log.writer.close();
        }
    }

    public synchronized void flush() {
        Enumeration e = this.logs.elements();
        while (e.hasMoreElements()) {
            Log log = (Log)e.nextElement();
            log.writer.flush();
        }
        System.out.flush();
        System.err.flush();
    }

    public Output(boolean storeAnnouncementsInMemory, int _verbosity) {
        this(storeAnnouncementsInMemory);
    }

    public Output(boolean storeAnnouncementsInMemory) {
        this.store = storeAnnouncementsInMemory;
    }

    public synchronized void setFlush(boolean v) {
    }

    public synchronized boolean getFlush() {
        return true;
    }

    public synchronized void setStore(boolean v) {
        this.store = v;
    }

    public synchronized boolean getStore() {
        return this.store;
    }

    public synchronized void setVerbosity(int v) {
    }

    public synchronized int getVerbosity() {
        return 0;
    }

    public synchronized int addLog(File file, int _verbosity, boolean postAnnouncements, boolean appendOnRestart, boolean gzip) throws IOException {
        if (this.filePrefix != null && this.filePrefix.length() > 0) {
            file = new File(file.getParent(), this.filePrefix + file.getName());
        }
        this.logs.addElement(new Log(file, postAnnouncements, appendOnRestart, gzip));
        return this.logs.size() - 1;
    }

    public synchronized int addLog(File file, int _verbosity, boolean postAnnouncements, boolean appendOnRestart) throws IOException {
        return this.addLog(file, postAnnouncements, appendOnRestart, false);
    }

    public synchronized int addLog(File file, boolean postAnnouncements, boolean appendOnRestart, boolean gzip) throws IOException {
        return this.addLog(file, 0, postAnnouncements, appendOnRestart, gzip);
    }

    public synchronized int addLog(File file, boolean appendOnRestart, boolean gzip) throws IOException {
        return this.addLog(file, false, appendOnRestart, gzip);
    }

    public synchronized int addLog(File file, boolean appendOnRestart) throws IOException {
        return this.addLog(file, false, appendOnRestart, false);
    }

    public synchronized int addLog(int descriptor, int _verbosity, boolean postAnnouncements) {
        this.logs.addElement(new Log(descriptor, postAnnouncements));
        return this.logs.size() - 1;
    }

    public synchronized int addLog(int descriptor, boolean postAnnouncements) {
        return this.addLog(descriptor, 0, postAnnouncements);
    }

    public synchronized int addLog(Writer writer, LogRestarter restarter, int _verbosity, boolean postAnnouncements, boolean repostAnnouncements) {
        this.logs.addElement(new Log(writer, restarter, postAnnouncements, repostAnnouncements));
        return this.logs.size() - 1;
    }

    public synchronized int addLog(Writer writer, LogRestarter restarter, boolean postAnnouncements, boolean repostAnnouncements) {
        this.logs.addElement(new Log(writer, restarter, postAnnouncements, repostAnnouncements));
        return this.logs.size() - 1;
    }

    public synchronized int addLog(Log l) {
        this.logs.addElement(l);
        return this.logs.size() - 1;
    }

    public synchronized int numLogs() {
        return this.logs.size();
    }

    public synchronized Log getLog(int x) {
        return (Log)this.logs.elementAt(x);
    }

    public synchronized Log removeLog(int x) {
        Log l = this.getLog(x);
        this.logs.removeElementAt(x);
        return l;
    }

    public static void initialWarning(String s) {
        Output.initialWarning(s, null, null);
    }

    public static void initialWarning(String s, Parameter p1) {
        Output.initialWarning(s, p1, null);
    }

    public static void initialWarning(String s, Parameter p1, Parameter p2) {
        System.err.println("STARTUP WARNING:\n" + s);
        if (p1 != null) {
            System.err.println("PARAMETER: " + String.valueOf(p1));
        }
        if (p2 != null && p1 != null) {
            System.err.println("     ALSO: " + String.valueOf(p2));
        }
    }

    public static void initialError(String s, boolean throwsErrors) {
        String er = "STARTUP ERROR:\n" + s;
        System.err.println(er);
        Output.exitWithError(null, er, throwsErrors);
    }

    public static void initialError(String s, Parameter p1, boolean throwsErrors) {
        String er = "STARTUP ERROR:\n" + s;
        System.err.println(er);
        if (p1 != null) {
            er = er + "PARAMETER: " + String.valueOf(p1);
            System.err.println("PARAMETER: " + String.valueOf(p1));
        }
        Output.exitWithError(null, er, throwsErrors);
    }

    public static void initialError(String s, Parameter p1, Parameter p2, boolean throwsErrors) {
        String er = "STARTUP ERROR:\n" + s;
        System.err.println(er);
        if (p1 != null) {
            er = er + "PARAMETER: " + String.valueOf(p1);
            System.err.println("PARAMETER: " + String.valueOf(p1));
        }
        if (p2 != null && p1 != null) {
            er = er + "     ALSO: " + String.valueOf(p2);
            System.err.println("     ALSO: " + String.valueOf(p2));
        }
        Output.exitWithError(null, er, throwsErrors);
    }

    public static void initialMessage(String s) {
        System.err.println(s);
        System.err.flush();
    }

    public synchronized void systemMessage(String s) {
        this.println(s, 1000, -1, true);
    }

    String a(String str) {
        this.error.append(str);
        this.error.append("\n");
        return str;
    }

    public synchronized void fatal(String s) {
        StringBuilder error = new StringBuilder();
        this.println(this.a("FATAL ERROR:\n" + s), -1, true);
        Output.exitWithError(this, error.toString(), this.throwsErrors);
    }

    public synchronized void fatal(String s, Parameter p1) {
        this.println(this.a("FATAL ERROR:\n" + s), -1, true);
        if (p1 != null) {
            this.println(this.a("PARAMETER: " + String.valueOf(p1)), -1, true);
        }
        Output.exitWithError(this, this.error.toString(), this.throwsErrors);
    }

    public synchronized void fatal(String s, Parameter p1, Parameter p2) {
        this.println(this.a("FATAL ERROR:\n" + s), -1, true);
        if (p1 != null) {
            this.println(this.a("PARAMETER: " + String.valueOf(p1)), -1, true);
        }
        if (p2 != null && p1 != null) {
            this.println(this.a("     ALSO: " + String.valueOf(p2)), -1, true);
        } else {
            this.println(this.a("PARAMETER: " + String.valueOf(p2)), -1, true);
        }
        Output.exitWithError(this, this.error.toString(), this.throwsErrors);
    }

    public synchronized void error(String s) {
        this.println(this.a("ERROR:\n" + s), -1, true);
        this.errors = true;
    }

    public synchronized void error(String s, Parameter p1) {
        this.println(this.a("ERROR:\n" + s), -1, true);
        if (p1 != null) {
            this.println(this.a("PARAMETER: " + String.valueOf(p1)), -1, true);
        }
        this.errors = true;
    }

    public synchronized void error(String s, Parameter p1, Parameter p2) {
        this.println(this.a("ERROR:\n" + s), -1, true);
        if (p1 != null) {
            this.println(this.a("PARAMETER: " + String.valueOf(p1)), -1, true);
        }
        if (p2 != null && p1 != null) {
            this.println(this.a("     ALSO: " + String.valueOf(p2)), -1, true);
        } else {
            this.println(this.a("PARAMETER: " + String.valueOf(p2)), -1, true);
        }
        this.errors = true;
    }

    public synchronized void warning(String s, Parameter p1, Parameter p2) {
        this.println("WARNING:\n" + s, -1, true);
        if (p1 != null) {
            this.println("PARAMETER: " + String.valueOf(p1), -1, true);
        }
        if (p2 != null && p1 != null) {
            this.println("     ALSO: " + String.valueOf(p2), -1, true);
        } else {
            this.println("PARAMETER: " + String.valueOf(p2), -1, true);
        }
    }

    public synchronized void warning(String s, Parameter p1) {
        this.println("WARNING:\n" + s, -1, true);
        if (p1 != null) {
            this.println("PARAMETER: " + String.valueOf(p1), -1, true);
        }
    }

    public synchronized void warning(String s) {
        this.println("WARNING:\n" + s, -1, true);
    }

    public synchronized void warnOnce(String s) {
        if (!this.oneTimeWarnings.contains(s)) {
            this.oneTimeWarnings.add(s);
            this.println("ONCE-ONLY WARNING:\n" + s, -1, true);
        }
    }

    public synchronized void warnOnce(String s, Parameter p1) {
        if (!this.oneTimeWarnings.contains(s)) {
            this.oneTimeWarnings.add(s);
            this.println("ONCE-ONLY WARNING:\n" + s, -1, true);
            if (p1 != null) {
                this.println("PARAMETER: " + String.valueOf(p1), -1, true);
            }
        }
    }

    public synchronized void warnOnce(String s, Parameter p1, Parameter p2) {
        if (!this.oneTimeWarnings.contains(s)) {
            this.oneTimeWarnings.add(s);
            this.println("ONCE-ONLY WARNING:\n" + s, -1, true);
            if (p1 != null) {
                this.println("PARAMETER: " + String.valueOf(p1), -1, true);
            }
            if (p2 != null && p1 != null) {
                this.println("     ALSO: " + String.valueOf(p2), -1, true);
            } else {
                this.println("PARAMETER: " + String.valueOf(p2), -1, true);
            }
        }
    }

    public synchronized void message(String s) {
        this.println(s, -1, true);
    }

    public synchronized void reopen(int _log) throws IOException {
        Log oldlog = (Log)this.logs.elementAt(_log);
        this.logs.setElementAt(oldlog.reopen(), _log);
    }

    public synchronized void reopen(int[] _logs) throws IOException {
        for (int x = 0; x < _logs.length; ++x) {
            Log oldlog = (Log)this.logs.elementAt(_logs[x]);
            this.logs.setElementAt(oldlog.reopen(), _logs[x]);
        }
    }

    synchronized void println(String s, int _verbosity, Log log, boolean _announcement, boolean _reposting) throws OutputException {
        if (log == null) {
            return;
        }
        if (log.writer == null) {
            throw new OutputException("Log with a null writer: " + String.valueOf(log));
        }
        if (!log.postAnnouncements && _announcement) {
            return;
        }
        if (log.silent) {
            return;
        }
        log.writer.println(s);
        log.writer.flush();
        if (this.store && _announcement && !_reposting) {
            this.announcements.addElement(new Announcement(s));
        }
    }

    synchronized void println(String s, int _verbosity, int log, boolean _announcement) throws OutputException {
        if (log == -2) {
            return;
        }
        if (log == -1) {
            for (int x = 0; x < this.logs.size(); ++x) {
                Log l = (Log)this.logs.elementAt(x);
                if (l == null) {
                    throw new OutputException("Unknown log number" + String.valueOf(l));
                }
                this.println(s, _verbosity, l, _announcement, false);
            }
        } else {
            Log l = (Log)this.logs.elementAt(log);
            if (l == null) {
                throw new OutputException("Unknown log number" + log);
            }
            this.println(s, _verbosity, l, _announcement, false);
        }
    }

    public synchronized void println(String s, int log, boolean _announcement) throws OutputException {
        if (log == -2) {
            return;
        }
        this.println(s, 0, log, _announcement);
    }

    public synchronized void println(String s, int _verbosity, int[] _logs) throws OutputException {
        for (int x = 0; x < _logs.length && _logs[x] != -2; ++x) {
            this.println(s, 0, (Log)this.logs.elementAt(_logs[x]), false, false);
        }
    }

    public synchronized void println(String s, int _verbosity, int log) throws OutputException {
        if (log == -2) {
            return;
        }
        this.println(s, 0, (Log)this.logs.elementAt(log), false, false);
    }

    public synchronized void println(String s, int log) throws OutputException {
        if (log == -2) {
            return;
        }
        this.println(s, 0, log);
    }

    protected synchronized void print(String s, int _verbosity, Log log) throws OutputException {
        if (log == null) {
            return;
        }
        if (log.writer == null) {
            throw new OutputException("Log with a null writer: " + String.valueOf(log));
        }
        if (log.silent) {
            return;
        }
        log.writer.print(s);
    }

    public synchronized void print(String s, int _verbosity, int log) throws OutputException {
        if (log == -2) {
            return;
        }
        if (log == -1) {
            for (int x = 0; x < this.logs.size(); ++x) {
                Log l = (Log)this.logs.elementAt(x);
                if (l == null) {
                    throw new OutputException("Unknown log number" + String.valueOf(l));
                }
                this.print(s, 0, l);
            }
        } else {
            Log l = (Log)this.logs.elementAt(log);
            if (l == null) {
                throw new OutputException("Unknown log number" + log);
            }
            this.print(s, 0, l);
        }
    }

    public synchronized void print(String s, int log) throws OutputException {
        this.print(s, 0, log);
    }

    public synchronized void print(String s, int _verbosity, int[] _logs) throws OutputException {
        for (int x = 0; x < _logs.length; ++x) {
            if (_logs[x] == -2) {
                return;
            }
            this.print(s, _logs[x]);
        }
    }

    public synchronized void print(String s, int[] _logs) throws OutputException {
        this.print(s, 0, _logs);
    }

    public synchronized void exitIfErrors() {
        if (this.errors) {
            this.println(this.a("SYSTEM EXITING FROM ERRORS\n"), -1, true);
            Output.exitWithError(this, this.error.toString(), this.throwsErrors);
        }
    }

    public synchronized void clearErrors() {
        this.errors = false;
    }

    public synchronized void clearAnnouncements() {
        if (this.announcements != null) {
            this.announcements = new Vector();
        }
    }

    public synchronized void restart() throws IOException {
        int ls = this.logs.size();
        for (int x = 0; x < ls; ++x) {
            Log l = (Log)this.logs.elementAt(x);
            l = l.restarter.restart(l);
            this.logs.setElementAt(l, x);
            if (!l.repostAnnouncementsOnRestart || !this.store) continue;
            int as = this.announcements.size();
            for (int y = 0; y < as; ++y) {
                Announcement a = (Announcement)this.announcements.elementAt(y);
                this.println(a.text, 0, l, true, true);
            }
        }
        this.exitIfErrors();
    }

    public static InputStream makeCompressingInputStream(InputStream in) {
        try {
            return (InputStream)Class.forName("com.jcraft.jzlib.InflaterInputStream").getConstructor(InputStream.class).newInstance(in);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static OutputStream makeCompressingOutputStream(OutputStream out) {
        try {
            Class<?> outc = Class.forName("com.jcraft.jzlib.DeflaterOutputStream");
            Object outi = outc.getConstructor(OutputStream.class).newInstance(out);
            outc.getMethod("setSyncFlush", Boolean.TYPE).invoke(outi, true);
            return (OutputStream)outi;
        }
        catch (Exception e) {
            try {
                Class<?> outz = Class.forName("com.jcraft.jzlib.JZlib");
                int Z_BEST_SPEED = outz.getField("Z_BEST_SPEED").getInt(null);
                int Z_SYNC_FLUSH = outz.getField("Z_SYNC_FLUSH").getInt(null);
                Class<?> outc = Class.forName("com.jcraft.jzlib.ZOutputStream");
                Object outi = outc.getConstructor(OutputStream.class, Integer.TYPE).newInstance(out, Z_BEST_SPEED);
                outc.getMethod("setFlushMode", Integer.TYPE).invoke(outi, Z_SYNC_FLUSH);
                return (OutputStream)outi;
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    public static class OutputExitException
    extends RuntimeException {
        public OutputExitException(String message) {
            super(message);
        }
    }

    static class Announcement
    implements Serializable {
        public String text;

        public Announcement(String t) {
            this.text = t;
        }
    }
}

