/*
 * Decompiled with CFR 0.152.
 */
package ec.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ReflectedObject
implements TreeModel {
    Class type;
    Object obj;
    String name;
    Object uniq;
    static ReflectedObject unknown = new ReflectedObject(null){

        @Override
        public String toString() {
            return "<unknown>";
        }
    };

    public ReflectedObject(Object o) {
        this(o, o == null ? Object.class : o.getClass(), null, null);
    }

    protected ReflectedObject(Object o, Class t, String n, Object u) {
        this.obj = o;
        this.type = t;
        this.name = n;
        this.uniq = u;
    }

    public String toString() {
        String field = this.name == null ? "" : this.name + ": ";
        try {
            if (this.obj == null) {
                return field + "null";
            }
            if (this.type.isArray()) {
                return field + this.type.getName() + ", length=" + Array.getLength(this.obj);
            }
            return field + this.type.getName() + " " + this.obj.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return field + this.type.getName() + " <error>";
        }
    }

    public int getNumChildren() {
        return this.getNumFields() + this.getNumProperties();
    }

    public ReflectedObject getChild(int index) {
        int f = this.getNumFields();
        if (index < f) {
            return this.getField(index);
        }
        return this.getProperty(index - f);
    }

    public ReflectedObject[] getChildren() {
        ReflectedObject[] fields = this.getFields();
        ReflectedObject[] props = this.getProperties();
        ReflectedObject[] o = new ReflectedObject[fields.length + props.length];
        System.arraycopy(fields, 0, o, 0, fields.length);
        System.arraycopy(props, 0, o, fields.length, props.length);
        return o;
    }

    public int getNumFields() {
        try {
            if (this.obj == null || this.type.isPrimitive()) {
                return 0;
            }
            if (this.type.isArray()) {
                return Array.getLength(this.obj);
            }
            return this.type.getFields().length;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new RuntimeException("Unexpected Exception: " + String.valueOf(e));
        }
    }

    public ReflectedObject getField(int index) {
        try {
            if (this.obj == null || this.type.isPrimitive() || index < 0) {
                return null;
            }
            if (this.type.isArray()) {
                int len = Array.getLength(this.obj);
                if (index > len) {
                    return null;
                }
                return new ReflectedObject(Array.get(this.obj, index), this.type.getComponentType(), "" + index, "" + index);
            }
            Field[] f = this.type.getFields();
            int len = f.length;
            if (index > len) {
                return null;
            }
            return new ReflectedObject(f[index].get(this.obj), f[index].get(this.obj) == null || f[index].getType().isPrimitive() ? f[index].getType() : f[index].get(this.obj).getClass(), f[index].getName(), f[index]);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new RuntimeException("Unexpected Exception: " + String.valueOf(e));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RuntimeException("Unexpected Exception: " + String.valueOf(e));
        }
    }

    public ReflectedObject[] getFields() {
        try {
            if (this.obj == null || this.type.isPrimitive()) {
                return new ReflectedObject[0];
            }
            if (this.type.isArray()) {
                int len = Array.getLength(this.obj);
                ReflectedObject[] ref = new ReflectedObject[len];
                for (int x = 0; x < len; ++x) {
                    ref[x] = new ReflectedObject(Array.get(this.obj, x), this.type.getComponentType(), "" + x, "" + x);
                }
                return ref;
            }
            Field[] f = this.type.getFields();
            int len = f.length;
            ReflectedObject[] ref = new ReflectedObject[len];
            for (int x = 0; x < len; ++x) {
                ref[x] = new ReflectedObject(f[x].get(this.obj), f[x].get(this.obj) == null || f[x].getType().isPrimitive() ? f[x].getType() : f[x].get(this.obj).getClass(), f[x].getName(), f[x]);
            }
            return ref;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new RuntimeException("Unexpected Exception: " + String.valueOf(e));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RuntimeException("Unexpected Exception: " + String.valueOf(e));
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReflectedObject)) {
            return false;
        }
        if (this.uniq == null && ((ReflectedObject)obj).uniq == null) {
            return true;
        }
        if (this.uniq == null || ((ReflectedObject)obj).uniq == null) {
            return false;
        }
        return ((ReflectedObject)obj).uniq.equals(this.uniq);
    }

    @Override
    public Object getRoot() {
        return this;
    }

    @Override
    public Object getChild(Object parent, int index) {
        return ((ReflectedObject)parent).getChild(index);
    }

    @Override
    public int getChildCount(Object parent) {
        return ((ReflectedObject)parent).getNumChildren();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        ReflectedObject[] children = ((ReflectedObject)parent).getChildren();
        for (int x = 0; x < children.length; ++x) {
            if (!children[x].equals(child)) continue;
            return x;
        }
        throw new IndexOutOfBoundsException("No such child " + String.valueOf(child) + " in parent " + ((ReflectedObject)parent).toString());
    }

    @Override
    public boolean isLeaf(Object parent) {
        return this.getChildCount(parent) == 0;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
    }

    int getNumProperties() {
        if (this.obj == null) {
            return 0;
        }
        int count = 0;
        try {
            Class<?> c = this.obj.getClass();
            Method[] m = c.getMethods();
            for (int x = 0; x < m.length; ++x) {
                if (!m[x].getName().startsWith("get") && !m[x].getName().startsWith("is")) continue;
                int modifier = m[x].getModifiers();
                if (m[x].getParameterTypes().length != 0 || !Modifier.isPublic(modifier) || m[x].getReturnType() == Void.TYPE) continue;
                ++count;
            }
        }
        catch (Exception e) {
            count = 0;
            e.printStackTrace();
        }
        return count;
    }

    ReflectedObject getProperty(int index) {
        if (this.obj == null) {
            return null;
        }
        int count = 0;
        try {
            Class<?> c = this.obj.getClass();
            Method[] m = c.getMethods();
            for (int x = 0; x < m.length; ++x) {
                if (!m[x].getName().startsWith("get") && !m[x].getName().startsWith("is")) continue;
                int modifier = m[x].getModifiers();
                if (m[x].getParameterTypes().length != 0 || !Modifier.isPublic(modifier) || m[x].getReturnType() == Void.TYPE) continue;
                if (count == index) {
                    Object o = null;
                    try {
                        o = m[x].invoke(this.obj, new Object[0]);
                    }
                    catch (InvocationTargetException e) {
                        return unknown;
                    }
                    return new ReflectedObject(o, o == null || m[x].getReturnType().isPrimitive() ? m[x].getReturnType() : o.getClass(), "Property " + m[x].getName(), "Property " + m[x].getName());
                }
                ++count;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return unknown;
    }

    ReflectedObject[] getProperties() {
        if (this.obj == null) {
            return new ReflectedObject[0];
        }
        int len = this.getNumProperties();
        int count = 0;
        ReflectedObject[] refs = new ReflectedObject[len];
        try {
            Class<?> c = this.obj.getClass();
            Method[] m = c.getMethods();
            for (int x = 0; x < m.length; ++x) {
                if (!m[x].getName().startsWith("get") && !m[x].getName().startsWith("is")) continue;
                int modifier = m[x].getModifiers();
                if (m[x].getParameterTypes().length != 0 || !Modifier.isPublic(modifier) || m[x].getReturnType() == Void.TYPE) continue;
                Object o = null;
                try {
                    o = m[x].invoke(this.obj, new Object[0]);
                    refs[count] = new ReflectedObject(o, o == null || m[x].getReturnType().isPrimitive() ? m[x].getReturnType() : o.getClass(), "Property " + m[x].getName(), "Property " + m[x].getName());
                }
                catch (InvocationTargetException e) {
                    refs[count] = unknown;
                }
                ++count;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return refs;
    }
}

