/*
 * Decompiled with CFR 0.152.
 */
package ec.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.LinkedList;

public class ThreadPool
implements Serializable {
    private static final long serialVersionUID = 1L;
    LinkedList workers = new LinkedList();
    Object workersLock = new Object[0];
    int totalWorkers = 0;

    private void writeObject(ObjectOutputStream stream) throws IOException {
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.workers = new LinkedList();
        this.workersLock = new Object[0];
        this.totalWorkers = 0;
    }

    public Worker start(Runnable run) {
        return this.start(run, String.valueOf(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Worker start(Runnable run, String name) {
        Node node;
        Object object = this.workersLock;
        synchronized (object) {
            if (this.workers.isEmpty()) {
                node = new Node(name + " (" + this.totalWorkers + ")");
                node.thread.start();
                ++this.totalWorkers;
            } else {
                node = (Node)this.workers.remove();
            }
        }
        object = node;
        synchronized (object) {
            node.setRun(run);
            node.go = true;
            node.notify();
        }
        return node;
    }

    public Worker start(Runnable run, int maximumOutstandingWorkers) {
        return this.start(run, maximumOutstandingWorkers, String.valueOf(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Worker start(Runnable run, int maximumOutstandingWorkers, String name) {
        Object object = this.workersLock;
        synchronized (object) {
            while (this.getOutstandingWorkers() >= maximumOutstandingWorkers) {
                try {
                    this.workersLock.wait();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
            }
            return this.start(run, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalWorkers() {
        Object object = this.workersLock;
        synchronized (object) {
            return this.totalWorkers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPooledWorkers() {
        Object object = this.workersLock;
        synchronized (object) {
            return this.workers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOutstandingWorkers() {
        Object object = this.workersLock;
        synchronized (object) {
            return this.getTotalWorkers() - this.getPooledWorkers();
        }
    }

    public boolean join(Worker thread, Runnable run) {
        return ((Node)thread).joinRunnable(run);
    }

    public boolean join(Worker thread) {
        return ((Node)thread).joinRunnable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinAll() {
        Object object = this.workersLock;
        synchronized (object) {
            while (this.totalWorkers > this.workers.size()) {
                try {
                    this.workersLock.wait();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killPooled() {
        Object object = this.workersLock;
        synchronized (object) {
            while (!this.workers.isEmpty()) {
                Node node;
                Node node2 = node = (Node)this.workers.remove();
                synchronized (node2) {
                    node.die = true;
                    node.notify();
                }
                try {
                    node.thread.join();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
                --this.totalWorkers;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killAll() {
        Object object = this.workersLock;
        synchronized (object) {
            this.joinAll();
            this.killPooled();
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        p = new ThreadPool();
        runs = new Runnable[1000];
        workers = new Worker[1000];
        while (true) {
            for (x = 0; x < 1000; ++x) {
                runs[x] = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.currentThread();
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                };
                workers[x] = p.start(runs[x]);
            }
            y = 0;
            while (true) {
                if (y >= 1000) ** continue;
                System.err.println("joining " + y);
                p.join(workers[y], runs[y]);
                System.err.println("joined");
                ++y;
            }
            break;
        }
    }

    public static interface Worker {
        public void interrupt();
    }

    class Node
    implements Runnable,
    Worker {
        private static final long serialVersionUID = 1L;
        boolean die = false;
        boolean go = false;
        Thread thread;
        Runnable toRun = null;
        Object runLock = new Object[0];

        Node(String name) {
            this.thread = new Thread(this);
            this.thread.setDaemon(true);
            this.thread.setName(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void interrupt() {
            Object object = this.runLock;
            synchronized (object) {
                if (this.toRun != null) {
                    this.thread.interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setRun(Runnable r) {
            Object object = this.runLock;
            synchronized (object) {
                this.toRun = r;
                this.runLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean joinRunnable() {
            Object object = this.runLock;
            synchronized (object) {
                if (this.toRun != null) {
                    return this.joinRunnable(this.toRun);
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean joinRunnable(Runnable r) {
            Object object = this.runLock;
            synchronized (object) {
                if (this.toRun == r) {
                    try {
                        this.runLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Object object = this;
                synchronized (object) {
                    while (!this.go) {
                        if (this.die) {
                            this.die = false;
                            return;
                        }
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            Thread.interrupted();
                        }
                    }
                    this.go = false;
                }
                try {
                    this.toRun.run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Thread.interrupted();
                }
                object = ThreadPool.this.workersLock;
                synchronized (object) {
                    Object object2 = this.runLock;
                    synchronized (object2) {
                        ThreadPool.this.workers.add(this);
                        if (ThreadPool.this.totalWorkers == ThreadPool.this.workers.size()) {
                            ThreadPool.this.workersLock.notify();
                        }
                        this.toRun = null;
                        this.runLock.notifyAll();
                    }
                }
            }
        }
    }
}

