/*
 * Decompiled with CFR 0.152.
 */
package ec.vector;

import ec.EvolutionState;
import ec.Individual;
import ec.util.Code;
import ec.util.DecodeReturn;
import ec.util.Parameter;
import ec.vector.BitVectorSpecies;
import ec.vector.VectorDefaults;
import ec.vector.VectorIndividual;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Arrays;

public class BitVectorIndividual
extends VectorIndividual {
    private static final long serialVersionUID = 1L;
    public static final String P_BITVECTORINDIVIDUAL = "bit-vect-ind";
    public boolean[] genome;

    @Override
    public Parameter defaultBase() {
        return VectorDefaults.base().push(P_BITVECTORINDIVIDUAL);
    }

    @Override
    public Object clone() {
        BitVectorIndividual myobj = (BitVectorIndividual)super.clone();
        myobj.genome = (boolean[])this.genome.clone();
        return myobj;
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        BitVectorSpecies s = (BitVectorSpecies)this.species;
        this.genome = new boolean[s.genomeSize];
    }

    @Override
    public void defaultCrossover(EvolutionState state, int thread, VectorIndividual ind) {
        BitVectorSpecies s = (BitVectorSpecies)this.species;
        BitVectorIndividual i = (BitVectorIndividual)ind;
        int len = Math.min(this.genome.length, i.genome.length);
        if (len != this.genome.length || len != i.genome.length) {
            state.output.warnOnce("Genome lengths are not the same.  Vector crossover will only be done in overlapping region.");
        }
        switch (s.crossoverType) {
            case 0: {
                int point = state.random[thread].nextInt(len / s.chunksize);
                for (int x = 0; x < point * s.chunksize; ++x) {
                    boolean tmp = i.genome[x];
                    i.genome[x] = this.genome[x];
                    this.genome[x] = tmp;
                }
                break;
            }
            case 2: {
                int point = state.random[thread].nextInt(len / s.chunksize - 1) + 1;
                for (int x = 0; x < point * s.chunksize; ++x) {
                    boolean tmp = i.genome[x];
                    i.genome[x] = this.genome[x];
                    this.genome[x] = tmp;
                }
                break;
            }
            case 4: {
                int point = state.random[thread].nextInt(len / s.chunksize);
                int point0 = state.random[thread].nextInt(len / s.chunksize);
                if (point0 > point) {
                    int p = point0;
                    point0 = point;
                    point = p;
                }
                for (int x = point0 * s.chunksize; x < point * s.chunksize; ++x) {
                    boolean tmp = i.genome[x];
                    i.genome[x] = this.genome[x];
                    this.genome[x] = tmp;
                }
                break;
            }
            case 8: {
                int point = state.random[thread].nextInt(len / s.chunksize);
                int point0 = 0;
                while ((point0 = state.random[thread].nextInt(len / s.chunksize)) == point) {
                }
                if (point0 > point) {
                    int p = point0;
                    point0 = point;
                    point = p;
                }
                for (int x = point0 * s.chunksize; x < point * s.chunksize; ++x) {
                    boolean tmp = i.genome[x];
                    i.genome[x] = this.genome[x];
                    this.genome[x] = tmp;
                }
                break;
            }
            case 128: {
                for (int x = 0; x < len / s.chunksize; ++x) {
                    if (!state.random[thread].nextBoolean(s.crossoverProbability)) continue;
                    for (int y = x * s.chunksize; y < (x + 1) * s.chunksize; ++y) {
                        boolean tmp = i.genome[y];
                        i.genome[y] = this.genome[y];
                        this.genome[y] = tmp;
                    }
                }
                break;
            }
            default: {
                state.output.fatal("In valid crossover type in BitVectorIndividual.");
            }
        }
    }

    @Override
    public void split(int[] points, Object[] pieces) {
        int point0 = 0;
        int point1 = points[0];
        for (int x = 0; x < pieces.length; ++x) {
            pieces[x] = new boolean[point1 - point0];
            System.arraycopy(this.genome, point0, pieces[x], 0, point1 - point0);
            point0 = point1;
            point1 = x >= pieces.length - 2 ? this.genome.length : points[x + 1];
        }
    }

    @Override
    public void join(Object[] pieces) {
        int sum = 0;
        for (int x = 0; x < pieces.length; ++x) {
            sum += ((boolean[])pieces[x]).length;
        }
        int runningsum = 0;
        boolean[] newgenome = new boolean[sum];
        for (int x = 0; x < pieces.length; ++x) {
            System.arraycopy(pieces[x], 0, newgenome, runningsum, ((boolean[])pieces[x]).length);
            runningsum += ((boolean[])pieces[x]).length;
        }
        this.genome = newgenome;
    }

    @Override
    public void defaultMutate(EvolutionState state, int thread) {
        BitVectorSpecies s = (BitVectorSpecies)this.species;
        block4: for (int x = 0; x < this.genome.length; ++x) {
            if (!state.random[thread].nextBoolean(s.mutationProbability(x))) continue;
            boolean old = this.genome[x];
            for (int retries = 0; retries < s.duplicateRetries(x) + 1; ++retries) {
                switch (s.mutationType(x)) {
                    case 1: {
                        this.genome[x] = !this.genome[x];
                        break;
                    }
                    case 0: {
                        this.genome[x] = state.random[thread].nextBoolean();
                        break;
                    }
                    default: {
                        state.output.fatal("In BitVectorIndividual.defaultMutate, default case occurred when it shouldn't have");
                    }
                }
                if (this.genome[x] != old) continue block4;
            }
        }
    }

    @Override
    public void reset(EvolutionState state, int thread) {
        for (int x = 0; x < this.genome.length; ++x) {
            this.genome[x] = state.random[thread].nextBoolean();
        }
    }

    @Override
    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = (hash << 1 | hash >>> 31) ^ Arrays.hashCode(this.genome);
        return hash;
    }

    @Override
    public String genotypeToStringForHumans() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.genome.length; ++i) {
            if (this.genome[i]) {
                s.append("1 ");
                continue;
            }
            s.append("0 ");
        }
        return s.toString();
    }

    @Override
    public String genotypeToString() {
        StringBuilder s = new StringBuilder();
        s.append(Code.encode(this.genome.length));
        for (int i = 0; i < this.genome.length; ++i) {
            s.append(Code.encode(this.genome[i]));
        }
        return s.toString();
    }

    @Override
    protected void parseGenotype(EvolutionState state, LineNumberReader reader) throws IOException {
        String s = reader.readLine();
        DecodeReturn d = new DecodeReturn(s);
        Code.decode(d);
        if (d.type != 4) {
            state.output.fatal("Individual with genome:\n" + s + "\n... does not have an integer at the beginning indicating the genome count.");
        }
        int lll = (int)d.l;
        this.genome = new boolean[lll];
        for (int i = 0; i < this.genome.length; ++i) {
            Code.decode(d);
            this.genome[i] = d.l != 0L;
        }
    }

    @Override
    public boolean equals(Object ind) {
        if (ind == null) {
            return false;
        }
        if (!this.getClass().equals(ind.getClass())) {
            return false;
        }
        BitVectorIndividual i = (BitVectorIndividual)ind;
        if (this.genome.length != i.genome.length) {
            return false;
        }
        for (int j = 0; j < this.genome.length; ++j) {
            if (this.genome[j] == i.genome[j]) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getGenome() {
        return this.genome;
    }

    @Override
    public void setGenome(Object gen) {
        this.genome = (boolean[])gen;
    }

    @Override
    public int genomeLength() {
        return this.genome.length;
    }

    @Override
    public void setGenomeLength(int len) {
        boolean[] newGenome;
        System.arraycopy(this.genome, 0, newGenome, 0, this.genome.length < (newGenome = new boolean[len]).length ? this.genome.length : newGenome.length);
        this.genome = newGenome;
    }

    @Override
    public void writeGenotype(EvolutionState state, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.genome.length);
        for (int x = 0; x < this.genome.length; ++x) {
            dataOutput.writeBoolean(this.genome[x]);
        }
    }

    @Override
    public void readGenotype(EvolutionState state, DataInput dataInput) throws IOException {
        int len = dataInput.readInt();
        if (this.genome == null || this.genome.length != len) {
            this.genome = new boolean[len];
        }
        for (int x = 0; x < this.genome.length; ++x) {
            this.genome[x] = dataInput.readBoolean();
        }
    }

    @Override
    public double distanceTo(Individual otherInd) {
        if (!(otherInd instanceof BitVectorIndividual)) {
            return super.distanceTo(otherInd);
        }
        BitVectorIndividual other = (BitVectorIndividual)otherInd;
        boolean[] otherGenome = other.genome;
        double hammingDistance = 0.0;
        for (int i = 0; i < other.genomeLength(); ++i) {
            if (!(this.genome[i] ^ otherGenome[i])) continue;
            hammingDistance += 1.0;
        }
        return hammingDistance;
    }
}

