/*
 * Decompiled with CFR 0.152.
 */
package ec.vector;

import ec.EvolutionState;
import ec.util.Parameter;
import ec.vector.VectorSpecies;

public class BitVectorSpecies
extends VectorSpecies {
    private static final long serialVersionUID = 1L;
    public static final String P_MUTATIONTYPE = "mutation-type";
    public static final String V_RESET_MUTATION = "reset";
    public static final String V_FLIP_MUTATION = "flip";
    public static final int C_RESET_MUTATION = 0;
    public static final int C_FLIP_MUTATION = 1;
    protected int[] mutationType;

    public int mutationType(int gene) {
        int[] m = this.mutationType;
        if (m.length <= gene) {
            gene = m.length - 1;
        }
        return m[gene];
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        Parameter def = this.defaultBase();
        this.setupGenome(state, base);
        this.mutationType = this.fill(new int[this.genomeSize + 1], -1);
        String mtype = state.parameters.getStringWithDefault(base.push(P_MUTATIONTYPE), def.push(P_MUTATIONTYPE), null);
        int _mutationType = 1;
        if (mtype == null) {
            state.output.warning("No global mutation type given for BitVectorSpecies, assuming 'flip' mutation", base.push(P_MUTATIONTYPE), def.push(P_MUTATIONTYPE));
        } else if (mtype.equalsIgnoreCase(V_RESET_MUTATION)) {
            _mutationType = 0;
        } else if (mtype.equalsIgnoreCase(V_FLIP_MUTATION)) {
            _mutationType = 1;
        } else {
            state.output.fatal("BitVectorSpecies given a bad mutation type: " + mtype, base.push(P_MUTATIONTYPE), def.push(P_MUTATIONTYPE));
        }
        this.fill(this.mutationType, _mutationType);
        super.setup(state, base);
    }

    @Override
    protected void loadParametersForGene(EvolutionState state, int index, Parameter base, Parameter def, String postfix) {
        super.loadParametersForGene(state, index, base, def, postfix);
        String mtype = state.parameters.getStringWithDefault(base.push(P_MUTATIONTYPE).push(postfix), def.push(P_MUTATIONTYPE).push(postfix), null);
        if (mtype != null) {
            if (mtype.equalsIgnoreCase(V_RESET_MUTATION)) {
                this.mutationType[index] = 0;
            } else if (mtype.equalsIgnoreCase(V_FLIP_MUTATION)) {
                this.mutationType[index] = 1;
            } else {
                state.output.fatal("BitVectorSpecies given a bad mutation type: " + mtype, base.push(P_MUTATIONTYPE).push(postfix), def.push(P_MUTATIONTYPE).push(postfix));
            }
        }
    }
}

