/*
 * Decompiled with CFR 0.152.
 */
package ec.vector;

import ec.EvolutionState;
import ec.Individual;
import ec.util.Code;
import ec.util.DecodeReturn;
import ec.util.MersenneTwisterFast;
import ec.util.Parameter;
import ec.vector.FloatVectorSpecies;
import ec.vector.VectorDefaults;
import ec.vector.VectorIndividual;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.LineNumberReader;

public class DoubleVectorIndividual
extends VectorIndividual {
    private static final long serialVersionUID = 1L;
    public static final String P_DOUBLEVECTORINDIVIDUAL = "double-vect-ind";
    public static final double MAXIMUM_INTEGER_IN_DOUBLE = 9.007199254740992E15;
    public double[] genome;

    @Override
    public Parameter defaultBase() {
        return VectorDefaults.base().push(P_DOUBLEVECTORINDIVIDUAL);
    }

    @Override
    public Object clone() {
        DoubleVectorIndividual myobj = (DoubleVectorIndividual)super.clone();
        myobj.genome = (double[])this.genome.clone();
        return myobj;
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        if (!(this.species instanceof FloatVectorSpecies)) {
            state.output.fatal("DoubleVectorIndividual requires a FloatVectorSpecies", base, def);
        }
        FloatVectorSpecies s = (FloatVectorSpecies)this.species;
        this.genome = new double[s.genomeSize];
    }

    @Override
    public void defaultCrossover(EvolutionState state, int thread, VectorIndividual ind) {
        FloatVectorSpecies s = (FloatVectorSpecies)this.species;
        DoubleVectorIndividual i = (DoubleVectorIndividual)ind;
        int len = Math.min(this.genome.length, i.genome.length);
        if (len != this.genome.length || len != i.genome.length) {
            state.output.warnOnce("Genome lengths are not the same.  Vector crossover will only be done in overlapping region.");
        }
        switch (s.crossoverType) {
            case 0: {
                int point = state.random[thread].nextInt(len / s.chunksize);
                for (int x = 0; x < point * s.chunksize; ++x) {
                    double tmp = i.genome[x];
                    i.genome[x] = this.genome[x];
                    this.genome[x] = tmp;
                }
                break;
            }
            case 2: {
                int point = state.random[thread].nextInt(len / s.chunksize - 1) + 1;
                for (int x = 0; x < point * s.chunksize; ++x) {
                    double tmp = i.genome[x];
                    i.genome[x] = this.genome[x];
                    this.genome[x] = tmp;
                }
                break;
            }
            case 4: {
                int point = state.random[thread].nextInt(len / s.chunksize);
                int point0 = state.random[thread].nextInt(len / s.chunksize);
                if (point0 > point) {
                    int p = point0;
                    point0 = point;
                    point = p;
                }
                for (int x = point0 * s.chunksize; x < point * s.chunksize; ++x) {
                    double tmp = i.genome[x];
                    i.genome[x] = this.genome[x];
                    this.genome[x] = tmp;
                }
                break;
            }
            case 8: {
                int point = state.random[thread].nextInt(len / s.chunksize);
                int point0 = 0;
                while ((point0 = state.random[thread].nextInt(len / s.chunksize)) == point) {
                }
                if (point0 > point) {
                    int p = point0;
                    point0 = point;
                    point = p;
                }
                for (int x = point0 * s.chunksize; x < point * s.chunksize; ++x) {
                    double tmp = i.genome[x];
                    i.genome[x] = this.genome[x];
                    this.genome[x] = tmp;
                }
                break;
            }
            case 128: {
                for (int x = 0; x < len / s.chunksize; ++x) {
                    if (!state.random[thread].nextBoolean(s.crossoverProbability)) continue;
                    for (int y = x * s.chunksize; y < (x + 1) * s.chunksize; ++y) {
                        double tmp = i.genome[y];
                        i.genome[y] = this.genome[y];
                        this.genome[y] = tmp;
                    }
                }
                break;
            }
            case 256: {
                double alpha = state.random[thread].nextDouble(true, true) * (1.0 + 2.0 * s.lineDistance) - s.lineDistance;
                double beta = state.random[thread].nextDouble(true, true) * (1.0 + 2.0 * s.lineDistance) - s.lineDistance;
                for (int x = 0; x < len; ++x) {
                    double min = s.minGene(x);
                    double max = s.maxGene(x);
                    double t = alpha * this.genome[x] + (1.0 - alpha) * i.genome[x];
                    double u = beta * i.genome[x] + (1.0 - beta) * this.genome[x];
                    if (t < min || t > max || u < min || u > max) continue;
                    this.genome[x] = t;
                    i.genome[x] = u;
                }
                break;
            }
            case 512: {
                for (int x = 0; x < len; ++x) {
                    double u;
                    double max;
                    double min;
                    double t;
                    do {
                        double alpha = state.random[thread].nextDouble(true, true) * (1.0 + 2.0 * s.lineDistance) - s.lineDistance;
                        double beta = state.random[thread].nextDouble(true, true) * (1.0 + 2.0 * s.lineDistance) - s.lineDistance;
                        min = s.minGene(x);
                        max = s.maxGene(x);
                        t = alpha * this.genome[x] + (1.0 - alpha) * i.genome[x];
                        u = beta * i.genome[x] + (1.0 - beta) * this.genome[x];
                    } while (t < min || t > max || u < min || u > max);
                    this.genome[x] = t;
                    i.genome[x] = u;
                }
                break;
            }
            case 1024: {
                this.simulatedBinaryCrossover(state.random[thread], i, s.crossoverDistributionIndex);
                break;
            }
            default: {
                state.output.fatal("In DoubleVectorIndividual.defaultCrossover, default case occurred when it shouldn't have");
            }
        }
    }

    @Override
    public void split(int[] points, Object[] pieces) {
        int point0 = 0;
        int point1 = points[0];
        for (int x = 0; x < pieces.length; ++x) {
            pieces[x] = new double[point1 - point0];
            System.arraycopy(this.genome, point0, pieces[x], 0, point1 - point0);
            point0 = point1;
            point1 = x >= pieces.length - 2 ? this.genome.length : points[x + 1];
        }
    }

    @Override
    public void join(Object[] pieces) {
        int sum = 0;
        for (int x = 0; x < pieces.length; ++x) {
            sum += ((double[])pieces[x]).length;
        }
        int runningsum = 0;
        double[] newgenome = new double[sum];
        for (int x = 0; x < pieces.length; ++x) {
            System.arraycopy(pieces[x], 0, newgenome, runningsum, ((double[])pieces[x]).length);
            runningsum += ((double[])pieces[x]).length;
        }
        this.genome = newgenome;
    }

    @Override
    public void defaultMutate(EvolutionState state, int thread) {
        FloatVectorSpecies s = (FloatVectorSpecies)this.species;
        MersenneTwisterFast rng = state.random[thread];
        block7: for (int x = 0; x < this.genome.length; ++x) {
            if (!rng.nextBoolean(s.mutationProbability(x))) continue;
            double old = this.genome[x];
            for (int retries = 0; retries < s.duplicateRetries(x) + 1 + 1; ++retries) {
                switch (s.mutationType(x)) {
                    case 1: {
                        this.gaussianMutation(state, rng, s, x);
                        break;
                    }
                    case 2: {
                        this.polynomialMutation(state, rng, s, x);
                        break;
                    }
                    case 0: {
                        this.floatResetMutation(rng, s, x);
                        break;
                    }
                    case 3: {
                        this.integerResetMutation(rng, s, x);
                        break;
                    }
                    case 4: {
                        this.integerRandomWalkMutation(rng, s, x);
                        break;
                    }
                    default: {
                        state.output.fatal("In DoubleVectorIndividual.defaultMutate, default case occurred when it shouldn't have");
                    }
                }
                if (this.genome[x] != old) continue block7;
            }
        }
    }

    void integerRandomWalkMutation(MersenneTwisterFast random, FloatVectorSpecies species, int index) {
        double min = species.minGene(index);
        double max = species.maxGene(index);
        if (!species.mutationIsBounded(index)) {
            max = 9.007199254740992E15;
            min = -max;
        }
        do {
            int n = random.nextBoolean() ? 1 : -1;
            double g = Math.floor(this.genome[index]);
            if (n == 1 && g < max || n == -1 && g > min) {
                this.genome[index] = g + (double)n;
                continue;
            }
            if (!(n == -1 && g < max) && (n != 1 || !(g > min))) continue;
            this.genome[index] = g - (double)n;
        } while (random.nextBoolean(species.randomWalkProbability(index)));
    }

    void integerResetMutation(MersenneTwisterFast random, FloatVectorSpecies species, int index) {
        long minGene = (long)Math.floor(species.minGene(index));
        long maxGene = (long)Math.floor(species.maxGene(index));
        this.genome[index] = this.randomValueFromClosedInterval(minGene, maxGene, random);
    }

    void floatResetMutation(MersenneTwisterFast random, FloatVectorSpecies species, int index) {
        double minGene = species.minGene(index);
        double maxGene = species.maxGene(index);
        this.genome[index] = minGene + random.nextDouble(true, true) * (maxGene - minGene);
    }

    void gaussianMutation(EvolutionState state, MersenneTwisterFast random, FloatVectorSpecies species, int index) {
        double val;
        block1: {
            double min = species.minGene(index);
            double max = species.maxGene(index);
            double stdev = species.gaussMutationStdev(index);
            int outOfBoundsLeftOverTries = species.outOfBoundsRetries;
            boolean givingUpAllowed = species.outOfBoundsRetries != 0;
            do {
                val = random.nextGaussian() * stdev + this.genome[index];
                --outOfBoundsLeftOverTries;
                if (!species.mutationIsBounded(index) || !(val > max) && !(val < min)) break block1;
            } while (!givingUpAllowed || outOfBoundsLeftOverTries != 0);
            val = min + random.nextDouble() * (max - min);
            species.outOfRangeRetryLimitReached(state);
        }
        this.genome[index] = val;
    }

    void polynomialMutation(EvolutionState state, MersenneTwisterFast random, FloatVectorSpecies species, int index) {
        double y;
        double eta_m = species.mutationDistributionIndex(index);
        boolean alternativePolynomialVersion = species.polynomialIsAlternative(index);
        double y1 = y = this.genome[index];
        double yl = species.minGene(index);
        double yu = species.maxGene(index);
        double delta1 = (y - yl) / (yu - yl);
        double delta2 = (yu - y) / (yu - yl);
        int totalTries = species.outOfBoundsRetries;
        int tries = 0;
        for (tries = 0; tries < totalTries || totalTries == 0; ++tries) {
            double deltaq;
            double rnd = random.nextDouble();
            double mut_pow = 1.0 / (eta_m + 1.0);
            if (rnd <= 0.5) {
                xy = 1.0 - delta1;
                val = 2.0 * rnd + (alternativePolynomialVersion ? (1.0 - 2.0 * rnd) * Math.pow(xy, eta_m + 1.0) : 0.0);
                deltaq = Math.pow(val, mut_pow) - 1.0;
            } else {
                xy = 1.0 - delta2;
                val = 2.0 * (1.0 - rnd) + (alternativePolynomialVersion ? 2.0 * (rnd - 0.5) * Math.pow(xy, eta_m + 1.0) : 0.0);
                deltaq = 1.0 - Math.pow(val, mut_pow);
            }
            y1 = y + deltaq * (yu - yl);
            if (!species.mutationIsBounded(index) || y1 >= yl && y1 <= yu) break;
        }
        if (totalTries != 0 && tries == totalTries) {
            y1 = species.minGene(index) + random.nextDouble(true, true) * (species.maxGene(index) - species.minGene(index));
            species.outOfRangeRetryLimitReached(state);
        }
        this.genome[index] = y1;
    }

    public void polynomialMutate(EvolutionState state, MersenneTwisterFast random, double eta_m, boolean alternativePolynomialVersion, boolean mutationIsBounded) {
        FloatVectorSpecies s = (FloatVectorSpecies)this.species;
        double[] ind = this.genome;
        for (int j = 0; j < ind.length; ++j) {
            double y;
            if (!random.nextBoolean(s.mutationProbability[j])) continue;
            double y1 = y = ind[j];
            double yl = s.minGene(j);
            double yu = s.maxGene(j);
            double delta1 = (y - yl) / (yu - yl);
            double delta2 = (yu - y) / (yu - yl);
            int totalTries = s.outOfBoundsRetries;
            int tries = 0;
            for (tries = 0; tries < totalTries || totalTries == 0; ++tries) {
                double deltaq;
                double rnd = random.nextDouble();
                double mut_pow = 1.0 / (eta_m + 1.0);
                if (rnd <= 0.5) {
                    xy = 1.0 - delta1;
                    val = 2.0 * rnd + (alternativePolynomialVersion ? (1.0 - 2.0 * rnd) * Math.pow(xy, eta_m + 1.0) : 0.0);
                    deltaq = Math.pow(val, mut_pow) - 1.0;
                } else {
                    xy = 1.0 - delta2;
                    val = 2.0 * (1.0 - rnd) + (alternativePolynomialVersion ? 2.0 * (rnd - 0.5) * Math.pow(xy, eta_m + 1.0) : 0.0);
                    deltaq = 1.0 - Math.pow(val, mut_pow);
                }
                y1 = y + deltaq * (yu - yl);
                if (!mutationIsBounded || y1 >= yl && y1 <= yu) break;
            }
            if (totalTries != 0 && tries == totalTries) {
                y1 = s.minGene(j) + random.nextDouble(true, true) * (s.maxGene(j) - s.minGene(j));
                s.outOfRangeRetryLimitReached(state);
            }
            ind[j] = y1;
        }
    }

    public void simulatedBinaryCrossover(MersenneTwisterFast random, DoubleVectorIndividual other, double eta_c) {
        double EPS = 1.0E-14;
        FloatVectorSpecies s = (FloatVectorSpecies)this.species;
        double[] parent1 = this.genome;
        double[] parent2 = other.genome;
        for (int i = 0; i < parent1.length; ++i) {
            double y2;
            double y1;
            if (!random.nextBoolean() || !(Math.abs(parent1[i] - parent2[i]) > 1.0E-14)) continue;
            if (parent1[i] < parent2[i]) {
                y1 = parent1[i];
                y2 = parent2[i];
            } else {
                y1 = parent2[i];
                y2 = parent1[i];
            }
            double yl = s.minGene(i);
            double yu = s.maxGene(i);
            double rand = random.nextDouble();
            double beta = 1.0 + 2.0 * (y1 - yl) / (y2 - y1);
            double alpha = 2.0 - Math.pow(beta, -(eta_c + 1.0));
            double betaq = rand <= 1.0 / alpha ? Math.pow(rand * alpha, 1.0 / (eta_c + 1.0)) : Math.pow(1.0 / (2.0 - rand * alpha), 1.0 / (eta_c + 1.0));
            double c1 = 0.5 * (y1 + y2 - betaq * (y2 - y1));
            beta = 1.0 + 2.0 * (yu - y2) / (y2 - y1);
            alpha = 2.0 - Math.pow(beta, -(eta_c + 1.0));
            betaq = rand <= 1.0 / alpha ? Math.pow(rand * alpha, 1.0 / (eta_c + 1.0)) : Math.pow(1.0 / (2.0 - rand * alpha), 1.0 / (eta_c + 1.0));
            double c2 = 0.5 * (y1 + y2 + betaq * (y2 - y1));
            if (c1 < yl) {
                c1 = yl;
            }
            if (c2 < yl) {
                c2 = yl;
            }
            if (c1 > yu) {
                c1 = yu;
            }
            if (c2 > yu) {
                c2 = yu;
            }
            if (random.nextBoolean()) {
                parent1[i] = c2;
                parent2[i] = c1;
                continue;
            }
            parent1[i] = c1;
            parent2[i] = c2;
        }
    }

    long randomValueFromClosedInterval(long min, long max, MersenneTwisterFast random) {
        if (max - min < 0L) {
            long l = 0L;
            while ((l = (long)random.nextInt()) < min || l > max) {
            }
            return l;
        }
        return min + random.nextLong(max - min + 1L);
    }

    @Override
    public void reset(EvolutionState state, int thread) {
        FloatVectorSpecies s = (FloatVectorSpecies)this.species;
        MersenneTwisterFast random = state.random[thread];
        for (int x = 0; x < this.genome.length; ++x) {
            int type = s.mutationType(x);
            if (type == 3 || type == 4) {
                long minGene = (long)Math.floor(s.minGene(x));
                long maxGene = (long)Math.floor(s.maxGene(x));
                this.genome[x] = this.randomValueFromClosedInterval(minGene, maxGene, random);
                continue;
            }
            this.genome[x] = s.minGene(x) + random.nextDouble(true, true) * (s.maxGene(x) - s.minGene(x));
        }
    }

    @Override
    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash << 1 | hash >>> 31;
        for (int x = 0; x < this.genome.length; ++x) {
            long l = Double.doubleToLongBits(this.genome[x]);
            hash = (hash << 1 | hash >>> 31) ^ (int)(l >>> 16 & 0xFFFFFFFL) ^ (int)(l & 0xFFFFL);
        }
        return hash;
    }

    @Override
    public String genotypeToStringForHumans() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.genome.length; ++i) {
            if (i > 0) {
                s.append(" ");
            }
            s.append(this.genome[i]);
        }
        return s.toString();
    }

    @Override
    public String genotypeToString() {
        StringBuilder s = new StringBuilder();
        s.append(Code.encode(this.genome.length));
        for (int i = 0; i < this.genome.length; ++i) {
            s.append(Code.encode(this.genome[i]));
        }
        return s.toString();
    }

    @Override
    protected void parseGenotype(EvolutionState state, LineNumberReader reader) throws IOException {
        String s = reader.readLine();
        DecodeReturn d = new DecodeReturn(s);
        Code.decode(d);
        if (d.type != 4) {
            state.output.fatal("Individual with genome:\n" + s + "\n... does not have an integer at the beginning indicating the genome count.");
        }
        int lll = (int)d.l;
        this.genome = new double[lll];
        for (int i = 0; i < this.genome.length; ++i) {
            Code.decode(d);
            this.genome[i] = d.d;
        }
    }

    @Override
    public boolean equals(Object ind) {
        if (ind == null) {
            return false;
        }
        if (!this.getClass().equals(ind.getClass())) {
            return false;
        }
        DoubleVectorIndividual i = (DoubleVectorIndividual)ind;
        if (this.genome.length != i.genome.length) {
            return false;
        }
        for (int j = 0; j < this.genome.length; ++j) {
            if (this.genome[j] == i.genome[j]) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getGenome() {
        return this.genome;
    }

    @Override
    public void setGenome(Object gen) {
        this.genome = (double[])gen;
    }

    @Override
    public int genomeLength() {
        return this.genome.length;
    }

    @Override
    public void writeGenotype(EvolutionState state, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.genome.length);
        for (int x = 0; x < this.genome.length; ++x) {
            dataOutput.writeDouble(this.genome[x]);
        }
    }

    @Override
    public void readGenotype(EvolutionState state, DataInput dataInput) throws IOException {
        int len = dataInput.readInt();
        if (this.genome == null || this.genome.length != len) {
            this.genome = new double[len];
        }
        for (int x = 0; x < this.genome.length; ++x) {
            this.genome[x] = dataInput.readDouble();
        }
    }

    public void clamp() {
        FloatVectorSpecies _species = (FloatVectorSpecies)this.species;
        for (int i = 0; i < this.genomeLength(); ++i) {
            double minGene = _species.minGene(i);
            if (this.genome[i] < minGene) {
                this.genome[i] = minGene;
                continue;
            }
            double maxGene = _species.maxGene(i);
            if (!(this.genome[i] > maxGene)) continue;
            this.genome[i] = maxGene;
        }
    }

    @Override
    public void setGenomeLength(int len) {
        double[] newGenome;
        System.arraycopy(this.genome, 0, newGenome, 0, this.genome.length < (newGenome = new double[len]).length ? this.genome.length : newGenome.length);
        this.genome = newGenome;
    }

    public boolean isInRange() {
        FloatVectorSpecies _species = (FloatVectorSpecies)this.species;
        for (int i = 0; i < this.genomeLength(); ++i) {
            if (!(this.genome[i] < _species.minGene(i)) && !(this.genome[i] > _species.maxGene(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public double distanceTo(Individual otherInd) {
        if (!(otherInd instanceof DoubleVectorIndividual)) {
            return super.distanceTo(otherInd);
        }
        DoubleVectorIndividual other = (DoubleVectorIndividual)otherInd;
        double[] otherGenome = other.genome;
        double sumSquaredDistance = 0.0;
        for (int i = 0; i < other.genomeLength(); ++i) {
            double dist = this.genome[i] - otherGenome[i];
            sumSquaredDistance += dist * dist;
        }
        return StrictMath.sqrt(sumSquaredDistance);
    }
}

