/*
 * Decompiled with CFR 0.152.
 */
package ec.vector;

import ec.EvolutionState;
import ec.Prototype;
import ec.util.Parameter;
import ec.vector.VectorDefaults;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;

public abstract class Gene
implements Prototype {
    private static final long serialVersionUID = 1L;
    public static final String P_GENE = "gene";
    private static final String P_VECTOR_GENE = "vect-gene";

    @Override
    public void setup(EvolutionState state, Parameter base) {
    }

    @Override
    public Parameter defaultBase() {
        return VectorDefaults.base().push(P_GENE);
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract void reset(EvolutionState var1, int var2);

    public void mutate(EvolutionState state, int thread) {
        this.reset(state, thread);
    }

    public void printGeneForHumans(EvolutionState state, int verbosity, int log) {
        state.output.println(this.printGeneToStringForHumans(), log);
    }

    public String printGeneToStringForHumans() {
        return this.toString();
    }

    public String printGeneToString() {
        return this.toString();
    }

    public void readGeneFromString(String string, EvolutionState state) {
        state.output.error("readGeneFromString(string,state) unimplemented in " + String.valueOf(this.getClass()));
    }

    public void printGene(EvolutionState state, int verbosity, int log) {
        state.output.println(this.printGeneToString(), log);
    }

    public void printGene(EvolutionState state, PrintWriter writer) {
        writer.println(this.printGeneToString());
    }

    public void readGene(EvolutionState state, LineNumberReader reader) throws IOException {
        this.readGeneFromString(reader.readLine(), state);
    }

    public void writeGene(EvolutionState state, DataOutput dataOutput) throws IOException {
        state.output.fatal("writeGene(EvolutionState, DataOutput) not implemented in " + String.valueOf(this.getClass()));
    }

    public void readGene(EvolutionState state, DataInput dataInput) throws IOException {
        state.output.fatal("readGene(EvolutionState, DataInput) not implemented in " + String.valueOf(this.getClass()));
    }
}

