/*
 * Decompiled with CFR 0.152.
 */
package ec.vector;

import ec.EvolutionState;
import ec.util.Code;
import ec.util.DecodeReturn;
import ec.util.Parameter;
import ec.vector.Gene;
import ec.vector.GeneVectorSpecies;
import ec.vector.VectorDefaults;
import ec.vector.VectorIndividual;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.LineNumberReader;

public class GeneVectorIndividual
extends VectorIndividual {
    private static final long serialVersionUID = 1L;
    public static final String P_GENEVECTORINDIVIDUAL = "gene-vect-ind";
    public Gene[] genome;

    @Override
    public Parameter defaultBase() {
        return VectorDefaults.base().push(P_GENEVECTORINDIVIDUAL);
    }

    @Override
    public Object clone() {
        GeneVectorIndividual myobj = (GeneVectorIndividual)super.clone();
        myobj.genome = (Gene[])this.genome.clone();
        for (int x = 0; x < this.genome.length; ++x) {
            myobj.genome[x] = (Gene)this.genome[x].clone();
        }
        return myobj;
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        if (!(this.species instanceof GeneVectorSpecies)) {
            state.output.fatal("GeneVectorIndividual requires a GeneVectorSpecies", base, def);
        }
        GeneVectorSpecies s = (GeneVectorSpecies)this.species;
        this.genome = new Gene[s.genomeSize];
        this.reset(state, 0);
    }

    @Override
    public void defaultCrossover(EvolutionState state, int thread, VectorIndividual ind) {
        GeneVectorSpecies s = (GeneVectorSpecies)this.species;
        GeneVectorIndividual i = (GeneVectorIndividual)ind;
        int len = Math.min(this.genome.length, i.genome.length);
        if (len != this.genome.length || len != i.genome.length) {
            state.output.warnOnce("Genome lengths are not the same.  Vector crossover will only be done in overlapping region.");
        }
        switch (s.crossoverType) {
            case 0: {
                int point = state.random[thread].nextInt(len / s.chunksize);
                for (int x = 0; x < point * s.chunksize; ++x) {
                    Gene tmp = i.genome[x];
                    i.genome[x] = this.genome[x];
                    this.genome[x] = tmp;
                }
                break;
            }
            case 2: {
                int point = state.random[thread].nextInt(len / s.chunksize - 1) + 1;
                for (int x = 0; x < point * s.chunksize; ++x) {
                    Gene tmp = i.genome[x];
                    i.genome[x] = this.genome[x];
                    this.genome[x] = tmp;
                }
                break;
            }
            case 4: {
                int point = state.random[thread].nextInt(len / s.chunksize);
                int point0 = state.random[thread].nextInt(len / s.chunksize);
                if (point0 > point) {
                    int p = point0;
                    point0 = point;
                    point = p;
                }
                for (int x = point0 * s.chunksize; x < point * s.chunksize; ++x) {
                    Gene tmp = i.genome[x];
                    i.genome[x] = this.genome[x];
                    this.genome[x] = tmp;
                }
                break;
            }
            case 8: {
                int point = state.random[thread].nextInt(len / s.chunksize);
                int point0 = 0;
                while ((point0 = state.random[thread].nextInt(len / s.chunksize)) == point) {
                }
                if (point0 > point) {
                    int p = point0;
                    point0 = point;
                    point = p;
                }
                for (int x = point0 * s.chunksize; x < point * s.chunksize; ++x) {
                    Gene tmp = i.genome[x];
                    i.genome[x] = this.genome[x];
                    this.genome[x] = tmp;
                }
                break;
            }
            case 128: {
                for (int x = 0; x < len / s.chunksize; ++x) {
                    if (!state.random[thread].nextBoolean(s.crossoverProbability)) continue;
                    for (int y = x * s.chunksize; y < (x + 1) * s.chunksize; ++y) {
                        Gene tmp = i.genome[y];
                        i.genome[y] = this.genome[y];
                        this.genome[y] = tmp;
                    }
                }
                break;
            }
        }
    }

    @Override
    public void split(int[] points, Object[] pieces) {
        int point0 = 0;
        int point1 = points[0];
        for (int x = 0; x < pieces.length; ++x) {
            pieces[x] = new Gene[point1 - point0];
            System.arraycopy(this.genome, point0, pieces[x], 0, point1 - point0);
            point0 = point1;
            point1 = x >= pieces.length - 2 ? this.genome.length : points[x + 1];
        }
    }

    @Override
    public void join(Object[] pieces) {
        int sum = 0;
        for (int x = 0; x < pieces.length; ++x) {
            sum += ((Gene[])pieces[x]).length;
        }
        int runningsum = 0;
        Gene[] newgenome = new Gene[sum];
        for (int x = 0; x < pieces.length; ++x) {
            System.arraycopy(pieces[x], 0, newgenome, runningsum, ((Gene[])pieces[x]).length);
            runningsum += ((Gene[])pieces[x]).length;
        }
        this.genome = newgenome;
    }

    @Override
    public void defaultMutate(EvolutionState state, int thread) {
        GeneVectorSpecies s = (GeneVectorSpecies)this.species;
        block0: for (int x = 0; x < this.genome.length; ++x) {
            if (!state.random[thread].nextBoolean(s.mutationProbability(x))) continue;
            if (s.duplicateRetries(x) <= 0) {
                this.genome[x].mutate(state, thread);
                continue;
            }
            Gene old = (Gene)this.genome[x].clone();
            for (int retries = 0; retries < s.duplicateRetries(x) + 1; ++retries) {
                this.genome[x].mutate(state, thread);
                if (!this.genome[x].equals(old)) continue block0;
                this.genome[x] = old;
            }
        }
    }

    @Override
    public void reset(EvolutionState state, int thread) {
        GeneVectorSpecies s = (GeneVectorSpecies)this.species;
        for (int x = 0; x < this.genome.length; ++x) {
            if (this.genome[x] == null) {
                this.genome[x] = (Gene)s.genePrototype.clone();
            }
            this.genome[x].reset(state, thread);
        }
    }

    @Override
    public int hashCode() {
        int hash = this.getClass().hashCode();
        for (int x = 0; x < this.genome.length; ++x) {
            hash = (hash << 1 | hash >>> 31) ^ this.genome[x].hashCode();
        }
        return hash;
    }

    @Override
    public String genotypeToStringForHumans() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.genome.length; ++i) {
            if (i > 0) {
                s.append(" ");
            }
            s.append(this.genome[i].printGeneToStringForHumans());
        }
        return s.toString();
    }

    @Override
    public String genotypeToString() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.genome.length; ++i) {
            s.append(" ");
            s.append(this.genome[i].printGeneToString());
        }
        return s.toString();
    }

    @Override
    protected void parseGenotype(EvolutionState state, LineNumberReader reader) throws IOException {
        String s = reader.readLine();
        DecodeReturn d = new DecodeReturn(s);
        Code.decode(d);
        if (d.type != 4) {
            state.output.fatal("Individual with genome:\n" + s + "\n... does not have an integer at the beginning indicating the genome count.");
        }
        int lll = (int)d.l;
        this.genome = new Gene[lll];
        GeneVectorSpecies _species = (GeneVectorSpecies)this.species;
        for (int i = 0; i < this.genome.length; ++i) {
            this.genome[i] = (Gene)_species.genePrototype.clone();
            this.genome[i].readGene(state, reader);
        }
    }

    @Override
    public boolean equals(Object ind) {
        if (ind == null) {
            return false;
        }
        if (!this.getClass().equals(ind.getClass())) {
            return false;
        }
        GeneVectorIndividual i = (GeneVectorIndividual)ind;
        if (this.genome.length != i.genome.length) {
            return false;
        }
        for (int j = 0; j < this.genome.length; ++j) {
            if (this.genome[j].equals(i.genome[j])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getGenome() {
        return this.genome;
    }

    @Override
    public void setGenome(Object gen) {
        this.genome = (Gene[])gen;
    }

    @Override
    public int genomeLength() {
        return this.genome.length;
    }

    @Override
    public void cloneGenes(Object piece) {
        Gene[] genes = (Gene[])piece;
        for (int i = 0; i < genes.length; ++i) {
            if (genes[i] == null) continue;
            genes[i] = (Gene)genes[i].clone();
        }
    }

    @Override
    public void writeGenotype(EvolutionState state, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.genome.length);
        for (int x = 0; x < this.genome.length; ++x) {
            this.genome[x].writeGene(state, dataOutput);
        }
    }

    @Override
    public void setGenomeLength(int len) {
        Gene[] newGenome;
        GeneVectorSpecies s = (GeneVectorSpecies)this.species;
        System.arraycopy(this.genome, 0, newGenome, 0, this.genome.length < (newGenome = new Gene[len]).length ? this.genome.length : newGenome.length);
        for (int x = this.genome.length; x < newGenome.length; ++x) {
            newGenome[x] = (Gene)s.genePrototype.clone();
        }
        this.genome = newGenome;
    }

    @Override
    public void readGenotype(EvolutionState state, DataInput dataInput) throws IOException {
        int len = dataInput.readInt();
        if (this.genome == null || this.genome.length != len) {
            this.genome = new Gene[len];
        }
        GeneVectorSpecies _species = (GeneVectorSpecies)this.species;
        for (int x = 0; x < this.genome.length; ++x) {
            this.genome[x] = (Gene)_species.genePrototype.clone();
            this.genome[x].readGene(state, dataInput);
        }
    }
}

