/*
 * Decompiled with CFR 0.152.
 */
package ec.vector.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.util.Parameter;
import ec.vector.VectorDefaults;
import ec.vector.VectorIndividual;
import ec.vector.VectorSpecies;
import java.util.ArrayList;
import java.util.HashMap;

public class MultipleVectorCrossoverPipeline
extends BreedingPipeline {
    private static final long serialVersionUID = 1L;
    public static final String P_CROSSOVER = "multixover";
    ArrayList<Individual> parents;

    @Override
    public Parameter defaultBase() {
        return VectorDefaults.base().push(P_CROSSOVER);
    }

    @Override
    public int numSources() {
        return -1;
    }

    @Override
    public Object clone() {
        MultipleVectorCrossoverPipeline c = (MultipleVectorCrossoverPipeline)super.clone();
        c.parents = new ArrayList<Individual>(this.parents);
        return c;
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        if (this.sources.length <= 2) {
            state.output.fatal("num-sources must be provided and > 2 for MultipleVectorCrossoverPipeline", base.push("num-sources"), def.push("num-sources"));
        }
        this.parents = new ArrayList();
    }

    @Override
    public int typicalIndsProduced() {
        return this.minChildProduction() * this.sources.length;
    }

    @Override
    public int produce(int min, int max, int subpopulation, ArrayList<Individual> inds, EvolutionState state, int thread, HashMap<String, Object> misc) {
        int i;
        int start = inds.size();
        int n = this.typicalIndsProduced();
        if (n < min) {
            n = min;
        }
        if (n > max) {
            n = max;
        }
        if (!state.random[thread].nextBoolean(this.likelihood)) {
            this.sources[0].produce(n, n, subpopulation, inds, state, thread, misc);
            return n;
        }
        this.parents.clear();
        for (int i2 = 0; i2 < this.sources.length; ++i2) {
            this.sources[i2].produce(1, 1, subpopulation, this.parents, state, thread, misc);
        }
        VectorSpecies species = (VectorSpecies)((VectorIndividual)this.parents.get((int)0)).species;
        int[] points = new int[((VectorIndividual)this.parents.get(0)).genomeLength() - 1];
        for (int i3 = 0; i3 < points.length; ++i3) {
            points[i3] = i3 + 1;
        }
        Object[][] pieces = new Object[this.parents.size()][((VectorIndividual)this.parents.get(0)).genomeLength()];
        for (i = 0; i < this.parents.size(); ++i) {
            if (((VectorIndividual)this.parents.get(i)).genomeLength() != ((VectorIndividual)this.parents.get(0)).genomeLength()) {
                state.output.fatal("All vectors must be of the same length for crossover!");
                continue;
            }
            ((VectorIndividual)this.parents.get(i)).split(points, pieces[i]);
        }
        for (i = 0; i < pieces[0].length; ++i) {
            if (!state.random[thread].nextBoolean(species.crossoverProbability)) continue;
            for (int j = pieces.length - 1; j > 0; --j) {
                int parent2 = state.random[thread].nextInt(j);
                Object temp = pieces[j][i];
                pieces[j][i] = pieces[parent2][i];
                pieces[parent2][i] = temp;
            }
        }
        i = 0;
        int q = start;
        while (i < this.parents.size()) {
            ((VectorIndividual)this.parents.get(i)).join(pieces[i]);
            this.parents.get((int)i).evaluated = false;
            inds.add(this.parents.get(i));
            ++i;
            ++q;
        }
        return n;
    }
}

