/*
 * Decompiled with CFR 0.152.
 */
package drm.agentbase;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

public class AgentInputStream
extends ObjectInputStream {
    private ClassLoader classLoader = null;

    public static Object getObject(byte[] m, Object agent) throws IOException, ClassNotFoundException {
        if (m == null) {
            return null;
        }
        Object result = null;
        ClassLoader cl = null;
        if (agent != null) {
            cl = agent.getClass().getClassLoader();
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(m);
        AgentInputStream mis = new AgentInputStream(bis, cl);
        result = mis.readObject();
        return result;
    }

    public void setClassLoader(ClassLoader cl) {
        this.classLoader = cl;
    }

    protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
        Class<?> result = null;
        try {
            return super.resolveClass(v);
        }
        catch (ClassNotFoundException e) {
            result = Class.forName(v.getName(), true, this.classLoader);
            if (result == null) {
                throw new ClassNotFoundException("No ClassLoader was found for " + v.getName());
            }
            return result;
        }
    }

    public AgentInputStream(InputStream in, ClassLoader cl) throws IOException {
        super(in);
        this.classLoader = cl;
    }
}

