/*
 * Decompiled with CFR 0.152.
 */
package drm.agentbase;

import drm.agentbase.Address;
import drm.agentbase.AgentBox;
import drm.agentbase.AgentInputStream;
import drm.agentbase.ClassLoaderManager;
import drm.agentbase.Connection;
import drm.agentbase.IAgent;
import drm.agentbase.IBase;
import drm.agentbase.IBaseListener;
import drm.agentbase.IRequest;
import drm.agentbase.JobClassLoader;
import drm.agentbase.LaunchImpossibleException;
import drm.agentbase.Logger;
import drm.agentbase.Message;
import drm.agentbase.StaticRequest;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectOutputStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

public class Base
implements IBase,
IAgent {
    private static final long serialVersionUID = 1L;
    private int port = -1;
    private ListenThread listenThread = null;
    private ServerSocket serverSocket = null;
    private ClassLoaderManager clm = null;
    private List baseListeners = Collections.synchronizedList(new Vector());
    private final long REFRESHRATE = 10000L;
    private final long JAR_TIMEOUT = 60000L;
    protected final Properties cfg;
    protected Map boxes = Collections.synchronizedMap(new Hashtable());
    public static final byte MESSAGE = 0;
    public static final byte AGENT = 1;
    public static final byte ISALIVE = 123;
    public static final byte GET_JAR = 100;
    public static final int SENDING_DIR = -2;
    public static final byte OK = 101;
    public static final byte NOT_OK = 102;
    public static final int GROUP_MISMATCH = -1;
    public static final int PROTOCOL_MISMATCH = -1;
    public static final int PROTOCOL_VERSION = 2;
    public static final int RELEASE_VERSION = 200000;
    public final String name;
    public final String group;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAgentArrived(String n) {
        List list = this.baseListeners;
        synchronized (list) {
            Iterator i = this.baseListeners.iterator();
            while (i.hasNext()) {
                ((IBaseListener)i.next()).agentArrived(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAgentDestroyed(String n) {
        List list = this.baseListeners;
        synchronized (list) {
            Iterator i = this.baseListeners.iterator();
            while (i.hasNext()) {
                ((IBaseListener)i.next()).agentDestroyed(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void addAgent(IAgent a, Address from, Address here) throws LaunchImpossibleException {
        if (a != this && !(a.getClass().getClassLoader() instanceof JobClassLoader)) {
            throw new LaunchImpossibleException("Agent must have a JobClassLoader");
        }
        if (!a.getName().startsWith(String.valueOf(a.getType()) + "." + a.getJob() + ".")) {
            throw new LaunchImpossibleException("Bad agent name " + a.getName());
        }
        Firewall fw = this.getFirewall();
        a.setBase(fw);
        Thread thread = new Thread((Runnable)a, a.getName());
        Date time = new Date();
        AgentBox box = new AgentBox(a, thread, time, fw);
        Map map = this.boxes;
        synchronized (map) {
            this.boxes.put(a.getName(), box);
            this.fireAgentArrived(a.getName());
            a.onArrival(from, here);
        }
        this.clm.inc(a.getJob());
        thread.start();
    }

    protected String getUniqueName() {
        return String.valueOf(this.getType()) + "." + this.group + "." + System.currentTimeMillis() + "-" + System.getProperty("os.name") + "-" + System.getProperty("user.name") + "-" + ((Hashtable)System.getProperties()).hashCode();
    }

    protected Firewall getFirewall() {
        return new Firewall();
    }

    public Base(Properties c) {
        File tmp;
        this.cfg = c != null ? c : new Properties();
        this.group = this.cfg.getProperty("group", "default");
        this.name = this.getUniqueName();
        this.cfg.setProperty("group", this.group);
        this.cfg.setProperty("drm.baseName", this.name);
        String drmtmp = System.getProperty("java.io.tmpdir");
        if (drmtmp == null) {
            Logger.panic(this.getClass().getName(), "No tmp dir is defined in java.io.tmpdir", null);
            System.exit(1);
        }
        if (!(tmp = new File(drmtmp).getAbsoluteFile()).isDirectory() && !tmp.mkdirs() || !tmp.canRead() || !tmp.canWrite()) {
            Logger.panic(this.getClass().getName(), "Can't use " + tmp + " as working directory", null);
            System.exit(1);
        }
        this.clm = new ClassLoaderManager(tmp);
    }

    public static String getBaseName(InetAddress h, int p, String grp, int tout) {
        String answer = null;
        Connection c = null;
        try {
            c = new Connection(new Address(h, p, "?"), grp, 123, tout);
            answer = (String)c.ois.readObject();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return answer;
    }

    public synchronized int goOnline(int portFrom, int portTo) {
        int i = portFrom;
        while (!this.isOnline() && i <= portTo) {
            try {
                this.serverSocket = new ServerSocket(i);
                this.listenThread = new ListenThread();
                this.listenThread.start();
                this.port = i;
                Logger.debug(String.valueOf(this.getClass().getName()) + "#goOnline", "port " + this.port + ", " + this.name);
            }
            catch (BindException bindException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++i;
        }
        if (!this.isOnline()) {
            return -1;
        }
        try {
            if (this.boxes.get(this.name) == null) {
                this.addAgent(this, null, null);
            }
        }
        catch (LaunchImpossibleException e) {
            Logger.panic(String.valueOf(this.getClass().getName()) + "#goOnline", null, e);
            System.exit(1);
        }
        return this.port;
    }

    public synchronized void goOffline() {
        if (!this.isOnline()) {
            return;
        }
        String logSender = String.valueOf(this.getClass().getName()) + "#goOffline";
        try {
            Logger.debug(logSender, "Closing server socket... ");
            this.listenThread.shouldLive = false;
            this.listenThread.join();
            this.port = -1;
            Logger.debug(logSender, "Server socket closed");
        }
        catch (InterruptedException e) {
            Logger.error(logSender, null, e);
        }
    }

    public void close() {
        this.goOffline();
        Iterator i = this.getNames().iterator();
        while (i.hasNext()) {
            String n = (String)i.next();
            if (n.equals(this.name)) continue;
            this.destroyAgent(n);
        }
        this.clm.cleanup(0L);
        this.boxes = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IBaseListener l) {
        List list = this.baseListeners;
        synchronized (list) {
            if (this.baseListeners.contains(l)) {
                return;
            }
            this.baseListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IBaseListener l) {
        List list = this.baseListeners;
        synchronized (list) {
            this.baseListeners.remove(l);
        }
    }

    public synchronized void wipeClean(final long time) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Map map = Base.this.boxes;
                synchronized (map) {
                    ListenThread listenThread = Base.this.listenThread;
                    synchronized (listenThread) {
                        String n2;
                        int oldPort = Base.this.port;
                        boolean wasOnline = Base.this.isOnline();
                        Base.this.goOffline();
                        Iterator i = Base.this.getNames().iterator();
                        while (i.hasNext()) {
                            n2 = (String)i.next();
                            if (n2.equals(Base.this.name)) continue;
                            Base.this.destroyAgent(n2);
                        }
                        Base.this.clm.cleanup(0L);
                        try {
                            Thread.sleep(time);
                        }
                        catch (InterruptedException n2) {
                            // empty catch block
                        }
                        i = Base.this.getNames().iterator();
                        while (i.hasNext()) {
                            n2 = (String)i.next();
                            if (n2.equals(Base.this.name)) continue;
                            Base.this.destroyAgent(n2);
                        }
                        Base.this.clm.cleanup(0L);
                        if (wasOnline) {
                            Base.this.goOnline(oldPort, oldPort + 10);
                        }
                    }
                }
            }
        }.start();
    }

    public boolean handleMessage(Message m, Object object) {
        return false;
    }

    public void onArrival(Address from, Address to) {
    }

    public final void onDestruction() {
        this.close();
        Logger.panic(String.valueOf(this.getClass().getName()) + "#onDestruction", null, null);
        System.exit(1);
    }

    public final String getName() {
        return this.name;
    }

    public String getJob() {
        return this.group;
    }

    public String getType() {
        return "Base";
    }

    public final void setBase(IBase b) {
        if (!(b instanceof Firewall)) {
            Logger.panic(String.valueOf(this.getClass().getName()) + "#setBase", null, null);
            System.exit(1);
        }
    }

    public final int version() {
        return 200000;
    }

    public final void run() {
        while (this.boxes != null) {
            if (this.isOnline()) {
                this.clm.cleanup(60000L);
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {}
            } else {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Thread.yield();
        }
    }

    public String getProperty(String prop) {
        return this.cfg.getProperty(prop);
    }

    public IRequest launch(String method, final IAgent a, Object par) {
        Address destination;
        if (method == null || !method.equals("DIRECT") || a == null || par != null && !(par instanceof Address)) {
            throw new IllegalArgumentException();
        }
        Address address = destination = par != null ? (Address)par : null;
        if (destination == null || destination.isLocal()) {
            try {
                this.addAgent(a, null, null);
            }
            catch (Throwable t) {
                return new StaticRequest(2, t);
            }
            return new StaticRequest(1, null);
        }
        return (IRequest)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SendAgentThread t = new SendAgentThread(a, destination);
                t.start();
                return t;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getNames() {
        Map map = this.boxes;
        synchronized (map) {
            return new HashSet(this.boxes.keySet());
        }
    }

    public boolean isOnline() {
        return this.port != -1 && this.listenThread != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroyAgent(String n) {
        AgentBox box = (AgentBox)this.boxes.get(n);
        if (box == null) {
            return;
        }
        Map map = this.boxes;
        synchronized (map) {
            box.agent.onDestruction();
            this.clm.dec(box.agent.getJob());
            this.boxes.remove(n);
            this.fireAgentDestroyed(box.agent.getName());
        }
        try {
            box.thread.join(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((Firewall)box.baseFirewall).close();
    }

    public final IRequest dispatchAgent(String n, final Address to) {
        if (to.name.equals(this.name) || to.isLocal()) {
            return new StaticRequest(2, new LaunchImpossibleException("Cannot dispatch to local address"));
        }
        AgentBox box = (AgentBox)this.boxes.get(n);
        if (box == null) {
            return new StaticRequest(2, new LaunchImpossibleException("Agent is not in the base"));
        }
        final IAgent a = box.agent;
        Logger.debug(String.valueOf(this.getClass().getName()) + "#dispatchAgent", "Destination: " + to.getHost());
        return (IRequest)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SendAgentThread t = new SendAgentThread(a, to, true);
                t.start();
                return t;
            }
        });
    }

    public IRequest fireMessage(final Message m) {
        if (m == null || m.getRecipient() == null) {
            return new StaticRequest(2, null);
        }
        if (m.getRecipient().isLocal()) {
            try {
                AgentBox box = null;
                boolean mHandled = false;
                if (!this.name.equals(m.getRecipient().name)) {
                    box = (AgentBox)this.boxes.get(m.getRecipient().name);
                    if (box != null && box.agent != null) {
                        mHandled = box.agent.handleMessage(m, AgentInputStream.getObject(m.getBinary(), box.agent));
                    } else {
                        Logger.error(String.valueOf(this.getClass().getName()) + "#fireMessage", "No local agent " + m.getRecipient().name, null);
                    }
                } else {
                    mHandled = this.handleMessage(m, AgentInputStream.getObject(m.getBinary(), null));
                }
                HashMap<String, Object> tmpMap = null;
                if (m.reply != null) {
                    tmpMap = new HashMap<String, Object>();
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(bos);
                    oos.writeObject(m.reply);
                    oos.flush();
                    tmpMap.put("reply", AgentInputStream.getObject(bos.toByteArray(), m.reply));
                }
                return new StaticRequest(mHandled ? 1 : 2, null, tmpMap);
            }
            catch (Exception e) {
                return new StaticRequest(2, e);
            }
        }
        return (IRequest)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SendMessageThread t = new SendMessageThread(m);
                AgentBox box = (AgentBox)Base.this.boxes.get(m.getSender().name);
                t.setContextClassLoader(box.agent.getClass().getClassLoader());
                t.start();
                return t;
            }
        });
    }

    private class ConnectionHandler
    extends Thread {
        private Socket socket;
        private AgentInputStream ais = null;
        private ObjectOutputStream oos = null;
        private int version;
        private final int SOTIMEOUT = 30000;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void receiveAgent() throws IOException, ClassNotFoundException {
            ClassLoaderManager classLoaderManager = Base.this.clm;
            synchronized (classLoaderManager) {
                Logger.debug(this.getClass().getName(), "an AGENT arrived");
                String to = (String)this.ais.readObject();
                if (to == null || !to.equals(Base.this.name)) {
                    this.oos.writeByte(102);
                    this.oos.flush();
                    Logger.warning(this.getClass().getName(), "AGENT rejected: I'm not " + to, null);
                    return;
                }
                this.oos.writeByte(101);
                this.oos.flush();
                String cname = (String)this.ais.readObject();
                if (Base.this.clm.getLoader(cname) != null) {
                    this.oos.writeByte(101);
                } else {
                    this.oos.writeByte(100);
                    this.oos.flush();
                    Base.this.clm.putLoader(cname, this.ais);
                    this.oos.writeByte(101);
                }
                this.ais.setClassLoader(Base.this.clm.getLoader(cname));
                try {
                    this.oos.flush();
                    IAgent a = (IAgent)this.ais.readObject();
                    Address from = (Address)this.ais.readObject();
                    from.host = this.socket.getInetAddress();
                    Base.this.addAgent(a, from, new Address(this.socket.getLocalAddress(), this.socket.getLocalPort(), Base.this.name));
                }
                catch (Throwable e) {
                    this.oos.writeByte(102);
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    if (e instanceof ClassNotFoundException) {
                        throw (ClassNotFoundException)e;
                    }
                    Logger.error(this.getClass().getName(), "", e);
                    return;
                }
                this.oos.writeByte(101);
            }
        }

        private void receiveMessage() throws IOException, ClassNotFoundException {
            AgentBox box;
            Logger.debug(this.getClass().getName(), "a MESSAGE arrived");
            String to = (String)this.ais.readObject();
            IAgent rec = null;
            boolean mHandled = false;
            if (to != null && (box = (AgentBox)Base.this.boxes.get(to)) != null) {
                rec = box.agent;
            }
            if (rec == null) {
                this.oos.writeByte(102);
                Logger.debug(this.getClass().getName(), String.valueOf(to) + " is not here");
            } else {
                this.oos.writeByte(101);
                this.oos.flush();
                Message m = (Message)this.ais.readObject();
                m.sender.host = this.socket.getInetAddress();
                try {
                    mHandled = rec.handleMessage(m, AgentInputStream.getObject(m.getBinary(), rec));
                }
                catch (Exception e) {
                    this.oos.writeByte(102);
                    Logger.error(this.getClass().getName(), "Handling the message " + m.toString() + " raised an Exception", e);
                }
                if (!mHandled) {
                    this.oos.writeByte(102);
                } else if (m.reply != null) {
                    this.oos.writeByte(0);
                    this.oos.writeObject(m.reply);
                } else {
                    this.oos.writeByte(101);
                }
            }
        }

        private void receiveIsAlive() throws IOException {
            Logger.debug(this.getClass().getName(), "an ISALIVE arrived");
            this.oos.writeObject(Base.this.name);
        }

        public ConnectionHandler(Socket socket) {
            super("ConnectionHandler");
            this.socket = socket;
        }

        public void run() {
            byte type;
            String peerGroup = null;
            try {
                Logger.debug(this.getClass().getName(), "Connection from " + this.socket.getInetAddress());
                this.socket.setSoTimeout(30000);
                this.ais = new AgentInputStream(this.socket.getInputStream(), null);
                this.version = this.ais.readInt();
                peerGroup = (String)this.ais.readObject();
                type = this.ais.readByte();
                this.oos = new ObjectOutputStream(this.socket.getOutputStream());
            }
            catch (SocketException e) {
                Logger.error(this.getClass().getName(), "Exception caught when setting socket timeout: ", e);
                return;
            }
            catch (IOException e) {
                Logger.error(this.getClass().getName(), "Exception caught when reading data from a socket", e);
                return;
            }
            catch (ClassNotFoundException e) {
                Logger.error(this.getClass().getName(), "I got a non-String as peerGroup: ", e);
                return;
            }
            try {
                if (peerGroup == null || !peerGroup.equals(Base.this.group)) {
                    this.oos.writeInt(-1);
                    this.oos.flush();
                    throw new ProtocolException("Peer is from group " + peerGroup + ", our group is " + Base.this.group);
                }
                if (this.version != 2) {
                    this.oos.writeInt(-1);
                    this.oos.flush();
                    throw new ProtocolException("Peer is using protocol version " + this.version + ", our version is " + 2);
                }
                this.oos.writeInt(2);
                this.oos.flush();
            }
            catch (ProtocolException e) {
                Logger.error(this.getClass().getName(), "", e);
                return;
            }
            catch (IOException e) {
                Logger.error(this.getClass().getName(), "Exception caught when writing data to a socket: ", e);
                return;
            }
            try {
                switch (type) {
                    case 1: {
                        this.receiveAgent();
                        break;
                    }
                    case 0: {
                        this.receiveMessage();
                        break;
                    }
                    case 123: {
                        this.receiveIsAlive();
                        break;
                    }
                    default: {
                        throw new ProtocolException("Bad header, type not recognized");
                    }
                }
            }
            catch (Exception e) {
                Logger.error(this.getClass().getName(), "Exception caught when receiving an agent or message: ", e);
            }
            try {
                if (this.oos != null) {
                    this.oos.flush();
                    this.oos.close();
                }
                if (this.ais != null) {
                    this.ais.close();
                }
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException e) {
                Logger.error(this.getClass().getName(), "Exception caught when closing the socket: ", e);
            }
        }
    }

    private class ListenThread
    extends Thread {
        private Socket socket = null;
        volatile boolean shouldLive = true;

        public ListenThread() {
            super("ListenThread");
        }

        public void run() {
            try {
                Base.this.serverSocket.setSoTimeout(100);
            }
            catch (SocketException e) {
                Logger.panic(this.getClass().getName(), null, e);
                System.exit(1);
            }
            while (this.shouldLive) {
                try {
                    this.socket = Base.this.serverSocket.accept();
                    new ConnectionHandler(this.socket).start();
                    Thread.yield();
                }
                catch (InterruptedIOException e) {
                }
                catch (IOException e) {
                    Logger.error(this.getClass().getName(), null, e);
                }
            }
            try {
                Base.this.serverSocket.close();
            }
            catch (IOException e) {
                Logger.panic(this.getClass().getName(), null, e);
                System.exit(1);
            }
            Base.this.serverSocket = null;
        }
    }

    private class SendMessageThread
    extends Thread
    implements IRequest {
        private Message m;
        private int status = 0;
        private Throwable thr = null;
        private final long startTime;
        private Object reply;

        public int getStatus() {
            return this.status;
        }

        public Throwable getThrowable() {
            return this.thr;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public Object getInfo(String q) {
            if (q != null && q.equals("reply")) {
                return this.reply;
            }
            return null;
        }

        public SendMessageThread(Message mess) {
            super("SendMessage-" + mess.getType());
            this.m = mess;
            this.m.sender = new Address(null, Base.this.port, this.m.sender.name);
            this.startTime = System.currentTimeMillis();
        }

        public void run() {
            if (!Base.this.isOnline()) {
                this.status = 2;
                this.thr = new IOException("Base is offline");
                this.m = null;
                return;
            }
            Connection c = null;
            try {
                c = new Connection(this.m.getRecipient(), Base.this.group, 0, this.getContextClassLoader());
                c.oos.writeObject(this.m.recipient.name);
                c.oos.flush();
                int b = c.ois.readByte();
                if (b == 101) {
                    c.oos.writeObject(this.m);
                    c.oos.flush();
                    b = c.ois.readByte();
                    if (b == 0) {
                        this.reply = c.ois.readObject();
                        b = 101;
                    }
                }
                if (b != 101) {
                    this.status = 2;
                }
            }
            catch (Throwable e) {
                if (e instanceof ConnectException) {
                    Logger.debug(this.getClass().getName(), "Message not delivered. Destination unreachable.\n" + this.m);
                } else {
                    Logger.error(this.getClass().getName(), "Message not delivered.\n" + this.m, e);
                }
                this.thr = e;
                this.status = 2;
            }
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (IOException e) {
                Logger.error(this.getClass().getName(), "Exception when closing a connection to " + this.m.getRecipient() + ": ", e);
                this.thr = e;
                this.status = 2;
            }
            if (this.status != 2) {
                this.status = 1;
            }
            this.m = null;
        }
    }

    private class SendAgentThread
    extends Thread
    implements IRequest {
        private IAgent a;
        private Address to;
        private int status = 0;
        private Throwable thr = null;
        private final long startTime;
        private final boolean destroy;

        private void sendJAR(Connection c) throws IOException {
            File f = ((JobClassLoader)this.a.getClass().getClassLoader()).file;
            Logger.debug(this.getClass().getName(), "sending " + f);
            if (f.isFile()) {
                c.oos.writeInt((int)f.length());
                c.oos.flush();
                FileInputStream jaris = new FileInputStream(f);
                byte[] buff = new byte[1000];
                int n = ((InputStream)jaris).read(buff);
                while (n != -1) {
                    c.oos.write(buff, 0, n);
                    n = ((InputStream)jaris).read(buff);
                }
                c.oos.flush();
                ((InputStream)jaris).close();
            } else {
                c.oos.writeInt(-2);
                c.oos.writeObject(f);
                c.oos.flush();
            }
            c.ois.readByte();
            Logger.debug(this.getClass().getName(), "done sending " + f);
        }

        public int getStatus() {
            return this.status;
        }

        public Throwable getThrowable() {
            return this.thr;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public Object getInfo(String q) {
            return null;
        }

        public SendAgentThread(IAgent a, Address to, boolean destroy) {
            super("SendAgent");
            if (!(a.getClass().getClassLoader() instanceof JobClassLoader)) {
                throw new IllegalArgumentException("Agent must have a JobClassLoader");
            }
            this.a = a;
            this.to = to;
            this.destroy = destroy;
            this.startTime = System.currentTimeMillis();
        }

        public SendAgentThread(IAgent a, Address to) {
            this(a, to, false);
        }

        public void run() {
            if (!Base.this.isOnline()) {
                this.status = 2;
                this.thr = new IOException("Base is offline");
                this.a = null;
                return;
            }
            byte reply = 0;
            Connection c = null;
            try {
                c = new Connection(this.to, Base.this.group, 1);
                c.oos.writeObject(this.to.name);
                c.oos.flush();
                reply = c.ois.readByte();
                Logger.debug(this.getClass().getName(), "recipient found: " + reply);
                if (reply == 102) {
                    throw new ConnectException("Node not found at " + this.to);
                }
                c.oos.writeObject(this.a.getJob());
                c.oos.flush();
                reply = c.ois.readByte();
                Logger.debug(this.getClass().getName(), "return status: " + reply);
                if (reply == 100) {
                    this.sendJAR(c);
                }
                c.oos.writeObject(this.a);
                c.oos.writeObject(new Address(null, Base.this.port, Base.this.name));
                c.oos.flush();
                reply = c.ois.readByte();
            }
            catch (Throwable e) {
                if (e instanceof ConnectException) {
                    Logger.debug(this.getClass().getName(), "Agent to " + this.to + " not delivered. Destination unreachable.");
                } else {
                    Logger.error(this.getClass().getName(), "Agent to " + this.to + " not delivered.", e);
                }
                this.thr = e;
                this.status = 2;
            }
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (Throwable e) {
                Logger.error(this.getClass().getName(), "Exception when closing a connection for " + this.to, e);
                this.thr = e;
                this.status = 2;
            }
            if (reply != 101) {
                this.status = 2;
            }
            if (this.status != 2) {
                this.status = 1;
                if (this.destroy) {
                    Base.this.destroyAgent(this.a.getName());
                }
            }
            this.a = null;
            this.to = null;
        }
    }

    protected class Firewall
    implements IBase {
        protected IBase b;

        protected Firewall() {
            this.b = Base.this;
        }

        public void close() {
            this.b = null;
        }

        public final String getProperty(String p) {
            return this.b.getProperty(p);
        }

        public final Set getNames() {
            return this.b.getNames();
        }

        public final void destroyAgent(String name) {
            this.b.destroyAgent(name);
        }

        public final IRequest dispatchAgent(String name, Address dest) {
            return this.b.dispatchAgent(name, dest);
        }

        public final IRequest launch(String method, IAgent a, Object par) {
            return this.b.launch(method, a, par);
        }

        public final IRequest fireMessage(Message m) {
            return this.b.fireMessage(m);
        }

        public final boolean isOnline() {
            return this.b.isOnline();
        }
    }
}

