/*
 * Decompiled with CFR 0.152.
 */
package drm.core;

import drm.agentbase.Address;
import drm.agentbase.IRequest;
import drm.agentbase.Logger;
import drm.agentbase.Message;
import drm.core.ContributionBox;
import drm.core.Contributor;
import drm.core.Controller;
import drm.core.Observer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public final class Collective
implements Runnable,
Serializable {
    static final long serialVersionUID = 1L;
    private transient Map cache = new Hashtable();
    private transient ContributionBox myContribution = null;
    private transient List cacheCollection = null;
    private transient Map commands = new Hashtable();
    private transient List commandCollection = null;
    private transient Observer observer;
    private transient Contributor contributor;
    private transient Controller controller;
    private volatile transient boolean shouldLive = true;
    private transient String name;
    public static final long REFRESHRATE = 10000L;
    public static final long MAX_CACHE_SIZE = 5L;
    public static final long MAX_COMMANDS_SIZE = 100L;
    public static final long COMMAND_TIMEOUT = 60000L;
    public static final long CONTRIBUTION_TIMEOUT = 250000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        Map map = this.cache;
        synchronized (map) {
            Map map2 = this.commands;
            synchronized (map2) {
                out.writeObject(this.name);
                out.writeLong(System.currentTimeMillis());
                out.writeObject(this.myContribution);
                out.writeInt(this.cache.size());
                Iterator<Object> i = this.cache.values().iterator();
                while (i.hasNext()) {
                    out.writeObject(i.next());
                }
                out.writeInt(this.commands.size());
                i = this.commands.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry e = (Map.Entry)i.next();
                    long time = (Long)e.getValue();
                    out.writeObject(e.getKey());
                    out.writeLong(time);
                }
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.name = (String)in.readObject();
        this.cache = new Hashtable();
        this.commands = new Hashtable();
        long max = in.readLong();
        long diff = System.currentTimeMillis() - max;
        this.myContribution = (ContributionBox)in.readObject();
        if (this.myContribution != null) {
            this.myContribution.timeStamp = max + diff;
        }
        int cachesize = in.readInt();
        int i = 0;
        while (i < cachesize) {
            ContributionBox cb = (ContributionBox)in.readObject();
            if (cb.timeStamp > max) {
                throw new IOException("corrupted timestamp in cache: " + cb.timeStamp + " " + max);
            }
            cb.timeStamp += diff;
            this.cache.put(cb.contributor.name, cb);
            ++i;
        }
        int commandssize = in.readInt();
        int i2 = 0;
        while (i2 < commandssize) {
            Object comm = in.readObject();
            long time = in.readLong();
            if (time > max) {
                throw new IOException("corrupted timestamp in commands: " + time + " " + max);
            }
            this.commands.put(comm, new Long(time += diff));
            ++i2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void merge(Collective peer) {
        Iterator<Object> i;
        Map map = this.cache;
        synchronized (map) {
            i = peer.cache.values().iterator();
            while (i.hasNext()) {
                ContributionBox cb = (ContributionBox)i.next();
                ContributionBox x = (ContributionBox)this.cache.get(cb.contributor.name);
                if (x != null && x.timeStamp >= cb.timeStamp) continue;
                this.cache.put(cb.contributor.name, cb);
            }
        }
        map = this.commands;
        synchronized (map) {
            i = peer.commands.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = (Map.Entry)i.next();
                Comparable time = (Comparable)this.commands.get(e.getKey());
                if (time != null && time.compareTo(e.getValue()) >= 0) continue;
                this.commands.put(e.getKey(), e.getValue());
            }
        }
        this.cutToSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOldStuff() {
        Iterator i;
        long current = System.currentTimeMillis();
        Map map = this.cache;
        synchronized (map) {
            i = this.cache.values().iterator();
            while (i.hasNext()) {
                ContributionBox cb = (ContributionBox)i.next();
                if (current - cb.timeStamp <= 250000L) continue;
                i.remove();
            }
        }
        map = this.commands;
        synchronized (map) {
            i = this.commands.values().iterator();
            while (i.hasNext()) {
                Long t = (Long)i.next();
                if (current - t <= 60000L) continue;
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cutToSize() {
        Vector keyList;
        Map map;
        if (5L < (long)this.cache.size()) {
            map = this.cache;
            synchronized (map) {
                keyList = new Vector(this.cache.keySet());
                Collections.shuffle(keyList);
                while (5L < (long)this.cache.size()) {
                    this.cache.remove(keyList.get(0));
                    keyList.remove(0);
                }
            }
        }
        if (100L < (long)this.commands.size()) {
            map = this.commands;
            synchronized (map) {
                keyList = new Vector(this.commands.keySet());
                Collections.shuffle(keyList);
                while (100L < (long)this.commands.size()) {
                    this.commands.remove(keyList.get(0));
                    keyList.remove(0);
                }
            }
        }
    }

    private synchronized void updateLocalInfo() {
        if (this.contributor != null) {
            this.myContribution = new ContributionBox(new Address(this.contributor.getName()), this.contributor.getContribution());
        }
        Long now = new Long(System.currentTimeMillis());
        if (this.controller != null) {
            Set newcomms = this.controller.getCommands();
            if (newcomms == null) {
                return;
            }
            Iterator i = newcomms.iterator();
            while (i.hasNext()) {
                this.commands.put(i.next(), now);
            }
        }
    }

    private static void repairSenderAddress(Collective c, Address sender) {
        if (c.myContribution != null) {
            c.cache.put(c.myContribution.contributor.name, new ContributionBox(new Address(sender.getHost(), sender.port, c.myContribution.contributor.name), c.myContribution.timeStamp, c.myContribution.contribution));
        } else {
            Logger.warning("Collective#repairSenderAddress()", "Update doesn't contain contribution of sender " + sender, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean refresh() {
        String logSender = this.observer + "#refresh";
        String contrName = this.contributor != null ? this.contributor.getName() : null;
        this.updateLocalInfo();
        Vector peers = null;
        Map map = this.cache;
        synchronized (map) {
            peers = new Vector(this.cache.values());
            if (contrName != null) {
                peers.remove(this.cache.get(contrName));
            }
        }
        Collections.shuffle(peers);
        if (peers.isEmpty()) {
            Logger.debug(logSender, "no peers in cache");
            return false;
        }
        this.cacheCollection = null;
        this.commandCollection = null;
        IRequest answer = null;
        Address peer = null;
        int i = 0;
        while (i < peers.size()) {
            if (!this.shouldLive) {
                return false;
            }
            peer = ((ContributionBox)peers.get((int)i)).contributor;
            Logger.debug(logSender, "asking " + peer);
            answer = this.observer.fireMessage(peer, "collectiveUpdate-" + this.name, this);
            while (answer.getStatus() == 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (answer.getStatus() == 1) break;
            Logger.debug(logSender, "not accessable: " + peer);
            ++i;
        }
        if (answer.getStatus() != 1) {
            Logger.debug(logSender, "no accessable peers");
            this.observer.collectiveUpdated(null);
            return false;
        }
        Collective c = (Collective)answer.getInfo("reply");
        if (this.contributor != null) {
            this.cache.remove(this.contributor.getName());
            c.cache.remove(this.contributor.getName());
        }
        this.cache.remove(peer.name);
        c.cache.remove(peer.name);
        Collective.repairSenderAddress(c, peer);
        this.merge(c);
        this.observer.collectiveUpdated((ContributionBox)this.cache.get(c.myContribution.contributor.name));
        return true;
    }

    public Collective(String name, Observer o) {
        this(name, o, null, null);
    }

    public Collective(String name, Observer o, Contributor c) {
        this(name, o, c, null);
    }

    public Collective(String name, Observer o, Controller c) {
        this(name, o, null, c);
    }

    public Collective(String name, Observer o, Contributor cb, Controller c) {
        if (o == null) {
            throw new IllegalArgumentException("null observer");
        }
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        this.name = name;
        this.observer = o;
        this.controller = c;
        this.contributor = cb;
    }

    public Collective(Collective c, Observer o, Contributor cb, Controller cr) {
        this(c.name, o, cb, cr);
        if (c == null) {
            throw new IllegalArgumentException("null collective");
        }
        if (c.cache != null) {
            this.cache.putAll(c.cache);
        }
        if (c.commands != null) {
            this.commands.putAll(c.commands);
        }
        if (this.contributor != null) {
            this.cache.remove(this.contributor.getName());
        }
    }

    public void close() {
        this.shouldLive = false;
    }

    public boolean handleMessage(Message m, Object o) {
        if (!this.shouldLive || !m.getType().equals("collectiveUpdate-" + this.name)) {
            return false;
        }
        String logSender = this.observer + "#collectiveUpdate";
        Logger.debug(logSender, "Update from " + m.getSender());
        if (!m.getRecipient().name.equals(this.contributor.getName())) {
            Logger.warning(logSender, "Recipient and my contributor are not the same:\nRecipient: " + m.getRecipient().name + "\n" + "Contributor: " + this.contributor.getName(), null);
        }
        Collective c = (Collective)o;
        this.cacheCollection = null;
        this.commandCollection = null;
        this.cache.remove(m.getRecipient().name);
        c.cache.remove(m.getRecipient().name);
        this.cache.remove(m.getSender().name);
        c.cache.remove(m.getSender().name);
        if (this.contributor == null) {
            Logger.warning(logSender, "Non-contributor observer is known by " + m.getSender(), null);
        }
        this.updateLocalInfo();
        m.setReply(this);
        Collective.repairSenderAddress(c, m.getSender());
        this.merge(c);
        this.observer.collectiveUpdated((ContributionBox)this.cache.get(m.getSender().name));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        block5: while (this.shouldLive) {
            Address[] a;
            System.gc();
            this.removeOldStuff();
            if (!this.refresh() && (a = this.observer.getPeerAddresses()) != null) {
                Map map = this.cache;
                synchronized (map) {
                    int i = 0;
                    while (i < a.length) {
                        this.cache.put(a[i].name, new ContributionBox(a[i], null));
                        ++i;
                    }
                }
            }
            int i = 0;
            while ((long)i < 10000L) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    this.shouldLive = false;
                }
                if (!this.shouldLive) continue block5;
                Thread.yield();
                i += 1000;
            }
        }
        this.cache = null;
        this.observer = null;
    }

    public void addPeerAddress(Address a) {
        if (a == null) {
            return;
        }
        ContributionBox b = (ContributionBox)this.cache.remove(a.name);
        if (b != null) {
            this.cache.put(a.name, new ContributionBox(a, b.timeStamp, b.contribution));
        } else {
            this.cache.put(a.name, new ContributionBox(a, null));
        }
    }

    public ContributionBox getContribution(String name) {
        return (ContributionBox)this.cache.get(name);
    }

    public synchronized List getContributions() {
        List o = this.cacheCollection;
        if (o == null) {
            this.cacheCollection = o = Collections.unmodifiableList(new ArrayList(this.cache.values()));
        }
        return o;
    }

    public synchronized List getCommands() {
        List o = this.commandCollection;
        if (o == null) {
            this.commandCollection = o = Collections.unmodifiableList(new ArrayList(this.commands.keySet()));
        }
        return o;
    }

    public String toString() {
        return this.myContribution + "\n" + this.cache + "\n" + this.commands;
    }
}

