/*
 * Decompiled with CFR 0.152.
 */
package drm.server;

import drm.agentbase.ILogListener;
import java.util.Date;

public class ConsoleLogger
implements ILogListener {
    public int verbosity = 10;

    public void handleLogMessage(int type, String sender, String comment, Throwable thr) {
        String s1 = new Date() + " " + (sender == null ? "" : sender);
        String s2 = comment == null ? "" : comment;
        String s3 = thr == null ? "" : thr.toString();
        switch (type) {
            case 0: {
                if (this.verbosity > 0) {
                    System.err.print("PANIC! ");
                    System.err.println(String.valueOf(s1) + ": " + s2 + " " + s3);
                    break;
                }
            }
            case 1: {
                if (this.verbosity > 1) {
                    System.err.print("ERROR! ");
                    System.err.println(String.valueOf(s1) + ": " + s2 + " " + s3);
                    break;
                }
            }
            case 2: {
                if (this.verbosity > 2) {
                    System.err.print("WARNING! ");
                    System.err.println(String.valueOf(s1) + ": " + s2 + " " + s3);
                    break;
                }
            }
            default: {
                if (this.verbosity <= 3) break;
                System.out.println(String.valueOf(s1) + ": " + s2 + " " + s3);
            }
        }
        if (this.verbosity > 9 && thr != null) {
            thr.printStackTrace();
        }
    }
}

