/*
 * Decompiled with CFR 0.152.
 */
package drm.server;

import drm.agentbase.JobClassLoader;
import drm.agentbase.Logger;
import drm.core.Node;
import drm.server.ConsoleLogger;
import drm.server.ScriptUtils;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Properties;

public class NewNode {
    public static volatile Node s = null;
    public static ConsoleLogger cl = new ConsoleLogger();

    private static void startScript(String scriptName, Node startOn, String[] args) throws ClassNotFoundException, NoSuchMethodException, Exception {
        Logger.debug("NewNode#startScript", "Starting '" + scriptName + "'");
        Class<?> result = null;
        String fileName = null;
        String className = "Launch";
        JobClassLoader jcl = null;
        int bound = scriptName.indexOf(33);
        if (bound != -1) {
            fileName = scriptName.substring(0, bound);
            className = scriptName.substring(bound + 1);
        } else {
            fileName = scriptName;
        }
        jcl = new JobClassLoader(new File(fileName));
        result = Class.forName(className, true, jcl);
        if (!(result.getClassLoader() instanceof JobClassLoader)) {
            throw new Exception("class " + className + " should not be in class path");
        }
        Class[] pars = new Class[]{startOn.getClass(), args.getClass()};
        Constructor<?> cons = result.getConstructor(pars);
        Object[] objpars = new Object[]{startOn, args};
        Runnable script = (Runnable)cons.newInstance(objpars);
        new Thread(script).start();
    }

    public static void main(String[] args) {
        Properties cfg = new Properties();
        String[] nodeargs = new String[]{};
        Logger.addListener(cl);
        NewNode.cl.verbosity = 4;
        int port = 10101;
        String scriptName = null;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                if (s != null) {
                    s.close();
                }
            }
        });
        int a = 0;
        while (a < args.length) {
            if (args[a].equals("--verbosity") || args[a].equals("-v")) {
                Logger.debug("NewNode", "verbosity " + args[a + 1]);
                cfg.setProperty("verbosity", "" + NewNode.cl.verbosity);
                NewNode.cl.verbosity = Integer.parseInt(args[a + 1]);
                a += 2;
                continue;
            }
            if (args[a].equals("--port") || args[a].equals("-p")) {
                Logger.debug("NewNode", "port " + args[a + 1]);
                cfg.setProperty("port", "" + Integer.parseInt(args[a + 1]));
                port = Integer.parseInt(args[a + 1]);
                a += 2;
                continue;
            }
            if (args[a].equals("--group") || args[a].equals("-g")) {
                Logger.debug("NewNode", "group " + args[a + 1]);
                cfg.setProperty("group", args[a + 1]);
                a += 2;
                continue;
            }
            if (args[a].equals("--cachesize") || args[a].equals("-c")) {
                Logger.debug("NewNode", "cache size " + args[a + 1]);
                cfg.setProperty("cachesize", "" + Integer.parseInt(args[a + 1]));
                a += 2;
                continue;
            }
            if (args[a].equals("--node") || args[a].equals("-n")) {
                while (++a < args.length && !args[a].startsWith("-")) {
                    Logger.debug("NewNode", "node" + a + " " + args[a]);
                    cfg.setProperty("node" + a, args[a]);
                }
                continue;
            }
            if (args[a].equals("--runClass") || args[a].equals("-r")) {
                Logger.debug("NewNode", "runClass " + args[a + 1]);
                cfg.setProperty("scriptName", args[a + 1]);
                scriptName = args[a + 1];
                a += 2;
                continue;
            }
            if (args[a].equals("--app") || args[a].equals("-a")) {
                nodeargs = new String[args.length - a];
                System.arraycopy(args, a, nodeargs, 0, args.length - a);
                Logger.debug("NewNode", "Passing " + nodeargs.length + " arguments to " + scriptName);
                break;
            }
            if (args[a].equals("--help") || args[a].equals("-h")) {
                System.out.println("drm.server.NewNode");
                System.out.println("-v, --verbosity: Verbosity level, 0 for no output, 4 for debugging.");
                System.out.println("-g, --group:     Group name");
                System.out.println("-p, --port:      Port");
                System.out.println("-c, --cachesize: Cache size (not yet implemented)");
                System.out.println("-n, --node:      List of nodes to connect to. Use IP:PORT, spaced by blanks");
                System.out.println("-r, --runClass:  Script to be run. Use jarfile.jar!package.class");
                System.out.println("-a, --app:       Parameters after this one will be passed to the script to be run.");
                System.exit(1);
            }
            int n = ++a;
            ++a;
            Logger.error("NewNode", "Unrecognized option " + args[n] + "\nUse -h or --help for command options", null);
        }
        s = new Node(cfg);
        Logger.debug("NewNode", "Going online...");
        if (s.goOnline(port, port + 10) < 0) {
            Logger.panic("NewNode", "Could not go online", null);
            s.close();
            System.exit(1);
        }
        if (scriptName != null) {
            try {
                Thread.sleep(30000L);
                if (nodeargs.length > 0) {
                    NewNode.startScript(scriptName, s, nodeargs);
                } else {
                    ScriptUtils.startScript(scriptName, s);
                }
            }
            catch (Throwable t) {
                Logger.error("NewNode", "problems with starting configured tasks", t);
            }
        }
    }
}

