/*
 * Decompiled with CFR 0.152.
 */
package drm.server;

import drm.agentbase.JobClassLoader;
import drm.agentbase.Logger;
import drm.core.Node;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;

public abstract class ScriptUtils {
    public static void startScript(String scriptName, Node startOn) throws ClassNotFoundException, NoSuchMethodException, Exception {
        Logger.debug("ScriptUtils#startScript", "Starting '" + scriptName + "'");
        Class<?> result = null;
        String fileName = null;
        String className = "Launch";
        JobClassLoader jcl = null;
        int bound = scriptName.indexOf(33);
        if (bound != -1) {
            fileName = scriptName.substring(0, bound);
            className = scriptName.substring(bound + 1);
        } else {
            fileName = scriptName;
        }
        jcl = new JobClassLoader(new File(fileName));
        result = Class.forName(className, true, jcl);
        if (!(result.getClassLoader() instanceof JobClassLoader)) {
            throw new Exception("class " + className + " should not be in class path");
        }
        Class[] pars = new Class[]{startOn.getClass()};
        Constructor<?> cons = result.getConstructor(pars);
        Object[] objpars = new Object[]{startOn};
        Runnable script = (Runnable)cons.newInstance(objpars);
        new Thread(script).start();
    }

    public static void startAllScripts(Properties p, String keyPrefix, Node startOn) throws Exception {
        StringBuffer errorLog = new StringBuffer();
        TreeSet keys = new TreeSet(((Hashtable)p).keySet());
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            try {
                String tmp = (String)i.next();
                if (!tmp.startsWith(keyPrefix)) continue;
                ScriptUtils.startScript(p.getProperty(tmp), startOn);
            }
            catch (Exception e) {
                errorLog.append(e).append("\n");
                Logger.error("ScriptUtils#startAllScripts", "", e);
            }
        }
        if (errorLog.length() > 0) {
            throw new Exception(errorLog.toString());
        }
    }
}

