/*
 * Decompiled with CFR 0.152.
 */
package drm.server;

import drm.agentbase.Address;
import drm.agentbase.Base;
import drm.agentbase.IBaseListener;
import drm.agentbase.IRequest;
import drm.agentbase.Logger;
import drm.agentbase.Message;
import drm.core.Node;
import drm.core.NodeCommand;
import drm.server.ConsoleLogger;
import drm.server.ScriptUtils;
import drm.util.ConfigProperties;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.net.InetAddress;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TestGUINode
extends JFrame
implements ActionListener,
ListSelectionListener,
IBaseListener {
    private static final long serialVersionUID = 1L;
    private JList list;
    private DefaultListModel listModel;
    private JScrollPane listScroller;
    private String selectedAgent = null;
    private Node node;
    private Properties cfg;

    private boolean selectedOK() {
        if (this.selectedAgent != null) {
            return true;
        }
        new JOptionPane();
        JOptionPane.showMessageDialog(this, "No agent is selected!", null, 0);
        return false;
    }

    private void showError(String s) {
        String[] m = new String[(s.length() - 1) / 70 + 1];
        int i = 0;
        while (i < m.length) {
            m[i] = s.substring(i * 70, Math.min((i + 1) * 70, s.length()));
            ++i;
        }
        new JOptionPane();
        JOptionPane.showMessageDialog(this, m, null, 0);
    }

    private Address getLivingAddress() {
        String name;
        int port;
        InetAddress host;
        block11: {
            StringTokenizer st;
            block10: {
                String server;
                block9: {
                    host = null;
                    port = Integer.parseInt(this.cfg.getProperty("port", "10101"));
                    name = null;
                    JOptionPane dialog = new JOptionPane();
                    server = JOptionPane.showInputDialog(this, (Object)"Give address as host[:port[:name]]");
                    if (server != null && server.length() != 0) break block9;
                    return null;
                }
                st = new StringTokenizer(server, " :");
                if (st.countTokens() != 0) break block10;
                return null;
            }
            host = InetAddress.getByName(st.nextToken());
            if (st.hasMoreTokens()) {
                port = Integer.parseInt(st.nextToken());
            }
            if (st.hasMoreTokens()) {
                name = st.nextToken();
                break block11;
            }
            name = Base.getBaseName(host, port, this.node.group, 10000);
            if (name != null) break block11;
            this.showError(host + ":" + port + " is not alive!");
            return null;
        }
        try {
            return new Address(host, port, name);
        }
        catch (IndexOutOfBoundsException e) {
            this.showError("Use format host[:port]");
        }
        catch (NumberFormatException e) {
            this.showError("Wrong port: " + e);
        }
        catch (Exception e) {
            this.showError(e.toString());
        }
        return null;
    }

    void shutdown(int exitcode) {
        this.node.close();
        System.exit(exitcode);
    }

    void showConfig() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.cfg.store(bos, null);
            LineNumberReader lnr = new LineNumberReader(new StringReader(new String(bos.toByteArray())));
            LinkedList<String> ll = new LinkedList<String>();
            String tmp = lnr.readLine();
            if (tmp != null) {
                tmp = lnr.readLine();
            }
            while (tmp != null) {
                ll.add(tmp);
                tmp = lnr.readLine();
            }
            Object[] lines = ll.toArray();
            new JOptionPane();
            JOptionPane.showMessageDialog(this, lines, "Effective settings", -1);
        }
        catch (IOException e) {
            this.showError(e.toString());
        }
    }

    void showThreads() {
        Thread[] threads = new Thread[100];
        int tnum = Thread.currentThread().getThreadGroup().enumerate(threads);
        new JOptionPane();
        JOptionPane.showMessageDialog(this, threads, "Threads", -1);
    }

    void runScript() {
        String scr = null;
        JOptionPane dialog = new JOptionPane();
        scr = JOptionPane.showInputDialog(this, (Object)"Give class to run as\nfile[!packagename.classname]\nwhere file is a jar or a directory.");
        if (scr == null || scr.length() == 0) {
            return;
        }
        try {
            ScriptUtils.startScript(scr, this.node);
        }
        catch (NoSuchMethodException e) {
            this.showError("The class does not conform with the interface specification.");
        }
        catch (Exception e) {
            this.showError(e.toString());
        }
    }

    void editMessage() {
        String mess = null;
        String type = null;
        String content = null;
        try {
            IRequest req;
            JOptionPane dialog = new JOptionPane();
            mess = JOptionPane.showInputDialog(this, (Object)"Message");
            if (mess == null || mess.length() == 0) {
                return;
            }
            int delimiter = (mess = mess.trim()).indexOf(44);
            if (delimiter != -1) {
                type = mess.substring(0, delimiter);
                content = mess.substring(delimiter + 1);
            } else {
                type = mess;
            }
            Address to = null;
            if (this.selectedAgent == null) {
                to = this.getLivingAddress();
                if (to == null) {
                    return;
                }
            } else {
                to = new Address(this.selectedAgent);
            }
            if ((req = this.node.fireMessage(new Message(new Address(this.node.getName()), to, type, content))) instanceof Thread) {
                try {
                    ((Thread)((Object)req)).join(10000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (req.getThrowable() != null) {
                req.getThrowable().printStackTrace();
                throw req.getThrowable();
            }
            new JOptionPane();
            JOptionPane.showMessageDialog(this, "" + req.getInfo("reply"), null, 1);
        }
        catch (IndexOutOfBoundsException e) {
            this.showError("Use format messagetype[,messagecontent]");
        }
        catch (Throwable e) {
            this.showError("" + e);
        }
    }

    void editAddToNodeList() {
        Address a = this.getLivingAddress();
        if (a != null) {
            Properties p = new Properties();
            p.setProperty("node", String.valueOf(a.getHost().getHostName()) + ":" + a.port);
            this.node.addNodes(p);
        }
    }

    void editSendTo() {
        if (!this.selectedOK()) {
            return;
        }
        if (this.selectedAgent.startsWith("Node.")) {
            this.showError("Node cannot be deleted.");
            return;
        }
        try {
            Address a = this.getLivingAddress();
            if (a == null) {
                return;
            }
            IRequest req = this.node.dispatchAgent(this.selectedAgent, a);
            if (req instanceof Thread) {
                try {
                    ((Thread)((Object)req)).join(10000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (req.getThrowable() != null) {
                req.getThrowable().printStackTrace();
                throw req.getThrowable();
            }
            if (req.getStatus() != 1) {
                new JOptionPane();
                JOptionPane.showMessageDialog(this, "Sending was not succesful.\nAgent stays here.", null, 0);
            }
        }
        catch (Throwable e) {
            this.showError(e.toString());
        }
    }

    void editDestroy() {
        if (!this.selectedOK()) {
            return;
        }
        if (this.selectedAgent.startsWith("Node.")) {
            this.showError("Node cannot be deleted.");
            return;
        }
        this.node.destroyAgent(this.selectedAgent);
    }

    void createIsland() {
        this.showError("Functionality temporarily disabled");
    }

    void editCleanLocal() {
        this.node.invokeCommandLocally(new NodeCommand("cleanall"));
    }

    void editClean() {
        this.node.invokeCommand(new NodeCommand("cleanall"));
    }

    public TestGUINode(Properties cf) {
        super("TestBAK GUI Node");
        this.cfg = cf;
        this.node = new Node(this.cfg);
        this.node.addListener(this);
        ((Component)this).setVisible(false);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menu = new JMenu("File");
        JMenuItem menuItem = new JMenuItem("Run...", 114);
        menuItem.setActionCommand("runScript");
        menuItem.addActionListener(this);
        menuItem.registerKeyboardAction(this, "runScript", KeyStroke.getKeyStroke('r'), 2);
        menu.add(menuItem);
        menuItem = new JMenuItem("Show config", 99);
        menuItem.setActionCommand("showConfig");
        menuItem.addActionListener(this);
        menuItem.registerKeyboardAction(this, "showConfig", KeyStroke.getKeyStroke('c'), 2);
        menu.add(menuItem);
        menuItem = new JMenuItem("Show threads", 84);
        menuItem.setActionCommand("showThreads");
        menuItem.addActionListener(this);
        menuItem.registerKeyboardAction(this, "showThreads", KeyStroke.getKeyStroke('T'), 2);
        menu.add(menuItem);
        menuItem = new JMenuItem("Exit", 120);
        menuItem.setActionCommand("shutdown");
        menuItem.addActionListener(this);
        menuItem.registerKeyboardAction(this, "shutdown", KeyStroke.getKeyStroke('q'), 2);
        menuItem.registerKeyboardAction(this, "shutdown", KeyStroke.getKeyStroke('x'), 2);
        menu.add(menuItem);
        menuBar.add(menu);
        menu = new JMenu("Edit");
        menuItem = new JMenuItem("Send To...", 116);
        menuItem.setActionCommand("editSendTo");
        menuItem.addActionListener(this);
        menuItem.registerKeyboardAction(this, "editSendTo", KeyStroke.getKeyStroke('t'), 2);
        menu.add(menuItem);
        menuItem = new JMenuItem("Destroy", 100);
        menuItem.setActionCommand("editDestroy");
        menuItem.addActionListener(this);
        menuItem.registerKeyboardAction(this, "editDestroy", KeyStroke.getKeyStroke('d'), 2);
        menu.add(menuItem);
        menuItem = new JMenuItem("Message...", 109);
        menuItem.setActionCommand("editMessage");
        menuItem.addActionListener(this);
        menuItem.registerKeyboardAction(this, "editMessage", KeyStroke.getKeyStroke('m'), 2);
        menu.add(menuItem);
        menuItem = new JMenuItem("Add to Node List...", 97);
        menuItem.setActionCommand("editAddToNodeList");
        menuItem.addActionListener(this);
        menuItem.registerKeyboardAction(this, "editAddToNodeList", KeyStroke.getKeyStroke('a'), 2);
        menu.add(menuItem);
        menuItem = new JMenuItem("Clean local node");
        menuItem.setActionCommand("editCleanLocal");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new JMenuItem("Clean DRM");
        menuItem.setActionCommand("editClean");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuBar.add(menu);
        menu = new JMenu("Create");
        menuItem = new JMenuItem("Island...", 105);
        menuItem.setActionCommand("createIsland");
        menuItem.addActionListener(this);
        menuItem.registerKeyboardAction(this, "createIsland", KeyStroke.getKeyStroke('i'), 2);
        menu.add(menuItem);
        menuBar.add(menu);
        JPanel panel = new JPanel();
        this.getContentPane().add(panel);
        panel.setLayout(new GridLayout(1, 1));
        panel.setPreferredSize(new Dimension(500, 300));
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(this);
        this.listScroller = new JScrollPane(this.list);
        panel.add(this.listScroller);
        int port = Integer.parseInt(this.cfg.getProperty("port", "10101"));
        this.node.goOnline(port, port + 10);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.err.println(e);
        }
        ConsoleLogger cl = new ConsoleLogger();
        Logger.addListener(cl);
        ConfigProperties cfg = new ConfigProperties(args, null);
        cl.verbosity = Integer.parseInt(cfg.getProperty("verbosity", "10"));
        TestGUINode frame = new TestGUINode(cfg);
        WindowAdapter l = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ((TestGUINode)e.getWindow()).shutdown(0);
            }
        };
        frame.addWindowListener(l);
        frame.pack();
        ((Component)frame).setLocation(10, 10);
        ((Component)frame).setVisible(true);
        try {
            Thread.currentThread();
            Thread.sleep(30000L);
            ScriptUtils.startAllScripts(cfg, "runClass", frame.node);
        }
        catch (Exception e) {
            frame.showError("While running configured experiments: " + e.toString());
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("editSendTo")) {
            this.editSendTo();
        } else if (e.getActionCommand().equals("editAddToNodeList")) {
            this.editAddToNodeList();
        } else if (e.getActionCommand().equals("editMessage")) {
            this.editMessage();
        } else if (e.getActionCommand().equals("runScript")) {
            this.runScript();
        } else if (e.getActionCommand().equals("showConfig")) {
            this.showConfig();
        } else if (e.getActionCommand().equals("showThreads")) {
            this.showThreads();
        } else if (e.getActionCommand().equals("shutdown")) {
            this.shutdown(0);
        } else if (e.getActionCommand().equals("editDestroy")) {
            this.editDestroy();
        } else if (e.getActionCommand().equals("createIsland")) {
            this.createIsland();
        } else if (e.getActionCommand().equals("editCleanLocal")) {
            this.editCleanLocal();
        } else if (e.getActionCommand().equals("editClean")) {
            this.editClean();
        }
    }

    public synchronized void valueChanged(ListSelectionEvent e) {
        int pos = this.list.getSelectedIndex();
        this.selectedAgent = pos != -1 ? (String)this.listModel.elementAt(pos) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void agentArrived(String s) {
        DefaultListModel defaultListModel = this.listModel;
        synchronized (defaultListModel) {
            this.listModel.addElement(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void agentDestroyed(String s) {
        DefaultListModel defaultListModel = this.listModel;
        synchronized (defaultListModel) {
            int pos = this.list.getSelectedIndex();
            this.listModel.removeElement(s);
            if (pos == -1) {
                this.selectedAgent = null;
            } else if (pos < this.listModel.size()) {
                this.list.setSelectedIndex(pos);
            } else if (pos > 0) {
                this.list.setSelectedIndex(pos - 1);
            } else {
                this.selectedAgent = null;
            }
            try {
                Thread.currentThread();
                Thread.sleep(20L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

