/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

import jscl.math.Debug;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegrableException;
import jscl.math.PolynomialWithSyzygy;
import jscl.math.TechnicalVariable;
import jscl.math.Variable;
import jscl.math.function.Frac;
import jscl.math.function.Inv;
import jscl.math.function.Log;
import jscl.math.function.Pow;
import jscl.math.function.Root;
import jscl.math.polynomial.Polynomial;
import jscl.math.polynomial.UnivariatePolynomial;

public class Antiderivative {
    UnivariatePolynomial factory;
    PolynomialWithSyzygy syzygy;
    Generic result;

    Antiderivative(Variable variable) {
        this.factory = (UnivariatePolynomial)Polynomial.factory(variable);
        this.syzygy = (PolynomialWithSyzygy)PolynomialWithSyzygy.factory(variable);
    }

    public static Generic compute(Frac frac, Variable variable) {
        Antiderivative s = new Antiderivative(variable);
        s.compute(frac);
        return s.getValue();
    }

    public static Generic compute(Root root, Variable variable) throws NotIntegrableException {
        int d = root.degree();
        Generic[] a = root.parameters();
        boolean b = d > 0;
        b = b && a[0].negate().isIdentity(variable);
        for (int i = 1; i < d; ++i) {
            b = b && a[i].signum() == 0;
        }
        boolean bl = b = b && a[d].compareTo(JSCLInteger.valueOf(1L)) == 0;
        if (b) {
            return new Pow(a[0].negate(), new Inv(JSCLInteger.valueOf(d)).evaluate()).antiderivative(0);
        }
        throw new NotIntegrableException();
    }

    void compute(Frac frac) {
        Debug.println("antiderivative");
        Debug.increment();
        Generic[] g = frac.parameters();
        Generic[] r = this.reduce(g[0], g[1]);
        r = this.divideAndRemainder(r[0], r[1]);
        Generic s = new Inv(r[2]).evaluate();
        Generic p = r[0].multiply(s);
        Generic a = r[1].multiply(s);
        this.result = p.antiderivative(this.factory.variable()).add(this.hermite(a, g[1]));
        Debug.decrement();
    }

    Generic[] reduce(Generic n, Generic d) {
        Debug.println("reduce(" + n + ", " + d + ")");
        Polynomial pn = this.factory.valueof(n);
        Polynomial pd = this.factory.valueof(d);
        Polynomial gcd = pn.gcd(pd);
        return new Generic[]{pn.divide(gcd).genericValue(), pd.divide(gcd).genericValue()};
    }

    Generic[] divideAndRemainder(Generic n, Generic d) {
        Debug.println("divideAndRemainder(" + n + ", " + d + ")");
        PolynomialWithSyzygy pn = this.syzygy.valueof(n, 0);
        PolynomialWithSyzygy pd = this.syzygy.valueof(d, 1);
        PolynomialWithSyzygy pr = (PolynomialWithSyzygy)((Polynomial)pn).remainderUpToCoefficient(pd);
        return new Generic[]{pr.syzygy[1].genericValue().negate(), pr.genericValue(), pr.syzygy[0].genericValue()};
    }

    Generic[] bezout(Generic a, Generic b) {
        Debug.println("bezout(" + a + ", " + b + ")");
        PolynomialWithSyzygy pa = this.syzygy.valueof(a, 0);
        PolynomialWithSyzygy pb = this.syzygy.valueof(b, 1);
        PolynomialWithSyzygy gcd = (PolynomialWithSyzygy)((Polynomial)pa).gcd(pb);
        return new Generic[]{gcd.syzygy[0].genericValue(), gcd.syzygy[1].genericValue(), gcd.genericValue()};
    }

    Generic hermite(Generic a, Generic d) {
        Debug.println("hermite(" + a + ", " + d + ")");
        UnivariatePolynomial[] sd = ((UnivariatePolynomial)this.factory.valueof(d)).squarefreeDecomposition();
        int m = sd.length - 1;
        if (m < 2) {
            return this.trager(a, d);
        }
        Generic u = sd[0].genericValue();
        for (int i = 1; i < m; ++i) {
            u = u.multiply(sd[i].genericValue().pow(i));
        }
        Generic v = sd[m].genericValue();
        Generic vprime = sd[m].derivative().genericValue();
        Generic uvprime = u.multiply(vprime);
        Generic[] r = this.bezout(uvprime, v);
        Generic b = r[0].multiply(a);
        Generic c = r[1].multiply(a);
        Generic s = r[2];
        r = this.divideAndRemainder(b, v);
        b = r[1];
        c = c.multiply(r[2]).add(r[0].multiply(uvprime));
        s = new Inv(s.multiply(r[2]).multiply(JSCLInteger.valueOf(1 - m))).evaluate();
        b = b.multiply(s);
        c = c.multiply(s);
        Generic bprime = ((UnivariatePolynomial)this.factory.valueof(b)).derivative().genericValue();
        return new Frac(b, v.pow(m - 1)).evaluate().add(this.hermite(JSCLInteger.valueOf(1 - m).multiply(c).subtract(u.multiply(bprime)), u.multiply(v.pow(m - 1))));
    }

    Generic trager(Generic a, Generic d) {
        Debug.println("trager(" + a + ", " + d + ")");
        TechnicalVariable t = new TechnicalVariable("t");
        UnivariatePolynomial pd = (UnivariatePolynomial)this.factory.valueof(d);
        UnivariatePolynomial pa = (UnivariatePolynomial)this.factory.valueof(a).subtract(pd.derivative().multiply(t.expressionValue()));
        UnivariatePolynomial[] rs = pd.remainderSequence(pa);
        Polynomial fact = UnivariatePolynomial.factory(t);
        for (int i = 0; i < rs.length; ++i) {
            if (rs[i] == null) continue;
            rs[i] = (UnivariatePolynomial)fact.valueof((i > 0 ? rs[i].normalize() : rs[i]).genericValue());
        }
        UnivariatePolynomial[] q = rs[0].squarefreeDecomposition();
        int m = q.length - 1;
        Generic s = JSCLInteger.valueOf(0L);
        for (int i = 1; i <= m; ++i) {
            for (int j = 0; j < q[i].degree(); ++j) {
                Generic a2 = new Root(q[i], j).evaluate();
                s = ((Generic)s).add(a2.multiply(new Log(i == pd.degree() ? d : rs[i].substitute(a2)).evaluate()));
            }
        }
        return s;
    }

    Generic getValue() {
        return this.result;
    }
}

