/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

import java.util.Iterator;
import jscl.math.Debug;
import jscl.math.Divisor;
import jscl.math.Expression;
import jscl.math.Generic;
import jscl.math.GenericVariable;
import jscl.math.IntegerDivisor;
import jscl.math.JSCLInteger;
import jscl.math.Linearization;
import jscl.math.NotDivisibleException;
import jscl.math.NotIntegerException;
import jscl.math.TechnicalVariable;
import jscl.math.Variable;
import jscl.math.polynomial.Basis;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Polynomial;
import jscl.util.ArrayComparator;

public class Factorization {
    Polynomial factory;
    Generic result;
    private static final String ter = "t";

    Factorization(Polynomial factory) {
        this.factory = factory;
    }

    public static Generic compute(Generic generic) {
        try {
            return GenericVariable.content(Factorization.factorize(generic.integerValue()));
        }
        catch (NotIntegerException e) {
            Factorization f = new Factorization(Polynomial.factory(generic.variables(), Monomial.iteratorOrdering, -1));
            f.computeValue(generic);
            return f.getValue();
        }
    }

    static Generic factorize(JSCLInteger integer) {
        Generic[] n = integer.gcdAndNormalize();
        Generic s = n[1];
        Generic a = JSCLInteger.valueOf(1L);
        Generic p = JSCLInteger.valueOf(2L);
        while (s.compareTo(JSCLInteger.valueOf(1L)) > 0) {
            Generic[] q = s.divideAndRemainder(p);
            if (q[0].compareTo(p) < 0) {
                p = s;
                q = s.divideAndRemainder(p);
            }
            if (q[1].signum() == 0) {
                a = ((Generic)a).multiply(Factorization.expression(p, true));
                s = q[0];
                continue;
            }
            p = p.add(JSCLInteger.valueOf(1L));
        }
        return ((Generic)a).multiply(n[0]);
    }

    void computeValue(Generic generic) {
        Debug.println("factorization");
        Polynomial[] n = this.factory.valueof(generic).gcdAndNormalize();
        Monomial m = n[1].monomialGcd();
        Polynomial s = n[1].divide(m);
        Generic a = JSCLInteger.valueOf(1L);
        Divisor[] d = new Divisor[2];
        Monomial[] p = new Monomial[2];
        Monomial[] q = new Monomial[2];
        d[1] = new Divisor(s.head().monomial());
        block0: while (d[1].hasNext()) {
            p[1] = (Monomial)d[1].next();
            q[1] = d[1].complementary();
            d[0] = new Divisor(s.tail().monomial());
            while (d[0].hasNext()) {
                p[0] = (Monomial)d[0].next();
                q[0] = d[0].complementary();
                if (p[1].compareTo(p[0]) <= 0) continue block0;
                Debug.println(Factorization.toString(p) + " * " + Factorization.toString(q) + " = " + s);
                if (ArrayComparator.comparator.compare(q, p) < 0) {
                    a = a.multiply(Factorization.expression(s.genericValue()));
                    break block0;
                }
                Debug.increment();
                Polynomial[] r = Factorization.remainder(s, Factorization.polynomial(s, p), Factorization.terminator(s));
                Debug.decrement();
                if (r[0].signum() != 0) continue;
                a = a.multiply(Factorization.expression(r[1].genericValue()));
                s = r[2];
                d[1].divide();
                d[0].divide();
                continue block0;
            }
        }
        this.result = a.multiply(n[0].multiply(m).genericValue());
    }

    static Polynomial[] remainder(Polynomial s, Polynomial p, Generic[] t) {
        Polynomial zero = s.valueof(JSCLInteger.valueOf(0L));
        Generic[] a = Basis.augment(t, s.remainderUpToCoefficient(p).elements());
        Variable[] unk = Basis.augmentUnknown(new Variable[0], p.elements());
        Variable u = unk[unk.length - 1];
        System.arraycopy(unk, 0, unk, 1, unk.length - 1);
        unk[0] = u;
        Generic[][] be = Linearization.compute(Basis.compute(a, unk, Monomial.lexicographic, 0, 4).elements(), unk);
        for (int i = 0; i < be.length; ++i) {
            Polynomial r = Factorization.substitute(p, be[i], unk);
            try {
                return new Polynomial[]{zero, r, s.divide(r)};
            }
            catch (NotDivisibleException e) {
                continue;
            }
        }
        return new Polynomial[]{s, zero, zero};
    }

    static Polynomial substitute(Polynomial p, Generic[] a, Variable[] unk) {
        Generic[] s = new Generic[]{p.genericValue()};
        return p.valueof(Basis.compute(Basis.augment(a, s), Basis.augmentUnknown(unk, s)).elements()[0]);
    }

    static Polynomial polynomial(Polynomial s, Monomial[] monomial) {
        Polynomial p = s.valueof(JSCLInteger.valueOf(0L));
        Iterator it = monomial[1].iterator(monomial[0]);
        int i = 0;
        while (it.hasNext()) {
            Monomial m = (Monomial)it.next();
            TechnicalVariable t = it.hasNext() ? new TechnicalVariable(ter, new int[]{i}) : new TechnicalVariable(ter);
            p = p.add(p.valueof(m).multiply(t.expressionValue()));
            ++i;
        }
        return p;
    }

    static Generic[] terminator(Polynomial polynomial) {
        Generic[] t = new Generic[2];
        t[1] = Factorization.terminator(polynomial.head().coef().abs(), new TechnicalVariable(ter), false);
        t[0] = Factorization.terminator(polynomial.tail().coef(), new TechnicalVariable(ter, new int[]{0}), true);
        return t;
    }

    static Generic terminator(Generic generic, Variable var, boolean tail) {
        Expression x = var.expressionValue();
        Generic a = JSCLInteger.valueOf(1L);
        IntegerDivisor it = IntegerDivisor.create(generic.integerValue());
        while (it.hasNext()) {
            Generic s = (Generic)it.next();
            a = a.multiply(((Generic)x).subtract(s));
            if (tail) continue;
            a = a.multiply(((Generic)x).add(s));
        }
        return a;
    }

    static Generic expression(Generic generic) {
        return Factorization.expression(generic, false);
    }

    static Generic expression(Generic generic, boolean integer) {
        if (generic.compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return generic;
        }
        return GenericVariable.valueOf(generic, integer).expressionValue();
    }

    static String toString(Monomial[] monomial) {
        return "{" + monomial[0] + ", " + monomial[1] + "}";
    }

    Generic getValue() {
        return GenericVariable.content(this.result, true);
    }
}

