/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

import java.util.ArrayList;
import java.util.List;
import jscl.math.Debug;
import jscl.math.Expression;
import jscl.math.Generic;
import jscl.math.IntegerDivisor;
import jscl.math.JSCLInteger;
import jscl.math.NotDivisibleException;
import jscl.math.Variable;
import jscl.math.polynomial.Basis;
import jscl.math.polynomial.Polynomial;
import jscl.util.ArrayComparator;
import jscl.util.ArrayUtils;

class Linearization {
    Variable[] unknown;
    List result = new ArrayList();

    Linearization(Variable[] unknown) {
        this.unknown = unknown;
    }

    static Generic[][] compute(Generic[] generic, Variable[] unknown) {
        Linearization l = new Linearization(unknown);
        Debug.println("linearization");
        Debug.increment();
        l.process(generic);
        Debug.decrement();
        return l.getValue();
    }

    void process(Generic[] generic) {
        boolean flag = true;
        for (int i = 0; i < generic.length; ++i) {
            Generic s = generic[i];
            Variable[] va = s.variables();
            if (va.length == 1) {
                Variable t = va[0];
                Polynomial p = Polynomial.factory(t).valueof(s);
                if (p.degree() <= 1) continue;
                flag = false;
                Polynomial[] r = Linearization.linearize(p, t);
                for (int j = 0; j < r.length; ++j) {
                    this.process(Basis.compute(Basis.augment(new Generic[]{r[j].genericValue()}, generic), this.unknown).elements());
                }
                continue;
            }
            flag = false;
        }
        if (flag) {
            this.result.add(generic);
        }
    }

    static Polynomial[] linearize(Polynomial polynomial, Variable variable) {
        ArrayList<Polynomial> l = new ArrayList<Polynomial>();
        Expression x = variable.expressionValue();
        Polynomial s = polynomial;
        try {
            Polynomial r = s.valueof(x);
            s = s.divide(r);
            l.add(r);
            while (true) {
                s = s.divide(r);
            }
        }
        catch (NotDivisibleException e) {
            IntegerDivisor[] d = new IntegerDivisor[2];
            Generic[] p = new Generic[2];
            Generic[] q = new Generic[2];
            d[1] = IntegerDivisor.create(JSCLInteger.valueOf(1L));
            block5: while (d[1].hasNext()) {
                p[1] = (Generic)d[1].next();
                q[1] = d[1].integer(d[1].complementary());
                d[0] = IntegerDivisor.create(s.tail().coef().integerValue());
                while (d[0].hasNext()) {
                    p[0] = (Generic)d[0].next();
                    q[0] = d[0].integer(d[0].complementary());
                    if (ArrayComparator.comparator.compare(q, p) < 0) break block5;
                    block7: for (int i = 0; i < 2; ++i) {
                        Polynomial r = s.valueof(i == 0 ? p[1].multiply(x).subtract(p[0]) : p[1].multiply(x).add(p[0]));
                        boolean flag = true;
                        while (true) {
                            try {
                                s = s.divide(r);
                            }
                            catch (NotDivisibleException e2) {
                                continue block7;
                            }
                            d[1].divide();
                            d[0].divide();
                            if (flag) {
                                l.add(r);
                            }
                            flag = false;
                        }
                    }
                }
            }
            return (Polynomial[])ArrayUtils.toArray(l, new Polynomial[l.size()]);
        }
    }

    Generic[][] getValue() {
        return (Generic[][])ArrayUtils.toArray(this.result, (Object[])new Generic[this.result.size()][]);
    }
}

