/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.function;

import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegrableException;
import jscl.math.NotVariableException;
import jscl.math.NumericWrapper;
import jscl.math.Variable;
import jscl.math.function.Constant;
import jscl.math.function.Frac;
import jscl.math.function.Function;
import jscl.math.function.Inv;
import jscl.math.function.Log;
import jscl.math.function.Pow;
import jscl.math.polynomial.Polynomial;
import jscl.mathml.MathML;

public class Exp
extends Function {
    public Exp(Generic generic) {
        super("exp", new Generic[]{generic});
    }

    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        Generic s = this.parameter[0];
        if (s.isPolynomial(variable)) {
            Polynomial p = Polynomial.factory(variable).valueof(s);
            if (p.degree() == 1) {
                Generic[] a = p.elements();
                return new Inv(a[1]).evaluate().multiply(this.antiderivative(0));
            }
            throw new NotIntegrableException();
        }
        throw new NotIntegrableException();
    }

    public Generic antiderivative(int n) throws NotIntegrableException {
        return this.evaluate();
    }

    public Generic derivative(int n) {
        return this.evaluate();
    }

    public Generic evaluate() {
        if (this.parameter[0].signum() < 0) {
            return new Inv(new Exp(this.parameter[0].negate()).evaluate()).evaluate();
        }
        if (this.parameter[0].signum() == 0) {
            return JSCLInteger.valueOf(1L);
        }
        return this.expressionValue();
    }

    public Generic evalelem() {
        return this.evaluate();
    }

    public Generic evalsimp() {
        Generic[] n;
        block8: {
            if (this.parameter[0].signum() < 0) {
                return new Inv(new Exp(this.parameter[0].negate()).evalsimp()).evalsimp();
            }
            if (this.parameter[0].signum() == 0) {
                return JSCLInteger.valueOf(1L);
            }
            if (this.parameter[0].compareTo(Constant.i.multiply(Constant.pi)) == 0) {
                return JSCLInteger.valueOf(-1L);
            }
            try {
                Variable v = this.parameter[0].variableValue();
                if (v instanceof Log) {
                    Generic[] g = ((Log)v).parameters();
                    return g[0];
                }
            }
            catch (NotVariableException e) {
                Generic[] a = this.parameter[0].sumValue();
                if (a.length <= 1) break block8;
                Generic s = JSCLInteger.valueOf(1L);
                for (int i = 0; i < a.length; ++i) {
                    s = ((Generic)s).multiply(new Exp(a[i]).evalsimp());
                }
                return s;
            }
        }
        if ((n = Frac.separateCoefficient(this.parameter[0]))[0].compareTo(JSCLInteger.valueOf(1L)) != 0 || n[1].compareTo(JSCLInteger.valueOf(1L)) != 0) {
            return new Pow(new Exp(n[2]).evalsimp(), new Frac(n[0], n[1]).evalsimp()).evalsimp();
        }
        return this.expressionValue();
    }

    public Generic evalnum() {
        return ((NumericWrapper)this.parameter[0]).exp();
    }

    public void toMathML(MathML element, Object data) {
        int exponent;
        int n = exponent = data instanceof Integer ? (Integer)data : 1;
        if (exponent == 1) {
            this.bodyToMathML(element, false);
        } else {
            MathML e1 = element.element("msup");
            this.bodyToMathML(e1, true);
            MathML e2 = element.element("mn");
            e2.appendChild(element.text(String.valueOf(exponent)));
            e1.appendChild(e2);
            element.appendChild(e1);
        }
    }

    void bodyToMathML(MathML element, boolean fenced) {
        if (fenced) {
            MathML e1 = element.element("mfenced");
            this.bodyToMathML(e1);
            element.appendChild(e1);
        } else {
            this.bodyToMathML(element);
        }
    }

    void bodyToMathML(MathML element) {
        MathML e1 = element.element("msup");
        MathML e2 = element.element("mi");
        e2.appendChild(element.text("e"));
        e1.appendChild(e2);
        this.parameter[0].toMathML(e1, null);
        element.appendChild(e1);
    }

    protected Variable newinstance() {
        return new Exp(null);
    }
}

