/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.function;

import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegrableException;
import jscl.math.Variable;
import jscl.mathml.MathML;
import jscl.util.ArrayComparator;

public abstract class Function
extends Variable {
    protected Generic[] parameter;

    public Function(String name, Generic[] parameter) {
        super(name);
        this.parameter = parameter;
    }

    public Generic[] parameters() {
        return this.parameter;
    }

    public abstract Generic evaluate();

    public abstract Generic evalelem();

    public abstract Generic evalsimp();

    public abstract Generic evalnum();

    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        int n = -1;
        for (int i = 0; i < this.parameter.length; ++i) {
            if (n == -1 && this.parameter[i].isIdentity(variable)) {
                n = i;
                continue;
            }
            if (this.parameter[i].isConstant(variable)) continue;
            n = -1;
            break;
        }
        if (n < 0) {
            throw new NotIntegrableException();
        }
        return this.antiderivative(n);
    }

    public abstract Generic antiderivative(int var1) throws NotIntegrableException;

    public Generic derivative(Variable variable) {
        if (this.isIdentity(variable)) {
            return JSCLInteger.valueOf(1L);
        }
        Generic a = JSCLInteger.valueOf(0L);
        for (int i = 0; i < this.parameter.length; ++i) {
            a = ((Generic)a).add(this.parameter[i].derivative(variable).multiply(this.derivative(i)));
        }
        return a;
    }

    public abstract Generic derivative(int var1);

    public Generic substitute(Variable variable, Generic generic) {
        Function v = (Function)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            v.parameter[i] = this.parameter[i].substitute(variable, generic);
        }
        if (v.isIdentity(variable)) {
            return generic;
        }
        return v.evaluate();
    }

    public Generic expand() {
        Function v = (Function)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            v.parameter[i] = this.parameter[i].expand();
        }
        return v.evaluate();
    }

    public Generic factorize() {
        Function v = (Function)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            v.parameter[i] = this.parameter[i].factorize();
        }
        return v.expressionValue();
    }

    public Generic elementary() {
        Function v = (Function)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            v.parameter[i] = this.parameter[i].elementary();
        }
        return v.evalelem();
    }

    public Generic simplify() {
        Function v = (Function)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            v.parameter[i] = this.parameter[i].simplify();
        }
        return v.evalsimp();
    }

    public Generic numeric() {
        Function v = (Function)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            v.parameter[i] = this.parameter[i].numeric();
        }
        return v.evalnum();
    }

    public boolean isConstant(Variable variable) {
        boolean s = !this.isIdentity(variable);
        for (int i = 0; i < this.parameter.length; ++i) {
            s = s && this.parameter[i].isConstant(variable);
        }
        return s;
    }

    public int compareTo(Variable variable) {
        if (this == variable) {
            return 0;
        }
        int c = comparator.compare(this, variable);
        if (c < 0) {
            return -1;
        }
        if (c > 0) {
            return 1;
        }
        Function v = (Function)variable;
        c = this.name.compareTo(v.name);
        if (c < 0) {
            return -1;
        }
        if (c > 0) {
            return 1;
        }
        return ArrayComparator.comparator.compare(this.parameter, v.parameter);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.name);
        buffer.append("(");
        for (int i = 0; i < this.parameter.length; ++i) {
            buffer.append(this.parameter[i]).append(i < this.parameter.length - 1 ? ", " : "");
        }
        buffer.append(")");
        return buffer.toString();
    }

    public String toJava() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.parameter[0].toJava());
        buffer.append(".").append(this.name).append("()");
        return buffer.toString();
    }

    public void toMathML(MathML element, Object data) {
        MathML e1;
        int exponent;
        int n = exponent = data instanceof Integer ? (Integer)data : 1;
        if (exponent == 1) {
            this.nameToMathML(element);
        } else {
            e1 = element.element("msup");
            this.nameToMathML(e1);
            MathML e2 = element.element("mn");
            e2.appendChild(element.text(String.valueOf(exponent)));
            e1.appendChild(e2);
            element.appendChild(e1);
        }
        e1 = element.element("mfenced");
        for (int i = 0; i < this.parameter.length; ++i) {
            this.parameter[i].toMathML(e1, null);
        }
        element.appendChild(e1);
    }
}

