/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.function;

import jscl.math.Antiderivative;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegerException;
import jscl.math.NotIntegrableException;
import jscl.math.NumericWrapper;
import jscl.math.TechnicalVariable;
import jscl.math.Variable;
import jscl.math.function.Algebraic;
import jscl.math.function.Constant;
import jscl.math.function.Cubic;
import jscl.math.function.Frac;
import jscl.math.function.Inv;
import jscl.math.function.Pow;
import jscl.math.function.Sigma;
import jscl.math.function.Sqrt;
import jscl.math.polynomial.Polynomial;
import jscl.math.polynomial.UnivariatePolynomial;
import jscl.mathml.MathML;
import jscl.util.ArrayComparator;

public class Root
extends Algebraic {
    protected Generic subscript;

    public Root(Generic[] parameter, Generic subscript) {
        super("root", parameter);
        this.subscript = subscript;
    }

    public Root(Generic[] parameter, int s) {
        this(parameter, JSCLInteger.valueOf(s));
    }

    public Root(UnivariatePolynomial polynomial, int s) {
        this(polynomial.normalize().elements(), s);
    }

    public Generic subscript() {
        return this.subscript;
    }

    public Root rootValue() {
        return this;
    }

    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        boolean b = true;
        for (int i = 0; i < this.parameter.length; ++i) {
            b = b && this.parameter[i].isPolynomial(variable);
        }
        if (b) {
            return Antiderivative.compute(this, variable);
        }
        throw new NotIntegrableException();
    }

    public Generic derivative(Variable variable) {
        if (this.compareTo(variable) == 0) {
            return JSCLInteger.valueOf(1L);
        }
        TechnicalVariable t = new TechnicalVariable("t");
        Generic[] a = new Generic[this.parameter.length];
        for (int i = 0; i < this.parameter.length; ++i) {
            a[i] = this.parameter[i].derivative(variable);
        }
        UnivariatePolynomial fact = (UnivariatePolynomial)Polynomial.factory(this);
        UnivariatePolynomial p = fact.valueof(this.parameter);
        UnivariatePolynomial q = (UnivariatePolynomial)p.derivative().multiply(t.expressionValue()).add(fact.valueof(a));
        UnivariatePolynomial r = (UnivariatePolynomial)Polynomial.factory(t).valueof(p.resultant(q));
        return new Root(r.elements(), this.subscript).evaluate();
    }

    public Generic derivative(int n) {
        return null;
    }

    public Generic substitute(Variable variable, Generic generic) {
        Root v = (Root)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            v.parameter[i] = this.parameter[i].substitute(variable, generic);
        }
        v.subscript = this.subscript.substitute(variable, generic);
        if (v.isIdentity(variable)) {
            return generic;
        }
        return v.evaluate();
    }

    public Generic expand() {
        Root v = (Root)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            v.parameter[i] = this.parameter[i].expand();
        }
        v.subscript = this.subscript.expand();
        return v.evaluate();
    }

    public Generic factorize() {
        Root v = (Root)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            v.parameter[i] = this.parameter[i].factorize();
        }
        v.subscript = this.subscript;
        return v.expressionValue();
    }

    public Generic elementary() {
        Root v = (Root)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            v.parameter[i] = this.parameter[i].elementary();
        }
        v.subscript = this.subscript.elementary();
        return v.evalelem();
    }

    public Generic simplify() {
        Root v = (Root)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            v.parameter[i] = this.parameter[i].simplify();
        }
        v.subscript = this.subscript.simplify();
        return v.evalsimp();
    }

    public Generic numeric() {
        Root v = (Root)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            v.parameter[i] = this.parameter[i].numeric();
        }
        v.subscript = this.subscript;
        return v.evalnum();
    }

    public Generic evaluate() {
        if (this.isZero()) {
            return JSCLInteger.valueOf(0L);
        }
        try {
            int s = this.subscript.integerValue().intValue();
            switch (this.degree()) {
                case 1: {
                    return new Frac(this.parameter[0], this.parameter[1]).evaluate().negate();
                }
            }
        }
        catch (NotIntegerException notIntegerException) {
            // empty catch block
        }
        return this.expressionValue();
    }

    public Generic evalelem() {
        return this.evaluate();
    }

    public Generic evalsimp() {
        if (this.isZero()) {
            return JSCLInteger.valueOf(0L);
        }
        try {
            int s = this.subscript.integerValue().intValue();
            switch (this.degree()) {
                case 1: {
                    return Root.linear(this.parameter);
                }
                case 2: {
                    return Root.quadratic(this.parameter, s);
                }
                case 3: {
                    return Root.cubic(this.parameter, s);
                }
                case 4: {
                    return Root.quartic(this.parameter, s);
                }
            }
            if (this.isNth() && s == 0) {
                return Root.nth(this.parameter);
            }
        }
        catch (NotIntegerException notIntegerException) {
            // empty catch block
        }
        return this.expressionValue();
    }

    boolean isZero() {
        boolean b = this.degree() > 0;
        for (int i = 0; i < this.degree(); ++i) {
            b = b && this.parameter[i].signum() == 0;
        }
        b = b && this.parameter[this.degree()].signum() != 0;
        return b;
    }

    boolean isNth() {
        boolean b = this.degree() > 0;
        for (int i = 1; i < this.degree(); ++i) {
            b = b && this.parameter[i].signum() == 0;
        }
        b = b && this.parameter[this.degree()].signum() != 0;
        return b;
    }

    static Generic nth(Generic[] parameter) {
        int degree = parameter.length - 1;
        Generic a = new Frac(parameter[0], parameter[degree]).evalsimp();
        return new Pow(a.negate(), new Inv(JSCLInteger.valueOf(degree)).evalsimp()).evalsimp();
    }

    static Generic linear(Generic[] parameter) {
        Generic a = new Frac(parameter[0], parameter[1]).evalsimp();
        return a.negate();
    }

    static Generic quadratic(Generic[] parameter, int subscript) {
        Generic a = new Frac(parameter[1], parameter[2]).evalsimp();
        Generic b = new Frac(parameter[0], parameter[2]).evalsimp();
        Generic y = new Sqrt(a.pow(2).subtract(JSCLInteger.valueOf(4L).multiply(b))).evalsimp();
        switch (subscript) {
            case 0: {
                return new Frac(a.subtract(y), JSCLInteger.valueOf(2L)).evalsimp().negate();
            }
        }
        return new Frac(a.add(y), JSCLInteger.valueOf(2L)).evalsimp().negate();
    }

    static Generic cubic(Generic[] parameter, int subscript) {
        Generic a = new Frac(parameter[2], parameter[3]).evalsimp();
        Generic b = new Frac(parameter[1], parameter[3]).evalsimp();
        Generic c = new Frac(parameter[0], parameter[3]).evalsimp();
        Generic[] y = new Generic[2];
        for (int i = 0; i < y.length; ++i) {
            y[i] = new Cubic(new Root(new Generic[]{a.pow(6).subtract(JSCLInteger.valueOf(9L).multiply(a.pow(4)).multiply(b)).add(JSCLInteger.valueOf(27L).multiply(a.pow(2)).multiply(b.pow(2))).subtract(JSCLInteger.valueOf(27L).multiply(b.pow(3))), JSCLInteger.valueOf(2L).multiply(a.pow(3)).subtract(JSCLInteger.valueOf(9L).multiply(a).multiply(b)).add(JSCLInteger.valueOf(27L).multiply(c)), JSCLInteger.valueOf(1L)}, i).evalsimp()).evalsimp();
        }
        switch (subscript) {
            case 0: {
                return new Frac(a.subtract(y[0]).subtract(y[1]), JSCLInteger.valueOf(3L)).evalsimp().negate();
            }
            case 1: {
                return new Frac(a.subtract(Constant.j.multiply(y[0])).subtract(Constant.jbar.multiply(y[1])), JSCLInteger.valueOf(3L)).evalsimp().negate();
            }
        }
        return new Frac(a.subtract(Constant.jbar.multiply(y[0])).subtract(Constant.j.multiply(y[1])), JSCLInteger.valueOf(3L)).evalsimp().negate();
    }

    static Generic quartic(Generic[] parameter, int subscript) {
        Generic a = new Frac(parameter[3], parameter[4]).evalsimp();
        Generic b = new Frac(parameter[2], parameter[4]).evalsimp();
        Generic c = new Frac(parameter[1], parameter[4]).evalsimp();
        Generic d = new Frac(parameter[0], parameter[4]).evalsimp();
        Generic[] y = new Generic[3];
        for (int i = 0; i < y.length; ++i) {
            y[i] = new Sqrt(new Root(new Generic[]{a.pow(6).subtract(JSCLInteger.valueOf(8L).multiply(a.pow(4)).multiply(b)).add(JSCLInteger.valueOf(16L).multiply(a.pow(2)).multiply(b.pow(2))).add(JSCLInteger.valueOf(16L).multiply(a.pow(3)).multiply(c)).subtract(JSCLInteger.valueOf(64L).multiply(a).multiply(b).multiply(c)).add(JSCLInteger.valueOf(64L).multiply(c.pow(2))), JSCLInteger.valueOf(-3L).multiply(a.pow(4)).add(JSCLInteger.valueOf(16L).multiply(a.pow(2)).multiply(b)).subtract(JSCLInteger.valueOf(16L).multiply(b.pow(2))).subtract(JSCLInteger.valueOf(16L).multiply(a).multiply(c)).add(JSCLInteger.valueOf(64L).multiply(d)), JSCLInteger.valueOf(3L).multiply(a.pow(2)).subtract(JSCLInteger.valueOf(8L).multiply(b)), JSCLInteger.valueOf(-1L)}, i).evalsimp()).evalsimp();
        }
        switch (subscript) {
            case 0: {
                return new Frac(a.add(y[0]).subtract(y[1]).subtract(y[2]), JSCLInteger.valueOf(4L)).evalsimp().negate();
            }
            case 1: {
                return new Frac(a.subtract(y[0]).subtract(y[1]).add(y[2]), JSCLInteger.valueOf(4L)).evalsimp().negate();
            }
            case 2: {
                return new Frac(a.add(y[0]).add(y[1]).add(y[2]), JSCLInteger.valueOf(4L)).evalsimp().negate();
            }
        }
        return new Frac(a.subtract(y[0]).add(y[1]).subtract(y[2]), JSCLInteger.valueOf(4L)).evalsimp().negate();
    }

    public int degree() {
        return this.parameter.length - 1;
    }

    public Generic evalnum() {
        return NumericWrapper.root(this.subscript.integerValue().intValue(), this.parameter);
    }

    public int compareTo(Variable variable) {
        if (this == variable) {
            return 0;
        }
        int c = comparator.compare(this, variable);
        if (c < 0) {
            return -1;
        }
        if (c > 0) {
            return 1;
        }
        Root v = (Root)variable;
        c = ArrayComparator.comparator.compare(this.parameter, v.parameter);
        if (c < 0) {
            return -1;
        }
        if (c > 0) {
            return 1;
        }
        return this.subscript.compareTo(v.subscript);
    }

    public static Generic sigma(Generic[] parameter, int n) {
        Sigma s = new Sigma(parameter, n);
        s.compute();
        return s.getValue();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.name);
        buffer.append("[").append(this.subscript).append("]");
        buffer.append("(");
        for (int i = 0; i < this.parameter.length; ++i) {
            buffer.append(this.parameter[i]).append(i < this.parameter.length - 1 ? ", " : "");
        }
        buffer.append(")");
        return buffer.toString();
    }

    public String toJava() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Numeric.").append(this.name).append("(");
        buffer.append(this.subscript.integerValue().intValue());
        buffer.append(", new Numeric[] {");
        for (int i = 0; i < this.parameter.length; ++i) {
            buffer.append(this.parameter[i].toJava()).append(i < this.parameter.length - 1 ? ", " : "");
        }
        buffer.append("})");
        return buffer.toString();
    }

    public void toMathML(MathML element, Object data) {
        MathML e1;
        int exponent;
        int n = exponent = data instanceof Integer ? (Integer)data : 1;
        if (exponent == 1) {
            e1 = element.element("msub");
            this.nameToMathML(e1);
            this.subscript.toMathML(e1, null);
            element.appendChild(e1);
        } else {
            e1 = element.element("msubsup");
            this.nameToMathML(e1);
            this.subscript.toMathML(e1, null);
            MathML e2 = element.element("mn");
            e2.appendChild(element.text(String.valueOf(exponent)));
            e1.appendChild(e2);
            element.appendChild(e1);
        }
        e1 = element.element("mfenced");
        for (int i = 0; i < this.parameter.length; ++i) {
            this.parameter[i].toMathML(e1, null);
        }
        element.appendChild(e1);
    }

    void bodyToMathML(MathML element, boolean fenced) {
    }

    protected Variable newinstance() {
        return new Root(new Generic[this.parameter.length], null);
    }
}

