/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.operator;

import jscl.math.Generic;
import jscl.math.GenericVariable;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegerException;
import jscl.math.NotVariableException;
import jscl.math.Variable;
import jscl.math.function.Frac;
import jscl.math.function.Pow;
import jscl.math.operator.Operator;
import jscl.mathml.MathML;
import jscl.util.ArrayComparator;

public class Factorial
extends Operator {
    public Factorial(Generic expression) {
        super("", new Generic[]{expression});
    }

    public Generic compute() {
        try {
            int n = this.parameter[0].integerValue().intValue();
            Generic a = JSCLInteger.valueOf(1L);
            for (int i = 0; i < n; ++i) {
                a = ((Generic)a).multiply(JSCLInteger.valueOf(i + 1));
            }
            return a;
        }
        catch (NotIntegerException notIntegerException) {
            return this.expressionValue();
        }
    }

    public int compareTo(Variable variable) {
        if (this == variable) {
            return 0;
        }
        int c = comparator.compare(this, variable);
        if (c < 0) {
            return -1;
        }
        if (c > 0) {
            return 1;
        }
        Factorial v = (Factorial)variable;
        return ArrayComparator.comparator.compare(this.parameter, v.parameter);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        try {
            JSCLInteger en = this.parameter[0].integerValue();
            buffer.append(en);
        }
        catch (NotIntegerException e) {
            try {
                Variable v = this.parameter[0].variableValue();
                if (v instanceof Frac || v instanceof Pow) {
                    buffer.append(GenericVariable.valueOf(this.parameter[0]));
                } else {
                    buffer.append(v);
                }
            }
            catch (NotVariableException e2) {
                buffer.append(GenericVariable.valueOf(this.parameter[0]));
            }
        }
        buffer.append("!");
        return buffer.toString();
    }

    public void toMathML(MathML element, Object data) {
        int exponent;
        int n = exponent = data instanceof Integer ? (Integer)data : 1;
        if (exponent == 1) {
            this.bodyToMathML(element);
        } else {
            MathML e1 = element.element("msup");
            this.bodyToMathML(e1);
            MathML e2 = element.element("mn");
            e2.appendChild(element.text(String.valueOf(exponent)));
            e1.appendChild(e2);
            element.appendChild(e1);
        }
    }

    void bodyToMathML(MathML element) {
        MathML e1 = element.element("mrow");
        try {
            JSCLInteger en = this.parameter[0].integerValue();
            en.toMathML(e1, null);
        }
        catch (NotIntegerException e) {
            try {
                Variable v = this.parameter[0].variableValue();
                if (v instanceof Pow) {
                    GenericVariable.valueOf(this.parameter[0]).toMathML(e1, null);
                } else {
                    v.toMathML(e1, null);
                }
            }
            catch (NotVariableException e2) {
                GenericVariable.valueOf(this.parameter[0]).toMathML(e1, null);
            }
        }
        MathML e2 = element.element("mo");
        e2.appendChild(element.text("!"));
        e1.appendChild(e2);
        element.appendChild(e1);
    }

    protected Variable newinstance() {
        return new Factorial(null);
    }
}

