/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.operator;

import jscl.math.Generic;
import jscl.math.GenericVariable;
import jscl.math.JSCLInteger;
import jscl.math.JSCLVector;
import jscl.math.Variable;
import jscl.math.function.Constant;
import jscl.math.function.ImplicitFunction;
import jscl.math.operator.Operator;
import jscl.math.operator.PolynomialVector;
import jscl.math.polynomial.Basis;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Ordering;
import jscl.math.polynomial.Polynomial;
import jscl.mathml.MathML;

public class Groebner
extends Operator {
    public Groebner(Generic generic, Generic variable, Generic ordering, Generic modulo) {
        super("groebner", new Generic[]{generic, variable, ordering, modulo});
    }

    public Generic compute() {
        Generic[] generic = ((JSCLVector)this.parameter[0]).elements();
        Variable[] variable = Groebner.variables(this.parameter[1]);
        Ordering ord = Groebner.ordering(this.parameter[2]);
        int m = this.parameter[3].integerValue().intValue();
        return new PolynomialVector(Basis.compute(generic, variable, ord, m));
    }

    public Operator transmute() {
        Generic[] p = new Generic[]{GenericVariable.content(this.parameter[0]), GenericVariable.content(this.parameter[1])};
        if (p[0] instanceof JSCLVector && p[1] instanceof JSCLVector) {
            Generic[] generic = ((JSCLVector)p[0]).elements();
            Variable[] variable = Groebner.variables(p[1]);
            Ordering ord = Groebner.ordering(this.parameter[2]);
            int m = this.parameter[3].integerValue().intValue();
            return new Groebner(new PolynomialVector(new Basis(generic, Polynomial.factory(variable, ord, m))), p[1], this.parameter[2], this.parameter[3]);
        }
        return this;
    }

    static Ordering ordering(Generic generic) {
        Variable v = generic.variableValue();
        if (v.compareTo(new Constant("lex")) == 0) {
            return Monomial.lexicographic;
        }
        if (v.compareTo(new Constant("tdl")) == 0) {
            return Monomial.totalDegreeLexicographic;
        }
        if (v.compareTo(new Constant("drl")) == 0) {
            return Monomial.degreeReverseLexicographic;
        }
        if (v instanceof ImplicitFunction) {
            Generic[] g = ((ImplicitFunction)v).parameters();
            int k = g[0].integerValue().intValue();
            if (v.compareTo(new ImplicitFunction("elim", new Generic[]{JSCLInteger.valueOf(k)}, new int[]{0}, new Generic[0])) == 0) {
                return Monomial.kthElimination(k);
            }
        }
        throw new ArithmeticException();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int n = 4;
        if (this.parameter[3].signum() == 0) {
            n = 3;
            if (Groebner.ordering(this.parameter[2]) == Monomial.lexicographic) {
                n = 2;
            }
        }
        buffer.append(this.name);
        buffer.append("(");
        for (int i = 0; i < n; ++i) {
            buffer.append(this.parameter[i]).append(i < n - 1 ? ", " : "");
        }
        buffer.append(")");
        return buffer.toString();
    }

    public void toMathML(MathML element, Object data) {
        MathML e1;
        int exponent = data instanceof Integer ? (Integer)data : 1;
        int n = 4;
        if (this.parameter[3].signum() == 0) {
            n = 3;
            if (Groebner.ordering(this.parameter[2]) == Monomial.lexicographic) {
                n = 2;
            }
        }
        if (exponent == 1) {
            this.nameToMathML(element);
        } else {
            e1 = element.element("msup");
            this.nameToMathML(e1);
            MathML e2 = element.element("mn");
            e2.appendChild(element.text(String.valueOf(exponent)));
            e1.appendChild(e2);
            element.appendChild(e1);
        }
        e1 = element.element("mfenced");
        for (int i = 0; i < n; ++i) {
            this.parameter[i].toMathML(e1, null);
        }
        element.appendChild(e1);
    }

    protected Variable newinstance() {
        return new Groebner(null, null, null, null);
    }
}

