/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.ModularInteger;
import jscl.math.polynomial.ArrayPolynomialGeneric;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Polynomial;

class ArrayPolynomialModular
extends ArrayPolynomialGeneric {
    final int modulo;
    int[] coef;

    ArrayPolynomialModular(Monomial monomialFactory, Generic coefFactory) {
        super(monomialFactory, coefFactory);
        this.modulo = ((ModularInteger)coefFactory).modulo();
    }

    ArrayPolynomialModular(int size, Monomial monomialFactory, Generic coefFactory) {
        this(monomialFactory, coefFactory);
        this.init(size);
    }

    void init(int size) {
        this.monomial = new Monomial[size];
        this.coef = new int[size];
        this.size = size;
    }

    void resize(int size) {
        int length = this.monomial.length;
        if (size < length) {
            Monomial[] monomial = new Monomial[size];
            int[] coef = new int[size];
            System.arraycopy(this.monomial, length - size, monomial, 0, size);
            System.arraycopy(this.coef, length - size, coef, 0, size);
            this.monomial = monomial;
            this.coef = coef;
            this.size = size;
        }
    }

    public Polynomial subtract(Polynomial polynomial) {
        Monomial m2;
        if (polynomial.signum() == 0) {
            return this;
        }
        ArrayPolynomialModular q = (ArrayPolynomialModular)polynomial;
        ArrayPolynomialModular p = (ArrayPolynomialModular)this.newinstance(this.size + q.size);
        int i = p.size;
        int i1 = this.size;
        int i2 = q.size;
        Monomial m1 = i1 > 0 ? this.monomial[--i1] : null;
        Monomial monomial = m2 = i2 > 0 ? q.monomial[--i2] : null;
        while (m1 != null || m2 != null) {
            int a;
            int c;
            int n = m1 == null ? 1 : (c = m2 == null ? -1 : -this.ordering.compare(m1, m2));
            if (c < 0) {
                a = this.coef[i1];
                p.monomial[--i] = m1;
                p.coef[i] = a;
                m1 = i1 > 0 ? this.monomial[--i1] : null;
                continue;
            }
            if (c > 0) {
                a = (int)(((long)this.modulo - (long)q.coef[i2]) % (long)this.modulo);
                p.monomial[--i] = m2;
                p.coef[i] = a;
                m2 = i2 > 0 ? q.monomial[--i2] : null;
                continue;
            }
            a = (int)(((long)this.coef[i1] + (long)this.modulo - (long)q.coef[i2]) % (long)this.modulo);
            if (a != 0) {
                p.monomial[--i] = m1;
                p.coef[i] = a;
            }
            m1 = i1 > 0 ? this.monomial[--i1] : null;
            m2 = i2 > 0 ? q.monomial[--i2] : null;
        }
        p.resize(p.size - i);
        p.degree = ArrayPolynomialModular.degree(p);
        p.sugar = Math.max(this.sugar, q.sugar);
        return p;
    }

    public Polynomial multiplyAndSubtract(Generic generic, Polynomial polynomial) {
        Monomial m2;
        if (generic.signum() == 0) {
            return this;
        }
        int g = generic.integerValue().intValue();
        if (g == 1) {
            return this.subtract(polynomial);
        }
        ArrayPolynomialModular q = (ArrayPolynomialModular)polynomial;
        ArrayPolynomialModular p = (ArrayPolynomialModular)this.newinstance(this.size + q.size);
        int i = p.size;
        int i1 = this.size;
        int i2 = q.size;
        Monomial m1 = i1 > 0 ? this.monomial[--i1] : null;
        Monomial monomial = m2 = i2 > 0 ? q.monomial[--i2] : null;
        while (m1 != null || m2 != null) {
            int a;
            int c;
            int n = m1 == null ? 1 : (c = m2 == null ? -1 : -this.ordering.compare(m1, m2));
            if (c < 0) {
                a = this.coef[i1];
                p.monomial[--i] = m1;
                p.coef[i] = a;
                m1 = i1 > 0 ? this.monomial[--i1] : null;
                continue;
            }
            if (c > 0) {
                a = (int)(((long)this.modulo - (long)q.coef[i2] * (long)g % (long)this.modulo) % (long)this.modulo);
                p.monomial[--i] = m2;
                p.coef[i] = a;
                m2 = i2 > 0 ? q.monomial[--i2] : null;
                continue;
            }
            a = (int)(((long)this.coef[i1] + (long)this.modulo - (long)q.coef[i2] * (long)g % (long)this.modulo) % (long)this.modulo);
            if (a != 0) {
                p.monomial[--i] = m1;
                p.coef[i] = a;
            }
            m1 = i1 > 0 ? this.monomial[--i1] : null;
            m2 = i2 > 0 ? q.monomial[--i2] : null;
        }
        p.resize(p.size - i);
        p.degree = ArrayPolynomialModular.degree(p);
        p.sugar = Math.max(this.sugar, q.sugar);
        return p;
    }

    public Polynomial multiplyAndSubtract(Monomial monomial, Generic generic, Polynomial polynomial) {
        Monomial m2;
        if (this.defined) {
            throw new UnsupportedOperationException();
        }
        if (generic.signum() == 0) {
            return this;
        }
        if (monomial.degree() == 0) {
            return this.multiplyAndSubtract(generic, polynomial);
        }
        int g = generic.integerValue().intValue();
        ArrayPolynomialModular q = (ArrayPolynomialModular)polynomial;
        ArrayPolynomialModular p = (ArrayPolynomialModular)this.newinstance(this.size + q.size);
        int i = p.size;
        int i1 = this.size;
        int i2 = q.size;
        Monomial m1 = i1 > 0 ? this.monomial[--i1] : null;
        Monomial monomial2 = m2 = i2 > 0 ? q.monomial[--i2].multiply(monomial) : null;
        while (m1 != null || m2 != null) {
            int a;
            int c;
            int n = m1 == null ? 1 : (c = m2 == null ? -1 : -this.ordering.compare(m1, m2));
            if (c < 0) {
                a = this.coef[i1];
                p.monomial[--i] = m1;
                p.coef[i] = a;
                m1 = i1 > 0 ? this.monomial[--i1] : null;
                continue;
            }
            if (c > 0) {
                a = (int)(((long)this.modulo - (long)q.coef[i2] * (long)g % (long)this.modulo) % (long)this.modulo);
                p.monomial[--i] = m2;
                p.coef[i] = a;
                m2 = i2 > 0 ? q.monomial[--i2].multiply(monomial) : null;
                continue;
            }
            a = (int)(((long)this.coef[i1] + (long)this.modulo - (long)q.coef[i2] * (long)g % (long)this.modulo) % (long)this.modulo);
            if (a != 0) {
                p.monomial[--i] = m1;
                p.coef[i] = a;
            }
            m1 = i1 > 0 ? this.monomial[--i1] : null;
            m2 = i2 > 0 ? q.monomial[--i2].multiply(monomial) : null;
        }
        p.resize(p.size - i);
        p.degree = ArrayPolynomialModular.degree(p);
        p.sugar = Math.max(this.sugar, q.sugar + monomial.degree());
        return p;
    }

    public Polynomial multiply(Generic generic) {
        if (generic.signum() == 0) {
            return this.valueof(JSCLInteger.valueOf(0L));
        }
        int g = generic.integerValue().intValue();
        if (g == 1) {
            return this;
        }
        ArrayPolynomialModular p = (ArrayPolynomialModular)this.newinstance(this.size);
        for (int i = 0; i < this.size; ++i) {
            p.monomial[i] = this.monomial[i];
            p.coef[i] = (int)((long)this.coef[i] * (long)g % (long)this.modulo);
        }
        p.degree = this.degree;
        p.sugar = this.sugar;
        return p;
    }

    public Polynomial multiply(Monomial monomial) {
        if (this.defined) {
            throw new UnsupportedOperationException();
        }
        if (monomial.degree() == 0) {
            return this;
        }
        ArrayPolynomialModular p = (ArrayPolynomialModular)this.newinstance(this.size);
        for (int i = 0; i < this.size; ++i) {
            p.monomial[i] = this.monomial[i].multiply(monomial);
            p.coef[i] = this.coef[i];
        }
        p.degree = this.degree + monomial.degree();
        p.sugar = this.sugar + monomial.degree();
        return p;
    }

    protected Generic coefficient(Generic generic) {
        return this.coefFactory.valueof(generic);
    }

    protected Generic getCoef(int n) {
        return new ModularInteger(this.coef[n], this.modulo);
    }

    protected void setCoef(int n, Generic generic) {
        this.coef[n] = generic.integerValue().intValue();
    }

    protected ArrayPolynomialGeneric newinstance(int n) {
        return new ArrayPolynomialModular(n, this.monomialFactory, this.coefFactory);
    }
}

