/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import jscl.math.NotDivisibleException;
import jscl.math.Variable;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Ordering;
import jscl.math.polynomial.SmallMonomial;

class BooleanMonomial
extends SmallMonomial {
    static final int log2n = 1;
    static final int log2p = 4;
    static final int nmask = 3;
    static final int pmask = 15;

    BooleanMonomial(Variable[] unknown, Ordering ordering) {
        this((unknown.length - 1 >> 4) + 1, unknown, ordering);
    }

    BooleanMonomial(int length, Variable[] unknown, Ordering ordering) {
        super(length, unknown, ordering);
    }

    public Monomial multiply(Monomial monomial) {
        Monomial m = this.newinstance();
        for (int i = 0; i < this.unknown.length; ++i) {
            int q = i >> 4;
            int r = (i & 0xF) << 1;
            int a = this.element[q] >> r & 3;
            int b = monomial.element[q] >> r & 3;
            int c = a + b;
            if (c > 3) {
                throw new ArithmeticException();
            }
            int n = q;
            m.element[n] = m.element[n] | c << r;
            m.degree += c;
        }
        return m;
    }

    public boolean multiple(Monomial monomial, boolean strict) {
        boolean equal = true;
        for (int i = 0; i < this.unknown.length; ++i) {
            int q = i >> 4;
            int r = (i & 0xF) << 1;
            int a = this.element[q] >> r & 3;
            int b = monomial.element[q] >> r & 3;
            if (a < b) {
                return false;
            }
            equal &= a == b;
        }
        return strict ? !equal : true;
    }

    public Monomial divide(Monomial monomial) throws ArithmeticException {
        Monomial m = this.newinstance();
        for (int i = 0; i < this.unknown.length; ++i) {
            int q = i >> 4;
            int r = (i & 0xF) << 1;
            int a = this.element[q] >> r & 3;
            int b = monomial.element[q] >> r & 3;
            int c = a - b;
            if (c < 0) {
                throw new NotDivisibleException();
            }
            int n = q;
            m.element[n] = m.element[n] | c << r;
        }
        m.degree = this.degree - monomial.degree;
        return m;
    }

    public Monomial gcd(Monomial monomial) {
        Monomial m = this.newinstance();
        for (int i = 0; i < this.unknown.length; ++i) {
            int q = i >> 4;
            int r = (i & 0xF) << 1;
            int a = this.element[q] >> r & 3;
            int b = monomial.element[q] >> r & 3;
            int c = Math.min(a, b);
            int n = q;
            m.element[n] = m.element[n] | c << r;
            m.degree += c;
        }
        return m;
    }

    public Monomial scm(Monomial monomial) {
        Monomial m = this.newinstance();
        for (int i = 0; i < this.unknown.length; ++i) {
            int q = i >> 4;
            int r = (i & 0xF) << 1;
            int a = this.element[q] >> r & 3;
            int b = monomial.element[q] >> r & 3;
            int c = Math.max(a, b);
            int n = q;
            m.element[n] = m.element[n] | c << r;
            m.degree += c;
        }
        return m;
    }

    public int element(int n) {
        if (this.reverse()) {
            n = this.unknown.length - 1 - n;
        }
        int q = n >> 4;
        int r = (n & 0xF) << 1;
        return this.element[q] >> r & 3;
    }

    void put(int n, int integer) {
        int r;
        int q;
        int a;
        int c;
        if (this.reverse()) {
            n = this.unknown.length - 1 - n;
        }
        if ((c = (a = this.element[q = n >> 4] >> (r = (n & 0xF) << 1) & 3) + integer) > 3) {
            throw new ArithmeticException();
        }
        int n2 = q;
        this.element[n2] = this.element[n2] | c << r;
        this.degree += c - a;
    }

    protected Monomial newinstance() {
        return new BooleanMonomial(this.element.length, this.unknown, this.ordering);
    }
}

