/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import jscl.math.Expression;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.Literal;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Polynomial;
import jscl.math.polynomial.Term;
import jscl.util.ArrayUtils;

final class ListPolynomial
extends Polynomial {
    final List content = new LinkedList();
    int degree;
    boolean mutable = true;

    ListPolynomial(Monomial monomialFactory, Generic coefFactory) {
        super(monomialFactory, coefFactory);
    }

    public int size() {
        return this.content.size();
    }

    public final Iterator iterator(boolean direction, Monomial current) {
        return new ContentIterator(direction, current);
    }

    int indexOf(Monomial monomial) {
        int n = ArrayUtils.binarySearch(this.content, new Term(monomial, null));
        return n < 0 ? -n - 1 : n;
    }

    public Polynomial subtract(Polynomial polynomial) {
        if (polynomial.signum() == 0) {
            return this;
        }
        if (this.mutable) {
            Term t2;
            ListPolynomial q = (ListPolynomial)polynomial;
            ListIterator<Term> it1 = this.content.listIterator(this.content.size());
            ListIterator it2 = q.content.listIterator(q.content.size());
            Term t1 = it1.hasPrevious() ? (Term)it1.previous() : null;
            Term term = t2 = it2.hasPrevious() ? (Term)it2.previous() : null;
            while (t2 != null) {
                int c;
                int n = t1 == null ? 1 : (c = t2 == null ? -1 : -this.ordering.compare(t1.monomial(), t2.monomial()));
                if (c < 0) {
                    t1 = it1.hasPrevious() ? (Term)it1.previous() : null;
                    continue;
                }
                if (c > 0) {
                    if (t1 != null) {
                        it1.next();
                    }
                    it1.add(t2.negate());
                } else {
                    Term t = t1.subtract(t2);
                    if (t.signum() == 0) {
                        it1.remove();
                    } else {
                        it1.set(t);
                    }
                }
                t1 = it1.hasPrevious() ? (Term)it1.previous() : null;
                t2 = it2.hasPrevious() ? (Term)it2.previous() : null;
            }
            this.degree = ListPolynomial.degree(this);
            this.sugar = Math.max(this.sugar, q.sugar);
            this.normalized = false;
            return this;
        }
        return this.copy().subtract(polynomial);
    }

    public Polynomial multiplyAndSubtract(Generic generic, Polynomial polynomial) {
        if (generic.signum() == 0) {
            return this;
        }
        if (generic.compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return this.subtract(polynomial);
        }
        if (this.mutable) {
            Term t2;
            ListPolynomial q = (ListPolynomial)polynomial;
            ListIterator<Term> it1 = this.content.listIterator(this.content.size());
            ListIterator it2 = q.content.listIterator(q.content.size());
            Term t1 = it1.hasPrevious() ? (Term)it1.previous() : null;
            Term term = t2 = it2.hasPrevious() ? ((Term)it2.previous()).multiply(generic) : null;
            while (t2 != null) {
                int c;
                int n = t1 == null ? 1 : (c = t2 == null ? -1 : -this.ordering.compare(t1.monomial(), t2.monomial()));
                if (c < 0) {
                    t1 = it1.hasPrevious() ? (Term)it1.previous() : null;
                    continue;
                }
                if (c > 0) {
                    if (t1 != null) {
                        it1.next();
                    }
                    it1.add(t2.negate());
                } else {
                    Term t = t1.subtract(t2);
                    if (t.signum() == 0) {
                        it1.remove();
                    } else {
                        it1.set(t);
                    }
                }
                t1 = it1.hasPrevious() ? (Term)it1.previous() : null;
                t2 = it2.hasPrevious() ? ((Term)it2.previous()).multiply(generic) : null;
            }
            this.degree = ListPolynomial.degree(this);
            this.sugar = Math.max(this.sugar, q.sugar);
            this.normalized = false;
            return this;
        }
        return this.copy().multiplyAndSubtract(generic, polynomial);
    }

    public Polynomial multiplyAndSubtract(Monomial monomial, Generic generic, Polynomial polynomial) {
        if (this.defined) {
            throw new UnsupportedOperationException();
        }
        if (generic.signum() == 0) {
            return this;
        }
        if (monomial.degree() == 0) {
            return this.multiplyAndSubtract(generic, polynomial);
        }
        if (this.mutable) {
            Term t2;
            ListPolynomial q = (ListPolynomial)polynomial;
            ListIterator<Term> it1 = this.content.listIterator(this.content.size());
            ListIterator it2 = q.content.listIterator(q.content.size());
            Term t1 = it1.hasPrevious() ? (Term)it1.previous() : null;
            Term term = t2 = it2.hasPrevious() ? ((Term)it2.previous()).multiply(monomial, generic) : null;
            while (t2 != null) {
                int c;
                int n = t1 == null ? 1 : (c = t2 == null ? -1 : -this.ordering.compare(t1.monomial(), t2.monomial()));
                if (c < 0) {
                    t1 = it1.hasPrevious() ? (Term)it1.previous() : null;
                    continue;
                }
                if (c > 0) {
                    if (t1 != null) {
                        it1.next();
                    }
                    it1.add(t2.negate());
                } else {
                    Term t = t1.subtract(t2);
                    if (t.signum() == 0) {
                        it1.remove();
                    } else {
                        it1.set(t);
                    }
                }
                t1 = it1.hasPrevious() ? (Term)it1.previous() : null;
                t2 = it2.hasPrevious() ? ((Term)it2.previous()).multiply(monomial, generic) : null;
            }
            this.degree = ListPolynomial.degree(this);
            this.sugar = Math.max(this.sugar, q.sugar + monomial.degree());
            this.normalized = false;
            return this;
        }
        return this.copy().multiplyAndSubtract(monomial, generic, polynomial);
    }

    public Polynomial multiply(Generic generic) {
        if (generic.signum() == 0) {
            return this.valueof(JSCLInteger.valueOf(0L));
        }
        if (generic.compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return this;
        }
        if (this.mutable) {
            ListIterator<Term> it = this.content.listIterator();
            while (it.hasNext()) {
                it.set(((Term)it.next()).multiply(generic));
            }
            this.normalized = false;
            return this;
        }
        return this.copy().multiply(generic);
    }

    public Polynomial multiply(Monomial monomial) {
        if (this.defined) {
            throw new UnsupportedOperationException();
        }
        if (monomial.degree() == 0) {
            return this;
        }
        if (this.mutable) {
            ListIterator<Term> it = this.content.listIterator();
            while (it.hasNext()) {
                it.set(((Term)it.next()).multiply(monomial));
            }
            this.degree += monomial.degree();
            this.sugar += monomial.degree();
            return this;
        }
        return this.copy().multiply(monomial);
    }

    public Polynomial divide(Generic generic) throws ArithmeticException {
        if (generic.compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return this;
        }
        if (this.mutable) {
            ListIterator<Term> it = this.content.listIterator();
            while (it.hasNext()) {
                it.set(((Term)it.next()).divide(generic));
            }
            this.normalized = false;
            return this;
        }
        return this.copy().divide(generic);
    }

    public Polynomial divide(Monomial monomial) throws ArithmeticException {
        if (monomial.degree() == 0) {
            return this;
        }
        if (this.mutable) {
            ListIterator<Term> it = this.content.listIterator();
            while (it.hasNext()) {
                it.set(((Term)it.next()).divide(monomial));
            }
            this.degree -= monomial.degree();
            this.sugar -= monomial.degree();
            return this;
        }
        return this.copy().divide(monomial);
    }

    public Polynomial gcd(Polynomial polynomial) {
        throw new UnsupportedOperationException();
    }

    public int degree() {
        return this.degree;
    }

    public Polynomial valueof(Polynomial polynomial) {
        ListPolynomial p = this.newinstance(0);
        p.init(polynomial);
        return p;
    }

    public Polynomial valueof(Generic generic) {
        ListPolynomial p = this.newinstance(0);
        p.init(generic);
        return p;
    }

    public Polynomial valueof(Monomial monomial) {
        ListPolynomial p = this.newinstance(0);
        p.init(monomial);
        return p;
    }

    public Polynomial freeze() {
        this.mutable = false;
        return this;
    }

    public Term head() {
        int size = this.content.size();
        return size > 0 ? (Term)this.content.get(size - 1) : null;
    }

    public Term tail() {
        int size = this.content.size();
        return size > 0 ? (Term)this.content.get(0) : null;
    }

    void init(Polynomial polynomial) {
        ListPolynomial q = (ListPolynomial)polynomial;
        this.content.addAll(q.content);
        this.degree = q.degree;
        this.sugar = q.sugar;
    }

    void init(Expression expression) {
        Monomial m;
        TreeMap<Monomial, Generic> map = new TreeMap<Monomial, Generic>(this.ordering);
        int n = expression.size();
        for (int i = 0; i < n; ++i) {
            Generic a;
            Literal l = expression.literal(i);
            JSCLInteger en = expression.coef(i);
            m = this.monomial(l);
            Generic a2 = this.coefficient((l = l.divide(m.literalValue())).degree() > 0 ? en.multiply(Expression.valueOf(l)) : en);
            Generic a1 = (Generic)map.get(m);
            Generic generic = a = a1 == null ? a2 : a1.add(a2);
            if (a.signum() == 0) {
                map.remove(m);
                continue;
            }
            map.put(m, a);
        }
        int sugar = 0;
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            m = (Monomial)e.getKey();
            Generic a = (Generic)e.getValue();
            this.content.add(new Term(m, a));
            sugar = Math.max(sugar, m.degree());
        }
        this.degree = ListPolynomial.degree(this);
        this.sugar = sugar;
    }

    void init(Generic generic) {
        if (generic instanceof Expression) {
            this.init((Expression)generic);
        } else {
            Generic a = this.coefficient(generic);
            if (a.signum() != 0) {
                this.content.add(new Term(this.monomial(Literal.valueOf()), a));
            }
            this.degree = 0;
            this.sugar = 0;
        }
    }

    void init(Monomial monomial) {
        this.content.add(new Term(monomial, this.coefficient(JSCLInteger.valueOf(1L))));
        this.degree = monomial.degree();
        this.sugar = monomial.degree();
    }

    protected ListPolynomial newinstance(int n) {
        return new ListPolynomial(this.monomialFactory, this.coefFactory);
    }

    class ContentIterator
    implements ListIterator {
        final ListIterator iterator;
        final boolean direction;

        ContentIterator(boolean direction, Monomial current) {
            this.direction = direction;
            this.iterator = ListPolynomial.this.content.listIterator(current == null ? (direction ? ListPolynomial.this.content.size() : 0) : ListPolynomial.this.indexOf(current));
        }

        public boolean hasNext() {
            return this.direction ? this.iterator.hasPrevious() : this.iterator.hasNext();
        }

        public Object next() {
            return this.direction ? this.iterator.previous() : this.iterator.next();
        }

        public boolean hasPrevious() {
            return this.direction ? this.iterator.hasNext() : this.iterator.hasPrevious();
        }

        public Object previous() {
            return this.direction ? this.iterator.next() : this.iterator.previous();
        }

        public int nextIndex() {
            return this.direction ? this.iterator.previousIndex() : this.iterator.nextIndex();
        }

        public int previousIndex() {
            return this.direction ? this.iterator.nextIndex() : this.iterator.previousIndex();
        }

        public void remove() {
            this.iterator.remove();
        }

        public void set(Object o) {
            this.iterator.set(o);
        }

        public void add(Object o) {
            this.iterator.add(o);
        }
    }
}

