/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import jscl.math.Expression;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotExpressionException;
import jscl.math.NotIntegerException;
import jscl.math.NotIntegrableException;
import jscl.math.NotPowerException;
import jscl.math.NotProductException;
import jscl.math.NotVariableException;
import jscl.math.Power;
import jscl.math.Variable;
import jscl.math.polynomial.NestedPolynomial;
import jscl.math.polynomial.Polynomial;
import jscl.mathml.MathML;

final class PolynomialWrapper
extends Generic {
    final Polynomial content;

    PolynomialWrapper(Polynomial polynomial) {
        this.content = polynomial;
    }

    Polynomial content() {
        return this.content;
    }

    public PolynomialWrapper add(PolynomialWrapper wrapper) {
        return new PolynomialWrapper(this.content.add(wrapper.content));
    }

    public Generic add(Generic generic) {
        if (generic instanceof PolynomialWrapper) {
            return this.add((PolynomialWrapper)generic);
        }
        return this.add(this.valueof(generic));
    }

    public PolynomialWrapper subtract(PolynomialWrapper wrapper) {
        return new PolynomialWrapper(this.content.subtract(wrapper.content));
    }

    public Generic subtract(Generic generic) {
        if (generic instanceof PolynomialWrapper) {
            return this.subtract((PolynomialWrapper)generic);
        }
        return this.subtract(this.valueof(generic));
    }

    public PolynomialWrapper multiply(PolynomialWrapper wrapper) {
        return new PolynomialWrapper(this.content.multiply(wrapper.content));
    }

    public Generic multiply(Generic generic) {
        if (generic instanceof PolynomialWrapper) {
            return this.multiply((PolynomialWrapper)generic);
        }
        return this.multiply(this.valueof(generic));
    }

    public PolynomialWrapper divide(PolynomialWrapper wrapper) throws ArithmeticException {
        return new PolynomialWrapper(this.content.divide(wrapper.content));
    }

    public Generic divide(Generic generic) throws ArithmeticException {
        if (generic instanceof PolynomialWrapper) {
            return this.divide((PolynomialWrapper)generic);
        }
        return this.divide(this.valueof(generic));
    }

    public PolynomialWrapper gcd(PolynomialWrapper wrapper) {
        return new PolynomialWrapper(this.content.gcd(wrapper.content));
    }

    public Generic gcd(Generic generic) {
        if (generic instanceof PolynomialWrapper) {
            return this.gcd((PolynomialWrapper)generic);
        }
        return this.gcd(this.valueof(generic));
    }

    public Generic gcd() {
        return this.content.gcd();
    }

    public Generic negate() {
        return new PolynomialWrapper(this.content.negate());
    }

    public int signum() {
        return this.content.signum();
    }

    public int degree() {
        return this.content.degree();
    }

    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        return null;
    }

    public Generic derivative(Variable variable) {
        return null;
    }

    public Generic substitute(Variable variable, Generic generic) {
        return null;
    }

    public Generic expand() {
        return null;
    }

    public Generic factorize() {
        return null;
    }

    public Generic elementary() {
        return null;
    }

    public Generic simplify() {
        return null;
    }

    public Generic numeric() {
        return null;
    }

    public Generic valueof(Generic generic) {
        if (generic instanceof PolynomialWrapper) {
            return new PolynomialWrapper(this.content.valueof(((PolynomialWrapper)generic).content));
        }
        return new PolynomialWrapper(this.content.valueof(generic));
    }

    public Generic[] sumValue() {
        return null;
    }

    public Generic[] productValue() throws NotProductException {
        return null;
    }

    public Power powerValue() throws NotPowerException {
        return null;
    }

    public Expression expressionValue() throws NotExpressionException {
        return this.content.genericValue().expressionValue();
    }

    public JSCLInteger integerValue() throws NotIntegerException {
        throw new NotIntegerException();
    }

    public Variable variableValue() throws NotVariableException {
        throw new NotVariableException();
    }

    public Variable[] variables() {
        return new Variable[0];
    }

    public boolean isPolynomial(Variable variable) {
        return false;
    }

    public boolean isConstant(Variable variable) {
        return false;
    }

    public int compareTo(PolynomialWrapper wrapper) {
        return this.content.compareTo(wrapper.content);
    }

    public int compareTo(Generic generic) {
        if (generic instanceof PolynomialWrapper) {
            return this.compareTo((PolynomialWrapper)generic);
        }
        return this.compareTo(this.valueof(generic));
    }

    public static Generic factory(Variable[] variable) {
        if (variable.length > 1) {
            Variable[] var = new Variable[variable.length - 1];
            for (int i = 0; i < var.length; ++i) {
                var[i] = variable[i + 1];
            }
            return new PolynomialWrapper(NestedPolynomial.factory(var));
        }
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.signum() < 0) {
            buffer.append("-").append(this.negate());
        } else {
            buffer.append("(").append(this.content).append(")");
        }
        return buffer.toString();
    }

    public String toJava() {
        return null;
    }

    public void toMathML(MathML element, Object data) {
    }
}

