/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import jscl.math.NotDivisibleException;
import jscl.math.Variable;
import jscl.math.polynomial.DegreeReverseLexicographic;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Ordering;
import jscl.math.polynomial.SmallDegreeReverseLexicographic;
import jscl.math.polynomial.SmallLexicographic;
import jscl.math.polynomial.SmallTotalDegreeLexicographic;

class SmallMonomial
extends Monomial {
    static final Ordering lexicographic = SmallLexicographic.ordering;
    static final Ordering totalDegreeLexicographic = SmallTotalDegreeLexicographic.ordering;
    static final Ordering degreeReverseLexicographic = SmallDegreeReverseLexicographic.ordering;
    static final int log2n = 3;
    static final int log2p = 2;
    static final int nmask = 255;
    static final int pmask = 3;

    SmallMonomial(Variable[] unknown, Ordering ordering) {
        this((unknown.length - 1 >> 2) + 1, unknown, ordering);
    }

    SmallMonomial(int length, Variable[] unknown, Ordering ordering) {
        super(length, unknown, ordering);
    }

    public Monomial multiply(Monomial monomial) {
        Monomial m = this.newinstance();
        for (int i = 0; i < this.unknown.length; ++i) {
            int q = i >> 2;
            int r = (i & 3) << 3;
            int a = this.element[q] >> r & 0xFF;
            int b = monomial.element[q] >> r & 0xFF;
            int c = a + b;
            if (c > 255) {
                throw new ArithmeticException();
            }
            int n = q;
            m.element[n] = m.element[n] | c << r;
            m.degree += c;
        }
        return m;
    }

    public boolean multiple(Monomial monomial, boolean strict) {
        boolean equal = true;
        for (int i = 0; i < this.unknown.length; ++i) {
            int q = i >> 2;
            int r = (i & 3) << 3;
            int a = this.element[q] >> r & 0xFF;
            int b = monomial.element[q] >> r & 0xFF;
            if (a < b) {
                return false;
            }
            equal &= a == b;
        }
        return strict ? !equal : true;
    }

    public Monomial divide(Monomial monomial) throws ArithmeticException {
        Monomial m = this.newinstance();
        for (int i = 0; i < this.unknown.length; ++i) {
            int q = i >> 2;
            int r = (i & 3) << 3;
            int a = this.element[q] >> r & 0xFF;
            int b = monomial.element[q] >> r & 0xFF;
            int c = a - b;
            if (c < 0) {
                throw new NotDivisibleException();
            }
            int n = q;
            m.element[n] = m.element[n] | c << r;
        }
        m.degree = this.degree - monomial.degree;
        return m;
    }

    public Monomial gcd(Monomial monomial) {
        Monomial m = this.newinstance();
        for (int i = 0; i < this.unknown.length; ++i) {
            int q = i >> 2;
            int r = (i & 3) << 3;
            int a = this.element[q] >> r & 0xFF;
            int b = monomial.element[q] >> r & 0xFF;
            int c = Math.min(a, b);
            int n = q;
            m.element[n] = m.element[n] | c << r;
            m.degree += c;
        }
        return m;
    }

    public Monomial scm(Monomial monomial) {
        Monomial m = this.newinstance();
        for (int i = 0; i < this.unknown.length; ++i) {
            int q = i >> 2;
            int r = (i & 3) << 3;
            int a = this.element[q] >> r & 0xFF;
            int b = monomial.element[q] >> r & 0xFF;
            int c = Math.max(a, b);
            int n = q;
            m.element[n] = m.element[n] | c << r;
            m.degree += c;
        }
        return m;
    }

    public int element(int n) {
        if (this.reverse()) {
            n = this.unknown.length - 1 - n;
        }
        int q = n >> 2;
        int r = (n & 3) << 3;
        return this.element[q] >> r & 0xFF;
    }

    void put(int n, int integer) {
        int r;
        int q;
        int a;
        int c;
        if (this.reverse()) {
            n = this.unknown.length - 1 - n;
        }
        if ((c = (a = this.element[q = n >> 2] >> (r = (n & 3) << 3) & 0xFF) + integer) > 255) {
            throw new ArithmeticException();
        }
        int n2 = q;
        this.element[n2] = this.element[n2] | c << r;
        this.degree += c - a;
    }

    boolean reverse() {
        return this.ordering instanceof DegreeReverseLexicographic;
    }

    protected Monomial newinstance() {
        return new SmallMonomial(this.element.length, this.unknown, this.ordering);
    }
}

