/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import jscl.math.Expression;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.Literal;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Polynomial;
import jscl.math.polynomial.Term;

final class TreePolynomial
extends Polynomial {
    final SortedMap content = new TreeMap(this.ordering);
    int degree;
    boolean mutable = true;

    TreePolynomial(Monomial monomialFactory, Generic coefFactory) {
        super(monomialFactory, coefFactory);
    }

    public int size() {
        return this.content.size();
    }

    public Iterator iterator(boolean direction, Monomial current) {
        return new ContentIterator(direction, current);
    }

    Term term(Map.Entry entry) {
        return new Term((Monomial)entry.getKey(), (Generic)entry.getValue());
    }

    Term term(Monomial monomial) {
        return new Term(monomial, null){

            public Generic coef() {
                return this.coef == null ? TreePolynomial.this.coefficient(this.monomial) : this.coef;
            }
        };
    }

    public Polynomial subtract(Polynomial polynomial) {
        if (polynomial.signum() == 0) {
            return this;
        }
        if (this.mutable) {
            TreePolynomial q = (TreePolynomial)polynomial;
            Iterator it = q.content.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                Monomial m = (Monomial)e.getKey();
                Generic a = (Generic)e.getValue();
                Generic s = this.coefficient(m).subtract(a);
                if (s.signum() == 0) {
                    this.content.remove(m);
                    continue;
                }
                this.content.put(m, s);
            }
            this.degree = TreePolynomial.degree(this);
            this.sugar = Math.max(this.sugar, q.sugar);
            this.normalized = false;
            return this;
        }
        return this.copy().subtract(polynomial);
    }

    public Polynomial multiplyAndSubtract(Generic generic, Polynomial polynomial) {
        if (generic.signum() == 0) {
            return this;
        }
        if (generic.compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return this.subtract(polynomial);
        }
        if (this.mutable) {
            TreePolynomial q = (TreePolynomial)polynomial;
            Iterator it = q.content.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                Monomial m = (Monomial)e.getKey();
                Generic a = ((Generic)e.getValue()).multiply(generic);
                Generic s = this.coefficient(m).subtract(a);
                if (s.signum() == 0) {
                    this.content.remove(m);
                    continue;
                }
                this.content.put(m, s);
            }
            this.degree = TreePolynomial.degree(this);
            this.sugar = Math.max(this.sugar, q.sugar);
            this.normalized = false;
            return this;
        }
        return this.copy().multiplyAndSubtract(generic, polynomial);
    }

    public Polynomial multiplyAndSubtract(Monomial monomial, Generic generic, Polynomial polynomial) {
        if (generic.signum() == 0) {
            return this;
        }
        if (monomial.degree() == 0) {
            return this.multiplyAndSubtract(generic, polynomial);
        }
        if (this.mutable) {
            TreePolynomial q = (TreePolynomial)polynomial;
            Iterator it = q.content.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                Monomial m = ((Monomial)e.getKey()).multiply(monomial);
                Generic a = ((Generic)e.getValue()).multiply(generic);
                Generic s = this.coefficient(m).subtract(a);
                if (s.signum() == 0) {
                    this.content.remove(m);
                    continue;
                }
                this.content.put(m, s);
            }
            this.degree = TreePolynomial.degree(this);
            this.sugar = Math.max(this.sugar, q.sugar + monomial.degree());
            this.normalized = false;
            return this;
        }
        return this.copy().multiplyAndSubtract(monomial, generic, polynomial);
    }

    public Polynomial multiply(Generic generic) {
        if (generic.signum() == 0) {
            return this.valueof(JSCLInteger.valueOf(0L));
        }
        if (generic.compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return this;
        }
        if (this.mutable) {
            Iterator it = this.content.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                e.setValue(((Generic)e.getValue()).multiply(generic));
            }
            this.normalized = false;
            return this;
        }
        return this.copy().multiply(generic);
    }

    public Polynomial multiply(Monomial monomial) {
        if (this.defined) {
            TreePolynomial p = this.newinstance();
            Iterator it = this.content.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                Monomial m = ((Monomial)e.getKey()).multiply(monomial);
                Generic a = (Generic)e.getValue();
                Generic s = p.coefficient(m).add(a);
                if (s.signum() == 0) {
                    p.content.remove(m);
                    continue;
                }
                p.content.put(m, s);
            }
            p.degree = TreePolynomial.degree(p);
            p.sugar = this.sugar + monomial.degree();
            return p;
        }
        if (monomial.degree() == 0) {
            return this;
        }
        TreePolynomial p = this.newinstance();
        Iterator it = this.content.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            p.content.put(((Monomial)e.getKey()).multiply(monomial), (Generic)e.getValue());
        }
        p.degree = this.degree + monomial.degree();
        p.sugar = this.sugar + monomial.degree();
        return p;
    }

    public Polynomial divide(Generic generic) throws ArithmeticException {
        if (generic.compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return this;
        }
        if (this.mutable) {
            Iterator it = this.content.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                e.setValue(((Generic)e.getValue()).divide(generic));
            }
            this.normalized = false;
            return this;
        }
        return this.copy().divide(generic);
    }

    public Polynomial divide(Monomial monomial) throws ArithmeticException {
        if (monomial.degree() == 0) {
            return this;
        }
        TreePolynomial p = this.newinstance();
        Iterator it = this.content.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            p.content.put(((Monomial)e.getKey()).divide(monomial), (Generic)e.getValue());
        }
        p.degree = this.degree + monomial.degree();
        p.sugar = this.sugar + monomial.degree();
        return p;
    }

    public Polynomial gcd(Polynomial polynomial) {
        throw new UnsupportedOperationException();
    }

    public int degree() {
        return this.degree;
    }

    public Polynomial valueof(Polynomial polynomial) {
        TreePolynomial p = this.newinstance();
        p.init(polynomial);
        return p;
    }

    public Polynomial valueof(Generic generic) {
        TreePolynomial p = this.newinstance();
        p.init(generic);
        return p;
    }

    public Polynomial valueof(Monomial monomial) {
        TreePolynomial p = this.newinstance();
        p.init(monomial);
        return p;
    }

    public Polynomial freeze() {
        this.mutable = false;
        return this;
    }

    public Term head() {
        return this.content.size() > 0 ? this.term((Monomial)this.content.lastKey()) : null;
    }

    public Term tail() {
        return this.content.size() > 0 ? this.term((Monomial)this.content.firstKey()) : null;
    }

    public Generic coefficient(Monomial monomial) {
        Generic a = (Generic)this.content.get(monomial);
        return a == null ? this.coefficient(JSCLInteger.valueOf(0L)) : a;
    }

    void init(Polynomial polynomial) {
        TreePolynomial q = (TreePolynomial)polynomial;
        this.content.putAll(q.content);
        this.degree = q.degree;
        this.sugar = q.sugar;
    }

    void init(Expression expression) {
        int sugar = 0;
        int n = expression.size();
        for (int i = 0; i < n; ++i) {
            Literal l = expression.literal(i);
            JSCLInteger en = expression.coef(i);
            Monomial m = this.monomial(l);
            Generic a2 = this.coefficient((l = l.divide(m.literalValue())).degree() > 0 ? en.multiply(Expression.valueOf(l)) : en);
            Generic a1 = this.coefficient(m);
            Generic a = a1.add(a2);
            if (a.signum() == 0) {
                this.content.remove(m);
            } else {
                this.content.put(m, a);
            }
            sugar = Math.max(sugar, m.degree());
        }
        this.degree = TreePolynomial.degree(this);
        this.sugar = sugar;
    }

    void init(Generic generic) {
        if (generic instanceof Expression) {
            this.init((Expression)generic);
        } else {
            Generic a = this.coefficient(generic);
            if (a.signum() != 0) {
                this.content.put(this.monomial(Literal.valueOf()), a);
            }
            this.degree = 0;
            this.sugar = 0;
        }
    }

    void init(Monomial monomial) {
        this.content.put(monomial, this.coefficient(JSCLInteger.valueOf(1L)));
        this.degree = monomial.degree();
        this.sugar = monomial.degree();
    }

    protected TreePolynomial newinstance() {
        return new TreePolynomial(this.monomialFactory, this.coefFactory);
    }

    class ContentIterator
    implements Iterator {
        final boolean direction;
        final Iterator iterator;
        SortedMap map;

        ContentIterator(boolean direction, Monomial current) {
            this.direction = direction;
            if (direction) {
                this.iterator = null;
                this.map = current == null ? TreePolynomial.this.content : TreePolynomial.this.content.headMap(current);
            } else {
                this.map = current == null ? TreePolynomial.this.content : TreePolynomial.this.content.tailMap(current);
                this.iterator = this.map.entrySet().iterator();
            }
        }

        public boolean hasNext() {
            return this.direction ? this.map.size() > 0 : this.iterator.hasNext();
        }

        public Object next() {
            if (this.direction) {
                Monomial m = (Monomial)this.map.lastKey();
                this.map = TreePolynomial.this.content.headMap(m);
                return TreePolynomial.this.term(m);
            }
            return TreePolynomial.this.term((Map.Entry)this.iterator.next());
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

