/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial.groebner;

import java.util.Iterator;
import java.util.List;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Polynomial;
import jscl.math.polynomial.groebner.F4Reduction;
import jscl.math.polynomial.groebner.Pair;

class Projection
implements Comparable {
    final Monomial monomial;
    final Polynomial polynomial;

    Projection(Pair pair, int index) {
        this(pair.scm.divide(pair.monomial[index]), pair.polynomial[index]);
    }

    Projection(Monomial monomial, Polynomial polynomial) {
        this.monomial = monomial;
        this.polynomial = polynomial;
    }

    Monomial scm() {
        return this.polynomial.head().monomial().multiply(this.monomial);
    }

    Polynomial mult() {
        return this.polynomial.multiply(this.monomial);
    }

    Projection simplify(List list) {
        Monomial t = this.monomial;
        if (t.degree() > 0) {
            Monomial m = this.polynomial.head().monomial();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                List ideal = ((F4Reduction)list.get((int)i)).polys;
                Iterator it = ideal.iterator();
                while (it.hasNext()) {
                    Polynomial p = (Polynomial)it.next();
                    Monomial u = p.head().monomial();
                    if (!u.multiple(m, true) || !t.multiple(u = u.divide(m), true)) continue;
                    Projection pr = new Projection(t.divide(u), p).simplify(list);
                    return pr;
                }
            }
        }
        return this;
    }

    public int compareTo(Projection proj) {
        int c = this.monomial.compareTo(proj.monomial);
        if (c < 0) {
            return -1;
        }
        if (c > 0) {
            return 1;
        }
        c = this.polynomial.index() - proj.polynomial.index();
        if (c < 0) {
            return -1;
        }
        if (c > 0) {
            return 1;
        }
        return 0;
    }

    public int compareTo(Object o) {
        return this.compareTo((Projection)o);
    }

    public String toString() {
        return "{" + this.monomial + ", " + this.polynomial.head().monomial() + "}";
    }
}

